/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILBetterModScan;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILLoaderJar;
import net.neoforged.fml.loading.ClasspathLocatorUtils;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoForgeModLoading {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"NeoForge Mod Loading");
    static final BiConsumer<TILBetterModScan, Object> AFTER_WRITING_MODS = (scan, language) -> {
        LOGGER.debug("Injecting scan data into the language loader");
        Consumer visitor = (Consumer)Hacks.invokeDirect(language, "getFileVisitor", new Object[0]);
        if (Objects.nonNull(visitor)) {
            visitor.accept(scan);
        }
    };
    static final Map<MultiVersionModCandidate, IModFile> CANDIDATE_MAP = new HashMap<MultiVersionModCandidate, IModFile>();
    static final Map<IModFile, Map<MultiVersionModInfo, MultiVersionModData>> FILE_INFO_MAP = new HashMap<IModFile, Map<MultiVersionModInfo, MultiVersionModData>>();
    static final Map<String, Manifest> MANIFEST_MAP = new HashMap<String, Manifest>();
    static final Map<String, SecureJar> SECURE_JAR_MAP = new HashMap<String, SecureJar>();
    static final Collection<Object> IDENTIFIED_FILES = new HashSet<Object>();
    static final Collection<IModFile> LOADER_FILES = new ArrayList<IModFile>();
    static final boolean JAVA_21 = NeoForgeCoreLoader.isJava21();
    static final String MOD_SCAN_PKG = "net.neoforged.fml.loading.mod" + (JAVA_21 ? "scan" : "discovery");
    static final String COREMOD_ENGINE = "net.neoforged.coremod.CoreMod" + (JAVA_21 ? "Scripting" : "") + "Engine";
    static final String MOD_CLASS_VISITOR = MOD_SCAN_PKG + ".ModClassVisitor";
    static final String MOD_FILE_DISCOVERY_ATTRIBUTES = "net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes";
    static final String MOD_FILE_INFO_PARSER = "net.neoforged.neoforgespi.locating." + (JAVA_21 ? "" : "ModFileFactory$") + "ModFileInfoParser";
    static final String MOD_FILE_OR_EXCEPTION = "net.neoforged.neoforgespi.locating.IModLocator$ModFileOrException";
    static final String MOD_PROVIDER = "net.neoforged.neoforgespi.locating.IModProvider";
    static final String NIGHT_CONFIG_WRAPPER = "net.neoforged.fml.loading.moddiscovery.NightConfigWrapper";
    static final String SCANNER = MOD_SCAN_PKG + ".Scanner";
    static final String SELF_ENTRYPOINT = "mods.thecomputerizer.theimpossiblelibrary.api.common.TILCommonEntryPoint";
    static Attributes.Name automaticModuleName;
    static Class<?> dynamicModFileClass;
    static Set<String> coreModExtensions;
    static boolean fixedCoreMods;
    static MultiVersionModCandidate loaderCandidate;
    static String workingVersion;

    private static <F> void addScannedMod(IModFile file, List<F> mods, String type) {
        Hacks.setFieldDirect(file, "modFileType", NeoForgeModLoading.getModFileType(type));
        if (JAVA_21) {
            mods.add(GenericUtils.cast(file));
        } else {
            mods.add(Hacks.construct(MOD_FILE_OR_EXCEPTION, file, null));
        }
    }

    private static JarContents buildJarContents(Object contentsOrPath, String moduleName) {
        JarContents contents;
        return contentsOrPath instanceof JarContents ? (contents = (JarContents)contentsOrPath) : NeoForgeModLoading.buildJarContents(moduleName, (Path)contentsOrPath);
    }

    public static JarContents buildJarContents(String moduleName, Path ... paths) {
        return new JarContentsBuilder().paths(paths).defaultManifest(NeoForgeModLoading.getDefaultManifest(moduleName)).build();
    }

    static void checkPath(MultiVersionLoaderAPI loader, Path path, Predicate<Path> filter) {
        String loaderName = loader.getName();
        LOGGER.debug("[{}]: Checking if {} is the loader", (Object)loaderName, (Object)path);
        if (Objects.isNull(MultiVersionModCandidate.getLoaderFile()) && TILDev.isLoaderPath(path)) {
            LOGGER.debug("[{}]: File is the loader", (Object)loaderName);
            MultiVersionModCandidate.setLoaderPath(path);
        }
        if (filter.test(path)) {
            LOGGER.info("[{}]: Found mod candidate at {}", (Object)loaderName, (Object)path);
            loader.addPotentialModPath(path);
        }
    }

    static void checkURL(MultiVersionLoaderAPI loader, URL url, Predicate<Path> filter) {
        LOGGER.debug("[{}]: Checking URL {} for MANIFEST {}", new Object[]{loader.getName(), url, "META-INF/MANIFEST.MF"});
        NeoForgeModLoading.checkPath(loader, ClasspathLocatorUtils.findJarPathFor((String)"META-INF/MANIFEST.MF", (String)"META-INF/MANIFEST.MF", (URL)url), filter);
    }

    public static Object createDiscoveryAttributes(Object readerOrLocator) {
        if (Objects.isNull(readerOrLocator)) {
            LOGGER.warn("Returning DEFAULT {} instance", (Object)MOD_FILE_DISCOVERY_ATTRIBUTES);
            return Hacks.getFieldStatic(MOD_FILE_DISCOVERY_ATTRIBUTES, "DEFAULT");
        }
        String simpleClassName = readerOrLocator.getClass().getSimpleName();
        if ("ModFileDiscoveryAttributes".equals(simpleClassName)) {
            return readerOrLocator;
        }
        return "MultiVersionModReader".equals(simpleClassName) ? Hacks.construct(MOD_FILE_DISCOVERY_ATTRIBUTES, null, readerOrLocator, null, null) : Hacks.construct(MOD_FILE_DISCOVERY_ATTRIBUTES, null, null, readerOrLocator, null);
    }

    public static Supplier<Manifest> createLoaderManfiest(Path sourcePath) {
        if (!TILDev.DEV || Objects.isNull(sourcePath) || !TILDev.isLoaderPath(sourcePath)) {
            return null;
        }
        return () -> {
            LOGGER.info("Creating loader manifest for {}", (Object)sourcePath);
            return NeoForgeModLoading.getDefaultManifest("theimpossiblelibrary").get();
        };
    }

    public static IModFile[] createLoaderFiles(JarContents[] contents, Object locator, MultiVersionModCandidate candidate, Collection<?> infos) {
        loaderCandidate = candidate;
        IModFile modFile = NeoForgeModLoading.createModFile((Object)contents[0], locator, (IModFile f) -> NeoForgeModLoading.getFileInfo(f, infos), IModFile.Type.MOD, "theimpossiblelibrary");
        FILE_INFO_MAP.put(modFile, NeoForgeModLoading.initInfoMap(candidate, infos));
        if (Objects.isNull(modFile)) {
            return new IModFile[0];
        }
        IModFile langFile = NeoForgeModLoading.createModFile((Object)contents[1], locator, NeoForgeModLoading::langFileInfo, IModFile.Type.LIBRARY, "theimpossibleloader");
        IModFile[] files = new IModFile[]{langFile, modFile};
        LOADER_FILES.addAll(List.of(files));
        return files;
    }

    static IModFile createModFile(IModFile reference, Function<IModFile, IModFileInfo> parser, String type, String moduleName) {
        Object locator = Hacks.invoke(reference, "getProvider", new Object[0]);
        return NeoForgeModLoading.createModFile((Object)reference.getFilePath(), locator, parser, type, moduleName);
    }

    public static IModFile createModFile(Object pathOrJarContents, Object locator, MultiVersionModCandidate candidate, Collection<?> infos, IModFile.Type type) {
        String moduleName = NeoForgeModLoading.getFirstModId(candidate, infos);
        IModFile file = NeoForgeModLoading.createModFile(pathOrJarContents, locator, (IModFile f) -> NeoForgeModLoading.getFileInfo(f, infos), type, moduleName);
        CANDIDATE_MAP.put(candidate, file);
        FILE_INFO_MAP.put(file, NeoForgeModLoading.initInfoMap(candidate, infos));
        return file;
    }

    private static IModFile createModFile(Object pathOrJarContents, Object locator, Function<IModFile, IModFileInfo> parserFunc, Object type, String moduleName) {
        IModFile file;
        if (Objects.isNull(dynamicModFileClass)) {
            LOGGER.error("Cannot create ModFile with null dynamicModFileClass! Did it fail to initialize?");
            return null;
        }
        LOGGER.debug("Creating mod file of type {} with module name {} at path {}", new Object[]{type, moduleName, pathOrJarContents});
        SecureJar jar = pathOrJarContents instanceof SecureJar ? (SecureJar)pathOrJarContents : null;
        boolean updatePathMap = false;
        if (Objects.nonNull(moduleName)) {
            if (SECURE_JAR_MAP.containsKey(moduleName)) {
                if (Objects.isNull(jar)) {
                    LOGGER.debug("Found existing SecureJar for module {}", (Object)moduleName);
                    jar = SECURE_JAR_MAP.get(moduleName);
                }
            } else {
                updatePathMap = true;
            }
        }
        if (Objects.isNull(jar)) {
            jar = NeoForgeModLoading.getDefaultJar(NeoForgeModLoading.buildJarContents(pathOrJarContents, moduleName), moduleName);
        }
        Object parser = ClassHelper.newGenericProxy(Hacks.findClass(MOD_FILE_INFO_PARSER), "build", args -> parserFunc.apply((IModFile)args[0]));
        if (JAVA_21) {
            Object discoveryAttributes = NeoForgeModLoading.createDiscoveryAttributes(locator);
            file = (IModFile)Hacks.constructAndCast(dynamicModFileClass, jar, parser, type, discoveryAttributes);
            NeoForgeModLoading.updateDiscoveryAttributes(file, "withParent", (Object)file);
        } else {
            file = (IModFile)Hacks.constructAndCast(dynamicModFileClass, jar, locator, parser, type);
        }
        if (updatePathMap) {
            LOGGER.debug("Adding SecureJar instance for module {} to the cache", (Object)moduleName);
            SECURE_JAR_MAP.put(moduleName, jar);
        }
        return file;
    }

    @Nullable
    static Class<?> dynamicModFileCreator() {
        String pkgName = NeoForgeCoreLoader.class.getPackage().getName();
        String className = pkgName + ".TILNeoForgeModFile";
        byte[] byteCode = NeoForgeModLoading.generateModFileExtension(className);
        if (Objects.isNull(byteCode)) {
            LOGGER.error("Failed to define bytecode for {}", (Object)className);
            return null;
        }
        ASMHelper.writeDebugByteCode(className, byteCode);
        LOGGER.info("Successfully generated bytecode for {}", (Object)className);
        try {
            Class<?> defined = ClassHelper.defineAndResolveClass(ModFile.class.getClassLoader(), className, byteCode);
            Hacks.setFieldDirect(defined, "module", Hacks.invoke(NeoForgeModLoading.class, "getModule", new Object[0]));
            LOGGER.info("Successfully generated ModFile extension {}", defined);
            return defined;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to generate ModFile extension {}", (Object)className, (Object)t);
            return null;
        }
    }

    static void findFiles(MultiVersionLoaderAPI loader, Predicate<Path> filter, File ... files) {
        TILRef.logInfo("[{}]: Loading {} mod files", loader.getName(), files.length);
        for (File mod : files) {
            TILRef.logDebug("[{}]: Potentially loading mod file at path {}", loader.getName(), mod.toPath());
            NeoForgeModLoading.checkPath(loader, mod.toPath(), filter);
        }
    }

    public static Optional<Manifest> findManifest(Path path) {
        return NeoForgeModLoading.findManifest(path, NeoForgeModLoading.createLoaderManfiest(path));
    }

    public static Optional<Manifest> findManifest(Path path, @Nullable Supplier<Manifest> fallback) {
        Optional<Manifest> optionalManifest = Optional.empty();
        try {
            File file = path.toFile();
            if (!file.exists()) {
                LOGGER.warn("Tried to find manifest of nonexistant path {}", (Object)path);
            } else if (file.isDirectory()) {
                File manifest = new File(file, "META-INF/MANIFEST.MF");
                if (manifest.exists()) {
                    optionalManifest = Optional.ofNullable(NeoForgeModLoading.parseManifest(manifest));
                } else {
                    LOGGER.warn("Manifest not found at {}", (Object)manifest);
                }
            } else {
                optionalManifest = Optional.ofNullable(SecureJar.from((Path[])new Path[]{path}).moduleDataProvider().getManifest());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find manifest for {}", (Object)path, (Object)t);
        }
        return optionalManifest.isPresent() || Objects.isNull(fallback) ? optionalManifest : Optional.ofNullable(fallback.get());
    }

    public static void findPaths(ClassLoader classLoader, MultiVersionLoaderAPI loader) {
        Predicate<Path> filter = path -> {
            if (Objects.isNull(path)) {
                return false;
            }
            Manifest manifest = NeoForgeModLoading.findManifest(path).orElse(null);
            if (Objects.isNull(manifest)) {
                return false;
            }
            return MultiVersionModFinder.hasMods(manifest.getMainAttributes());
        };
        NeoForgeModLoading.findURLs(loader, classLoader, filter);
        NeoForgeModLoading.findFiles(loader, filter, FileHelper.list(loader.findModRoot(), File::isFile));
    }

    static void findURLs(MultiVersionLoaderAPI loader, ClassLoader classLoader, Predicate<Path> filter) {
        try {
            Enumeration<URL> manifests = ClassLoader.getSystemClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                NeoForgeModLoading.checkURL(loader, manifests.nextElement(), filter);
            }
        }
        catch (IOException ex) {
            TILRef.logError("[{}]: Failed to calculate URLs for paths with {} using {}", loader.getName(), "META-INF/MANIFEST.MF", classLoader, ex);
        }
    }

    private static void fixCoreModPackages() {
        Function fieldGetter = f -> (Collection)Hacks.getFieldStaticDirect(COREMOD_ENGINE, f);
        Hacks.addToCollectionField("ALLOWED_PACKAGES", coreModExtensions, fieldGetter, (f, allowed) -> LOGGER.debug("Expanded coremod package whitelist to {}", allowed));
    }

    private static byte[] generateModFileExtension(String className) {
        int i;
        int javaVer = NeoForgeCoreLoader.isJava21() ? 65 : 61;
        ClassWriter writer = ASMHelper.getWriter(javaVer, 1, TypeHelper.fromBinary(className), TypeHelper.get(ModFile.class));
        Class[] constructorArgTypes = new Class[]{SecureJar.class, null, null, String.class};
        if (JAVA_21) {
            constructorArgTypes[1] = Hacks.findClass(MOD_FILE_INFO_PARSER);
            constructorArgTypes[2] = IModFile.Type.class;
            constructorArgTypes[3] = Hacks.findClass(MOD_FILE_DISCOVERY_ATTRIBUTES);
        } else {
            constructorArgTypes[1] = Hacks.findClass(MOD_PROVIDER);
            constructorArgTypes[2] = Hacks.findClass(MOD_FILE_INFO_PARSER);
        }
        String constructorDesc = TypeHelper.voidMethodDesc(constructorArgTypes);
        String modFile = TypeHelper.get(ModFile.class).getInternalName();
        String modLoading = TypeHelper.get(NeoForgeModLoading.class).getInternalName();
        String writeModsDesc = TypeHelper.methodDesc(ModFileScanData.class, ModFile.class);
        String identifyModsDesc = TypeHelper.methodDesc(Type.BOOLEAN_TYPE, TypeHelper.get(IModFile.class));
        MethodVisitor constructor = writer.visitMethod(1, "<init>", constructorDesc, null, null);
        constructor.visitCode();
        for (int i2 = 0; i2 < 5; ++i2) {
            constructor.visitVarInsn(25, i2);
        }
        constructor.visitMethodInsn(183, modFile, "<init>", constructorDesc, false);
        constructor.visitInsn(177);
        ASMHelper.finishMethod(constructor);
        MethodVisitor compileContent = writer.visitMethod(1, "compileContent", TypeHelper.methodDesc(ModFileScanData.class), null, null);
        compileContent.visitCode();
        compileContent.visitVarInsn(25, 0);
        compileContent.visitMethodInsn(184, modLoading, "writeMods", writeModsDesc, false);
        compileContent.visitInsn(176);
        ASMHelper.finishMethod(compileContent);
        MethodVisitor identifyMods = writer.visitMethod(1, "identifyMods", "()Z", null, null);
        identifyMods.visitCode();
        identifyMods.visitVarInsn(25, 0);
        identifyMods.visitMethodInsn(184, modLoading, "identifyMods", identifyModsDesc, false);
        identifyMods.visitInsn(172);
        ASMHelper.finishMethod(identifyMods);
        String findResourceDesc = TypeHelper.methodDesc(Path.class, String[].class);
        String queryCoreModsDesc = TypeHelper.voidMethodDesc(String[].class);
        MethodVisitor findResource = writer.visitMethod(1, "findResource", findResourceDesc, null, null);
        findResource.visitCode();
        for (i = 0; i < 2; ++i) {
            findResource.visitVarInsn(25, i);
        }
        findResource.visitMethodInsn(184, modLoading, "queryCoreMods", queryCoreModsDesc, false);
        for (i = 0; i < 2; ++i) {
            findResource.visitVarInsn(25, i);
        }
        findResource.visitMethodInsn(183, modFile, "findResource", findResourceDesc, false);
        findResource.visitInsn(176);
        ASMHelper.finishMethod(findResource);
        return writer.toByteArray();
    }

    private static SecureJar getDefaultJar(JarContents contents, String moduleName) {
        return "theimpossibleloader".equals(moduleName) || "theimpossiblelibrary".equals(moduleName) ? TILLoaderJar.get(contents, moduleName) : SecureJar.from((JarContents)contents, (JarMetadata)JarMetadata.from((JarContents)contents));
    }

    private static Supplier<Manifest> getDefaultManifest(String automaticModuleName) {
        return () -> {
            if (Objects.isNull(automaticModuleName)) {
                return new Manifest();
            }
            if (MANIFEST_MAP.containsKey(automaticModuleName)) {
                return MANIFEST_MAP.get(automaticModuleName);
            }
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "The Impossible Library");
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, "0.4.7");
            LOGGER.debug("Setting Automatic-Module-Name for Manifest to {}", (Object)automaticModuleName);
            NeoForgeModLoading.setAutomaticModuleName(manifest.getMainAttributes(), automaticModuleName);
            MANIFEST_MAP.put(automaticModuleName, manifest);
            return manifest;
        };
    }

    public static IModFileInfo getFileInfo(IModFile file, Collection<?> infos) {
        if (file instanceof ModFile) {
            IConfigurable configWrapper = NeoForgeModLoading.initFileConfig(infos);
            Consumer<IModFileInfo> configConsumer = info -> Hacks.invoke(configWrapper, "setFile", info);
            return (IModFileInfo)Hacks.construct(ModFileInfo.class, file, configWrapper, configConsumer);
        }
        LOGGER.error("Cannot get IModFileInfo for IModFile that is not an instance of ModFile! {}", (Object)file);
        return null;
    }

    private static String getFirstModId(MultiVersionModCandidate candidate, Collection<?> infos) {
        for (Object info : infos) {
            String modid = ((MultiVersionModInfo)info).getModID();
            if (!Objects.nonNull(modid) || modid.isEmpty()) continue;
            return modid;
        }
        if (Objects.nonNull(candidate)) {
            LOGGER.debug("Returning file name for MultiVersionModCandidate as first modid");
            return candidate.getFile().getName();
        }
        LOGGER.debug("First modid not found! Returning null");
        return null;
    }

    public static IModFile.Type getModFileType(String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            LOGGER.error("Null or empty mod file type! LIBRARY will be assumed");
            return IModFile.Type.LIBRARY;
        }
        return IModFile.Type.valueOf((String)name);
    }

    private static boolean hasCoreModPath(String ... paths) {
        for (String path : paths) {
            if (!path.contains("coremods.json")) continue;
            return true;
        }
        return false;
    }

    private static List<Path> identifyAccessTransformers(IModFile file) {
        IModFileInfo fileInfo = file.getModFileInfo();
        Optional<List> potentialPaths = (Optional<List>)Hacks.invokeStaticDirect(ModFileParser.class, "getAccessTransformers", fileInfo);
        if (Objects.isNull(potentialPaths)) {
            potentialPaths = Optional.empty();
        }
        return potentialPaths.map(list -> list.stream().map(xva$0 -> file.findResource(new String[]{xva$0})).filter(path -> {
            if (Files.notExists(path, new LinkOption[0])) {
                LOGGER.error("Access transformer file {} provided by mod {} does not exist!", path, (Object)fileInfo.moduleName());
                return false;
            }
            return true;
        })).orElseGet(() -> Stream.of(file.findResource(new String[]{"META-INF", "accesstransformer.cfg"})).filter(x$0 -> Files.exists(x$0, new LinkOption[0]))).toList();
    }

    private static List<Object> identifyMixinConfigs(IModFileInfo fileInfo) {
        return (List)Hacks.invokeStaticDirect(ModFileParser.class, "getMixinConfigs", fileInfo);
    }

    @IndirectCallers
    public static boolean identifyMods(IModFile file) {
        String fileName = file.getFileName();
        Path absolutePath = file.getFilePath().toAbsolutePath();
        LOGGER.debug("Finalizing mod identification for {} (path={})", (Object)fileName, (Object)absolutePath);
        if (!CANDIDATE_MAP.containsValue(file) && !LOADER_FILES.contains(file)) {
            LOGGER.warn("There are no mods to identify for {}", (Object)fileName);
            return false;
        }
        if (IDENTIFIED_FILES.contains(file)) {
            LOGGER.debug("Skipping file that was already identified {}", (Object)fileName);
        } else {
            LOGGER.debug("Querying access transformers, coremods, & mixin conifgs for mod file {}", (Object)fileName);
            NeoForgeModLoading.queryCoreMods(file);
            Hacks.setFieldDirect(file, "mixinConfigs", NeoForgeModLoading.identifyMixinConfigs(file.getModFileInfo()));
            Hacks.setFieldDirect(file, "accessTransformers", NeoForgeModLoading.identifyAccessTransformers(file));
            IDENTIFIED_FILES.add(file);
        }
        LOGGER.debug("Finalized mod identification for {} (path={})", (Object)fileName, (Object)absolutePath);
        int candidateCount = CANDIDATE_MAP.size() + LOADER_FILES.size() - 1;
        int identifiedCount = IDENTIFIED_FILES.size();
        if (identifiedCount >= candidateCount) {
            LOGGER.debug("Successfully identified {}/{} mod files", (Object)identifiedCount, (Object)candidateCount);
        }
        return true;
    }

    private static Config initConfigDependencies() {
        Config dependency = Config.inMemory();
        dependency.set("mandatory", (Object)true);
        dependency.set("modId", (Object)"theimpossiblelibrary");
        dependency.set("ordering", (Object)"AFTER");
        dependency.set("side", (Object)"BOTH");
        dependency.set("versionRange", (Object)"[0.4.6,)");
        return dependency;
    }

    private static List<Config> initConfigMods(Config config, Collection<?> infos) {
        ArrayList<Config> mods = new ArrayList<Config>();
        boolean setLicense = false;
        for (Object o : infos) {
            MultiVersionModInfo info = (MultiVersionModInfo)o;
            if (!setLicense) {
                config.set("license", (Object)info.getLicense());
                setLicense = true;
            }
            Config mod = Config.inMemory();
            mod.set("description", (Object)info.getDescription());
            mod.set("displayName", (Object)info.getName());
            mod.set("license", (Object)info.getLicense());
            mod.set("logoFile", (Object)"logo.png");
            mod.set("modId", (Object)info.getModID());
            mod.set("version", (Object)info.getVersion());
            mods.add(mod);
        }
        if (!setLicense) {
            config.set("license", (Object)"LGPL V3");
        }
        return mods;
    }

    public static IConfigurable initFileConfig(Collection<?> infos) {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"multiversionprovider");
        config.set("loaderVersion", (Object)"[0.4.6,)");
        List<Config> mods = NeoForgeModLoading.initConfigMods(config, infos);
        config.add("mods", mods);
        if (!mods.isEmpty() && !"theimpossiblelibrary".equals(mods.get(0).get("modId"))) {
            config.add("dependencies", new ArrayList<Config>(Collections.singletonList(NeoForgeModLoading.initConfigDependencies())));
        }
        return NeoForgeModLoading.wrapConfig((UnmodifiableConfig)config);
    }

    private static Map<MultiVersionModInfo, MultiVersionModData> initInfoMap(Collection<MultiVersionModInfo> infos) {
        infos = Objects.nonNull(infos) ? infos : Collections.emptyList();
        HashMap<MultiVersionModInfo, MultiVersionModData> infoMap = new HashMap<MultiVersionModInfo, MultiVersionModData>();
        for (MultiVersionModInfo info : infos) {
            infoMap.put(info, null);
        }
        LOGGER.info("Created <info,data> map with {} entries for multiversion mod file ({}) using {}", new Object[]{infos.size(), workingVersion, infos});
        return infoMap;
    }

    private static Map<MultiVersionModInfo, MultiVersionModData> initInfoMap(MultiVersionModCandidate candidate, Collection<?> infos) {
        CoreAPI core = CoreAPI.getInstance();
        HashMap<MultiVersionModInfo, MultiVersionModData> infoMap = new HashMap<MultiVersionModInfo, MultiVersionModData>();
        for (Object o : infos) {
            MultiVersionModInfo info = (MultiVersionModInfo)o;
            MultiVersionModData data = core.getModData(new File("."), candidate, info);
            infoMap.put(info, data);
        }
        return infoMap;
    }

    public static void initModLoading(ClassLoader loader, Object locator) {
        CoreAPI core = CoreAPI.getInstance(loader);
        if (Objects.isNull(core)) {
            throw new RuntimeException("Failed to initialize multiversion mod loader! Cannot find CoreAPI on " + String.valueOf(loader));
        }
        NeoForgeModLoading.findPaths(loader, (MultiVersionLoaderAPI)Hacks.invoke(core, "getLoader", new Object[0]));
        NeoForgeModLoading.loadMods(loader, locator, core);
    }

    @Nullable
    private static TILBetterModScan initModScanner(ModFile file) {
        LOGGER.info("Starting multiversion mod scan");
        TILBetterModScan scan = new TILBetterModScan();
        scan.addModFileInfo(file.getModFileInfo());
        file.scanFile(p -> NeoForgeModLoading.scanReflectively(Hacks.construct(SCANNER, file), p, scan));
        LOGGER.debug("Injecting @Mod annotations from multiversion mod info");
        if (Objects.nonNull(scan.getAnnotations())) {
            scan.setCore(CoreAPI.getInstance());
            return scan;
        }
        LOGGER.error("@Mod scan annotation set for multiversion mod is null???");
        return null;
    }

    private static IModFileInfo langFileInfo(IModFile file) {
        if (!(file instanceof ModFile)) {
            LOGGER.error("IModFile instance must extend ModFile to be supported for IModFileInfo construction!");
            return null;
        }
        IConfigurable configWrapper = NeoForgeModLoading.wrapConfig((UnmodifiableConfig)NeoForgeModLoading.langProviderConfig());
        Consumer<IModFileInfo> consumer = info -> Hacks.invokeDirect(configWrapper, "setFile", info);
        return new ModFileInfo((ModFile)file, configWrapper, consumer, Collections.emptyList());
    }

    public static Config langProviderConfig() {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"minecraft");
        config.set("loaderVersion", (Object)"1");
        config.set("license", (Object)"LGPL V3");
        Config mod = Config.inMemory();
        mod.set("modId", (Object)"multiversionprovider");
        mod.set("version", (Object)"0.4.7");
        mod.set("displayName", (Object)"Multiversion Language Provider");
        mod.set("logoFile", (Object)"logo.png");
        mod.set("authors", (Object)"The_Computerizer");
        mod.set("description", (Object)"Multiversion language loader for The Impossible Library");
        config.set("mods", Collections.singletonList(mod));
        return config;
    }

    public static IModFile langProviderModFile(IModFile reference, String moduleName) {
        return NeoForgeModLoading.createModFile(reference, NeoForgeModLoading::langFileInfo, "LANGPROVIDER", moduleName);
    }

    private static void loadCandidateInfos(Object locator, Map<?, Collection<MultiVersionModInfo>> infoMap) {
        if (Objects.isNull(infoMap)) {
            LOGGER.error("Tried to load mod candidate info with null info map! locator = {}", locator);
            return;
        }
        for (Map.Entry<?, Collection<MultiVersionModInfo>> entry : infoMap.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            Collection<MultiVersionModInfo> infos = entry.getValue();
            if (Objects.isNull(infos)) {
                LOGGER.error("Null MultiVersionModInfo collection for candidate {}", (Object)candidate);
                continue;
            }
            Function<IModFile, IModFileInfo> parser = file -> NeoForgeModLoading.getFileInfo(file, infos);
            String firstModId = NeoForgeModLoading.getFirstModId(candidate, infos);
            IModFile file2 = NeoForgeModLoading.createModFile((Object)candidate.getFile().toPath(), locator, parser, "MOD", firstModId);
            CANDIDATE_MAP.put(candidate, file2);
            FILE_INFO_MAP.put(file2, NeoForgeModLoading.initInfoMap(infos));
        }
    }

    private static void loadMods(ClassLoader loader, Object locator, Object core) {
        Hacks.invoke(core, "loadCoreModInfo", loader);
        Hacks.invoke(core, "instantiateCoreMods", new Object[0]);
        Hacks.invoke(core, "writeModContainers", loader);
        NeoForgeModLoading.loadCandidateInfos(locator, (Map)Hacks.invoke(core, "getModInfo", new Object[0]));
    }

    private static TILBetterModScan onFinishedWritingMods(TILBetterModScan scan, IModFile file) {
        if (!JAVA_21) {
            List loaders = (List)Hacks.invoke(file, "getLoaders", new Object[0]);
            if (Objects.isNull(loaders) || loaders.isEmpty()) {
                LOGGER.error("Why are there no language loaders??");
            } else {
                for (Object loader : loaders) {
                    AFTER_WRITING_MODS.accept(scan, loader);
                }
            }
        }
        LOGGER.debug("Finishing multiversion mod scan");
        scan.addFilePath(file.getFilePath());
        return scan;
    }

    @Nullable
    static Manifest parseManifest(File file) {
        Manifest manifest = null;
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            manifest = new Manifest(stream);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse manifest from {}", (Object)file, (Object)ex);
        }
        return manifest;
    }

    public static void populateMultiversionData(Map<MultiVersionModInfo, MultiVersionModData> infoMap, Map<String, MultiVersionModData> dataMap) {
        if (Objects.isNull(dataMap)) {
            LOGGER.error("Tried to populate multiversion mod data with null data map! infoMap = {}", infoMap);
            return;
        }
        for (MultiVersionModData data : dataMap.values()) {
            MultiVersionModInfo info = data.getInfo();
            if (!infoMap.containsKey(info)) continue;
            LOGGER.debug("Populated data for {}", (Object)info);
            infoMap.put(info, data);
        }
    }

    @IndirectCallers
    public static void queryCoreMods(String ... resourcePaths) {
        if (!fixedCoreMods && NeoForgeModLoading.hasCoreModPath(resourcePaths)) {
            NeoForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static void queryCoreMods(Object file) {
        List coremods = (List)Hacks.invokeStaticDirect(ModFileParser.class, "getCoreMods", file);
        if (Objects.nonNull(coremods)) {
            Hacks.setFieldDirect(file, "coreMods", coremods);
            if (!fixedCoreMods && !coremods.isEmpty()) {
                NeoForgeModLoading.fixCoreModPackages();
                fixedCoreMods = true;
            }
        }
    }

    public static <F> List<F> scanMods() {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Scanning for mods in multiversion jars (context = {})", (Object)context);
        ArrayList mods = new ArrayList();
        LOGGER.debug("Getting CoreAPI instance");
        CoreAPI instance = CoreAPI.getInstance();
        if (Objects.isNull(instance)) {
            LOGGER.error("Failed to get CoreAPI instance :(");
        }
        Map<String, MultiVersionModData> data = instance.getModData(new File("."));
        for (Map.Entry<MultiVersionModCandidate, IModFile> candidateEntry : CANDIDATE_MAP.entrySet()) {
            IModFile candidateFile = candidateEntry.getValue();
            Map<MultiVersionModInfo, MultiVersionModData> map = FILE_INFO_MAP.get(candidateFile);
            if (Objects.isNull(map)) {
                LOGGER.error("Cannot populate multiversion data with null info map! Was the getter set up correctly?");
                continue;
            }
            NeoForgeModLoading.populateMultiversionData(map, data);
            if (candidateEntry.getKey().getModClassNames().contains(SELF_ENTRYPOINT)) {
                LOGGER.info("Adding scanned lang provider mod {}", (Object)candidateFile);
                NeoForgeModLoading.addScannedMod(NeoForgeModLoading.langProviderModFile(candidateFile, "theimpossibleloader"), mods, "LANGPROVIDER");
            }
            LOGGER.info("Adding scanned mod {}", (Object)candidateFile);
            NeoForgeModLoading.addScannedMod(candidateFile, mods, "MOD");
        }
        return Collections.unmodifiableList(mods);
    }

    private static void scanReflectively(Object scanner, Path path, ModFileScanData scan) {
        LOGGER.trace("Attempting to scan multiversion jar path {}", (Object)path);
        try {
            Hacks.invokeDirect(scanner, "fileVisitor", path, scan);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to scan {}!", (Object)path, (Object)t);
        }
    }

    private static void setAutomaticModuleName(Attributes attributes, String moduleName) {
        if (Objects.isNull(automaticModuleName)) {
            automaticModuleName = new Attributes.Name("Automatic-Module-Name");
        }
        attributes.put(automaticModuleName, moduleName);
    }

    private static void setFileVersion(Class<?> caller, String version, String actualVersion) {
        String[] stringArray;
        workingVersion = version;
        HashSet<String> set = new HashSet<String>(Arrays.asList("api", "neoforge"));
        if (JAVA_21) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "v21";
            stringArray2[1] = "v20.m6";
            stringArray = stringArray2;
            stringArray2[2] = "v21.m1";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "v20";
            stringArray = stringArray3;
            stringArray3[1] = "v20.m4";
        }
        for (String coremodVersionExtension : stringArray) {
            set.add("neoforge." + coremodVersionExtension);
        }
        coreModExtensions = set.stream().map(s -> "mods.thecomputerizer.theimpossiblelibrary." + s + ".core").collect(Collectors.toSet());
        dynamicModFileClass = NeoForgeModLoading.dynamicModFileCreator();
        LOGGER.info("{} NeoForge Locator plugin loaded on {}", (Object)actualVersion, (Object)caller.getClassLoader());
    }

    @IndirectCallers
    public static boolean setLoadingVersion(Class<?> caller) {
        if (Objects.nonNull(workingVersion)) {
            LOGGER.debug("Tried to set loading version from {} after it was already set", caller);
            return false;
        }
        String version = String.valueOf((Object)CoreAPI.gameVersion());
        String checkedVersion = version.substring(2).replace('.', '_');
        NeoForgeModLoading.setFileVersion(caller, checkedVersion, version);
        LOGGER.info("Successfully set Neoforge mod loading version ({}->{})", (Object)checkedVersion, (Object)version);
        return true;
    }

    public static void updateDiscoveryAttributes(IModFile file, String method, Object updateWith) {
        Object attributes = Hacks.invoke(file, "getDiscoveryAttributes", new Object[0]);
        Hacks.invoke(file, "setDiscoveryAttributes", NeoForgeModLoading.updateDiscoveryAttributes(attributes, method, updateWith));
    }

    public static Object updateDiscoveryAttributes(Object attributes, String method, Object updateWith) {
        return Hacks.invoke(attributes, method, updateWith);
    }

    private static IConfigurable wrapConfig(UnmodifiableConfig config) {
        return (IConfigurable)Hacks.construct(NIGHT_CONFIG_WRAPPER, config);
    }

    private static void writeClassBytes(IModFile file, TILBetterModScan scan, MultiVersionModData data, String className, byte[] bytes) {
        scan.addWrittenClass(className, data.getInfo(), file, bytes);
        ClassVisitor visitor = (ClassVisitor)Hacks.construct(MOD_CLASS_VISITOR, new Object[0]);
        ClassReader reader = new ClassReader(bytes);
        reader.accept(visitor, 0);
        Hacks.invokeDirect(visitor, "buildData", scan.getClasses(), scan.getAnnotations());
    }

    private static void writeEntry(IModFile file, TILBetterModScan scan, Map.Entry<MultiVersionModInfo, MultiVersionModData> entry) {
        MultiVersionModInfo info = entry.getKey();
        String modid = info.getModID();
        MultiVersionModData data = entry.getValue();
        if (Objects.isNull(data)) {
            LOGGER.warn("Skipping mod injection for {} since no data exists", (Object)modid);
            return;
        }
        for (Map.Entry<String, byte[]> classBytes : data.writeModClass()) {
            NeoForgeModLoading.writeClassBytes(file, scan, data, classBytes.getKey(), classBytes.getValue());
        }
    }

    @IndirectCallers
    public static ModFileScanData writeMods(ModFile file) {
        Map<MultiVersionModInfo, MultiVersionModData> infoMap = FILE_INFO_MAP.get(file);
        if (Objects.isNull(infoMap) || infoMap.isEmpty()) {
            LOGGER.error("Cannot write multiversion mods for {} with null or empty info map! {}", (Object)file, infoMap);
            return null;
        }
        TILBetterModScan scan = NeoForgeModLoading.initModScanner(file);
        if (Objects.isNull((Object)scan)) {
            LOGGER.error("Failed to initialize TILBetterModScan!");
            return null;
        }
        for (Map.Entry<MultiVersionModInfo, MultiVersionModData> entry : infoMap.entrySet()) {
            NeoForgeModLoading.writeEntry((IModFile)file, scan, entry);
        }
        return NeoForgeModLoading.onFinishedWritingMods(scan, (IModFile)file);
    }

    @Generated
    public static String getWorkingVersion() {
        return workingVersion;
    }
}

