/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import java.lang.reflect.Constructor;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;

public abstract class TILLanguageLoader {
    private static final String MOD_CONTAINER = "net.neoforged.fml.javafmlmod.FMLModContainer";
    static boolean loadedNewCore;
    protected final CoreAPI core;
    protected final String modClass;
    protected final String modid;
    protected final ModFileScanData scan;

    protected TILLanguageLoader(CoreAPI core, String modClass, String modid, ModFileScanData scan) {
        this.core = core;
        this.modClass = modClass;
        this.modid = modid;
        this.scan = scan;
    }

    private <T> T getInstance(Class<?> container, IModInfo info, ModFileScanData scanResults, ModuleLayer layer) {
        try {
            Constructor<?> init = container.getConstructor(IModInfo.class, String.class, ModFileScanData.class, ModuleLayer.class);
            Object instance = init.newInstance(info, this.modClass, scanResults, layer);
            TILRef.logInfo("Successfully initialized mod container for {}", this.modClass);
            return (T)instance;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to initialize {} (modClass {})", container, this.modClass, t);
            return null;
        }
    }

    protected <T> T loadModInner(IModInfo info, ClassLoader classLoader, ModFileScanData scanResults, ModuleLayer layer) {
        try {
            String coreName = this.core.getClass().getName();
            Hacks.invoke(this.scan, "defineClasses", classLoader);
            if (!loadedNewCore) {
                this.setCoreAPI(coreName, classLoader);
            }
            NeoForgeCoreLoader.verifyModule(this.modClass, info, layer);
            return this.getInstance(Hacks.findClass(MOD_CONTAINER, true), info, scanResults, layer);
        }
        catch (Throwable t) {
            String msg = "Failed to load net.neoforged.fml.javafmlmod.FMLModContainer for multiversion mod!";
            TILRef.logError("Failed to load net.neoforged.fml.javafmlmod.FMLModContainer for multiversion mod!", t);
            throw new RuntimeException("Failed to load net.neoforged.fml.javafmlmod.FMLModContainer for multiversion mod!", t);
        }
    }

    protected void setCoreAPI(String implName, ClassLoader loader) {
        try {
            Hacks.constructWithLoader(implName, loader, new Object[0]);
            loadedNewCore = true;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to set CoreAPI instance {}", implName, t);
        }
    }

    @Generated
    public String getModid() {
        return this.modid;
    }
}

