/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleReferenceAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleLayerHandlerAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import org.jetbrains.annotations.Nullable;

public class ModuleClassLoaderAccess
extends ClassLoaderAccess
implements ModuleHolder {
    IModuleLayerManager.Layer layer;

    ModuleClassLoaderAccess(ModuleClassLoader loader, Object accessorOrLogger) {
        super((ClassLoader)loader, accessorOrLogger);
    }

    @IndirectCallers
    public void addPackage(String pkg, ResolvedModuleAccess resolvedModule) {
        this.addPackage(pkg, (ResolvedModule)resolvedModule.accessAs());
    }

    void addPackage(String pkg, ResolvedModule resolvedModule) {
        this.packageLookup().put(pkg, resolvedModule);
    }

    @IndirectCallers
    public void addPackages(ResolvedModuleAccess resolvedModule) {
        this.addPackages(resolvedModule.reference().descriptor(), resolvedModule);
    }

    public void addPackages(ModuleDescriptorAccess moduleDescriptor, ResolvedModuleAccess resolvedModule) {
        this.addPackages(moduleDescriptor.packages(), resolvedModule);
    }

    public void addPackages(Collection<String> pkgs, ResolvedModuleAccess resolvedModule) {
        this.addPackages(pkgs, (ResolvedModule)resolvedModule.accessAs());
    }

    public void addPackages(Collection<String> pkgs, ResolvedModule resolvedModule) {
        Map<String, ResolvedModule> packageLookup = this.packageLookup();
        for (String pkg : pkgs) {
            packageLookup.put(pkg, resolvedModule);
        }
    }

    @IndirectCallers
    public void addPackagesFrom(Collection<String> pkgs, ModuleClassLoaderAccess source, String moduleName) {
        ResolvedModule module = (ResolvedModule)source.getConfigModuleDirect(moduleName);
        this.addPackages(pkgs, module);
    }

    @IndirectCallers
    public void addParentLoaders(ResolvedModuleAccess resolvedModule, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(resolvedModule.reference().descriptor(), loader);
    }

    public void addParentLoaders(ModuleDescriptorAccess moduleDescriptor, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(moduleDescriptor.packages(), loader);
    }

    public void addParentLoaders(Collection<String> pkgs, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(pkgs, (ClassLoader)loader.accessAs());
    }

    void addParentLoaders(Collection<String> pkgs, ClassLoader loader) {
        Map<String, ClassLoader> parentLoaders = this.parentLoaders();
        for (String pkg : pkgs) {
            parentLoaders.put(pkg, loader);
        }
    }

    @IndirectCallers
    public void addParentLoader(String pkg, ModuleClassLoaderAccess loader) {
        this.addParentLoader(pkg, (ClassLoader)loader.accessAs());
    }

    void addParentLoader(String pkg, ClassLoader loader) {
        this.parentLoaders().put(pkg, loader);
    }

    @IndirectCallers
    public void addRoot(ResolvedModuleAccess resolvedModule) {
        this.addRoot(resolvedModule.reference());
    }

    public void addRoot(ModuleReferenceAccess moduleReference) {
        this.addRoot(moduleReference.name(), (ModuleReference)moduleReference.accessAs());
    }

    @IndirectCallers
    public void addRoot(String name, ModuleReferenceAccess moduleReference) {
        this.addRoot(name, (ModuleReference)moduleReference.accessAs());
    }

    public void addRoot(String name, ModuleReference moduleReference) {
        this.resolvedRoots().put(name, moduleReference);
    }

    @Override
    public void cloneModule(String moduleName, String newModuleName) {
        this.clonePackages(moduleName, newModuleName);
        this.cloneModuleMap(this.resolvedRoots(), moduleName, newModuleName);
    }

    <T> void cloneModuleMap(Map<String, T> map, String moduleName, String newModuleName) {
        if (map.containsKey(moduleName)) {
            T o = map.get(moduleName);
            map.remove(moduleName);
            if (!map.containsKey(newModuleName)) {
                this.getModuleReference(o).setName(newModuleName);
                map.put(newModuleName, o);
            }
        }
    }

    void clonePackages(String moduleName, String newModuleName) {
        ResolvedModuleAccess existingModule = this.lookupResolvedModule(newModuleName);
        boolean existed = Objects.nonNull(existingModule);
        HashSet<String> packages = existed ? new HashSet<String>() : null;
        Map<String, ResolvedModule> packageLookup = this.packageLookup();
        for (Map.Entry<String, ResolvedModule> packageEntry : packageLookup.entrySet()) {
            ResolvedModuleAccess moduleAccess = this.getAsResolvedModule(packageEntry.getValue());
            if (!moduleName.equals(moduleAccess.name())) continue;
            if (existed) {
                packages.add(packageEntry.getKey());
                continue;
            }
            moduleAccess.setName(newModuleName);
        }
        if (existed) {
            for (String pkg : packages) {
                packageLookup.put(pkg, (ResolvedModule)existingModule.accessAs());
            }
        }
    }

    public void combineModules(URI combinedLocation, String combinedName, String ... others) {
        ConfigurationAccess configuration = this.configuration();
        ResolvedModuleAccess module = configuration.getModule(combinedName);
        if (Objects.isNull(module)) {
            this.logger.error("Cannot combined modules {} into module {} that does not exist!", (Object)others, (Object)combinedLocation);
            return;
        }
        ModuleLayerAccess layer = this.getModuleLayer();
        ModuleReferenceAccess reference = this.getRoot(combinedName);
        if (Objects.nonNull(reference)) {
            reference.setLocation(combinedLocation);
        }
        module.inheritFrom(configuration, others);
        Map<String, ClassLoader> parentLoaders = this.parentLoaders();
        Map<String, ResolvedModule> packageLookup = this.packageLookup();
        for (String pkg : module.packages()) {
            packageLookup.put(pkg, (ResolvedModule)module.accessAs());
            parentLoaders.remove(pkg);
        }
        this.removeRoots(others);
        configuration.removeModules(others);
        layer.combineModules(combinedName, others);
    }

    public ConfigurationAccess configuration() {
        Object configuration = this.getDirect("configuration");
        if (Objects.nonNull(configuration)) {
            return this.getConfiguration(configuration);
        }
        this.logOrPrintError("Configuration field not found in ModuleClassLoader " + String.valueOf(this.access()));
        return null;
    }

    @Override
    public Collection<ModuleHolder> getAllReferents() {
        return Arrays.asList(this, this.configuration(), this.getModuleLayer());
    }

    ResolvedModuleAccess getAsResolvedModule(Object resolvedModule) {
        if (Objects.isNull(resolvedModule)) {
            return null;
        }
        if (resolvedModule instanceof ResolvedModuleAccess) {
            return (ResolvedModuleAccess)resolvedModule;
        }
        return ModuleSystemAccessor.getResolvedModule(resolvedModule, this);
    }

    public <T> T getConfigModuleDirect(String name) {
        return this.configuration().getModuleDirect(name);
    }

    @Nullable
    public ModuleDescriptorAccess getModuleDescriptor(String name) {
        ModuleAccess module = this.getModuleLayer().getModule(name);
        return Objects.nonNull(module) ? module.getDescriptor() : null;
    }

    @Nullable
    public ModuleDescriptor getModuleDescriptorDirect(String name) {
        ModuleDescriptorAccess descriptorAccess = this.getModuleDescriptor(name);
        return Objects.nonNull(descriptorAccess) ? (ModuleDescriptor)descriptorAccess.accessAs() : null;
    }

    public ModuleLayerAccess getModuleLayer() {
        if (Objects.isNull(this.layer)) {
            this.logOrPrintError("Cannot get ModuleLayer! (ModuleClassLoaderAccess#layerName is null)");
            return null;
        }
        return NeoforgeModuleAccess.getModuleLayer(this.layer, this);
    }

    @IndirectCallers
    public Set<String> getModulePackages(String name) {
        ModuleDescriptorAccess descriptor = this.getModuleDescriptor(name);
        return Objects.nonNull(descriptor) ? descriptor.packages() : Set.of();
    }

    public ResolvedModuleAccess getResolvedModule(String pkg) {
        return this.getAsResolvedModule(this.packageLookup().get(pkg));
    }

    @IndirectCallers
    public String getResolvedModuleName(Object resolvedModule) {
        return this.getAsResolvedModule(resolvedModule).name();
    }

    public ModuleReferenceAccess getRoot(String name) {
        ModuleReference moduleReference = this.resolvedRoots().get(name);
        return Objects.nonNull(moduleReference) ? this.getModuleReference(moduleReference) : null;
    }

    @IndirectCallers
    public ModuleReference getRootDirect(String name) {
        return this.resolvedRoots().get(name);
    }

    @IndirectCallers
    public ModuleLayerHandlerAccess handler() {
        return NeoforgeModuleAccess.getModuleLayerHandler(this);
    }

    public String layerName() {
        return Objects.nonNull(this.layer) ? this.layer.name() : "UNKNOWN";
    }

    public void lookupAndRemovePackagesFor(String moduleName) {
        this.removePackages(this.lookupResolvedModule(moduleName));
    }

    @IndirectCallers
    public Set<ResolvedModule> lookupModules(Collection<String> packages) {
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>();
        for (Map.Entry<String, ResolvedModule> lookupEntry : this.packageLookup().entrySet()) {
            if (!packages.contains(lookupEntry.getKey())) continue;
            modules.add(lookupEntry.getValue());
        }
        return modules;
    }

    @IndirectCallers
    public Set<String> lookupPackagesFor(String ... moduleNames) {
        HashSet<String> pkgs = new HashSet<String>();
        block0: for (Map.Entry<String, ResolvedModule> lookupEntry : this.packageLookup().entrySet()) {
            String entryName = lookupEntry.getValue().name();
            for (String moduleName : moduleNames) {
                if (!moduleName.equals(entryName)) continue;
                pkgs.add(lookupEntry.getKey());
                continue block0;
            }
        }
        return pkgs;
    }

    public ResolvedModuleAccess lookupResolvedModule(String moduleName) {
        for (ResolvedModule resolvedModule : this.packageLookup().values()) {
            ResolvedModuleAccess moduleAccess = this.getAsResolvedModule(resolvedModule);
            if (!moduleName.equals(moduleAccess.name())) continue;
            return moduleAccess;
        }
        return null;
    }

    public void moveModuleTo(ModuleClassLoaderAccess targetLoader, String moduleName) {
        ResolvedModuleAccess resolvedModule = this.lookupResolvedModule(moduleName);
        Set<String> packages = resolvedModule.packages(false);
        ResolvedModule resolveModuleAccess = (ResolvedModule)resolvedModule.accessAs();
        resolvedModule.configuration().moveModuleTo(targetLoader.configuration(), resolvedModule);
        this.moveRoots(targetLoader, moduleName);
        this.movePackageLookup(targetLoader, packages, resolveModuleAccess);
    }

    private void movePackageLookup(ModuleClassLoaderAccess targetLoader, Set<String> packages, ResolvedModule resolveModuleAccess) {
        this.movePackageParent(targetLoader, packages);
        Map<String, ResolvedModule> packageLookup = this.packageLookup();
        Map<String, ResolvedModule> targetPackageLookup = targetLoader.packageLookup();
        for (String pkg : packages) {
            packageLookup.remove(pkg);
            targetPackageLookup.put(pkg, resolveModuleAccess);
        }
    }

    private void movePackageParent(ModuleClassLoaderAccess targetLoader, Set<String> packages) {
        if (packages.isEmpty()) {
            return;
        }
        this.addParentLoaders(packages, targetLoader);
        targetLoader.removeParentLoaders(packages);
    }

    private void moveRoots(ModuleClassLoaderAccess targetLoader, String moduleName) {
        ModuleReference ref = this.getRootDirect(moduleName);
        if (Objects.nonNull(ref)) {
            this.removeRoot(moduleName);
            targetLoader.addRoot(moduleName, ref);
        }
    }

    @IndirectCallers
    public void moveServicesTo(ModuleLayerAccess target, ModuleAccess module, String ... serviceMovementBlacklist) {
        this.getModuleLayer().moveServicesTo(target, module, serviceMovementBlacklist);
    }

    @IndirectCallers
    public ResolvedModuleAccess newResolvedModule(ModuleReferenceAccess moduleReference) {
        return this.newResolvedModule(Objects.nonNull(moduleReference) ? moduleReference.access() : null);
    }

    public ResolvedModuleAccess newResolvedModule(Object moduleReference) {
        ConfigurationAccess configuration = this.configuration();
        return this.newResolvedModule(Objects.nonNull(configuration) ? configuration.access() : null, moduleReference);
    }

    @Override
    public ResolvedModuleAccess newResolvedModule(Object configuration, Object moduleReference) {
        if (Objects.isNull(configuration)) {
            this.logOrPrintError("Cannot create new ResolvedModule with null Configuration!");
            return null;
        }
        if (Objects.isNull(moduleReference)) {
            this.logOrPrintError("Cannot create new ResolvedModule with null ModuleReference!");
            return null;
        }
        return this.newResolvedModule(configuration, moduleReference);
    }

    public Map<String, ResolvedModule> packageLookup() {
        return (Map)this.getDirect("packageLookup");
    }

    public Map<String, ClassLoader> parentLoaders() {
        return (Map)this.getDirect("parentLoaders");
    }

    @Override
    public void removeModule(String moduleName) {
        this.removeRoot(moduleName);
        this.lookupAndRemovePackagesFor(moduleName);
    }

    public void removePackages(ResolvedModuleAccess resolvedModule) {
        if (Objects.nonNull(resolvedModule)) {
            this.removePackages(resolvedModule.packages());
        }
    }

    public void removePackages(Collection<String> pkgs) {
        if (Objects.isNull(pkgs) || pkgs.isEmpty()) {
            return;
        }
        for (Map map : Arrays.asList(this.packageLookup(), this.parentLoaders())) {
            for (String pkg : pkgs) {
                map.remove(pkg);
            }
        }
    }

    @IndirectCallers
    public void removePackage(String pkg) {
        this.removePackageLookup(pkg);
        this.removeParentLoader(pkg);
    }

    public void removePackageLookup(String pkg) {
        this.packageLookup().remove(pkg);
    }

    public void removePackagesForModule(ResolvedModuleAccess resolvedModule) {
        this.removePackagesForModule((ResolvedModule)resolvedModule.accessAs());
    }

    public void removePackagesForModule(ResolvedModule resolvedModule) {
        this.packageLookup().entrySet().removeIf(entry -> ((ResolvedModule)entry.getValue()).equals(resolvedModule));
    }

    public void removeParentLoaders(Collection<String> pkgs) {
        Map<String, ClassLoader> parentLoaders = this.parentLoaders();
        for (String pkg : pkgs) {
            parentLoaders.remove(pkg);
        }
    }

    public void removeParentLoader(String pkg) {
        this.parentLoaders().remove(pkg);
    }

    public void removeRoot(String root) {
        this.resolvedRoots().remove(root);
    }

    public void removeRoots(String ... roots) {
        Map<String, ModuleReference> resolvedRoots = this.resolvedRoots();
        for (String root : roots) {
            resolvedRoots.remove(root);
        }
    }

    public void renameModule(String name, String newName) {
        ConfigurationAccess configuration = this.configuration();
        ResolvedModuleAccess module = configuration.getModule(name);
        if (Objects.isNull(module)) {
            this.logger.error("Cannot rename module {} that does not exist on layer {}!", (Object)name, (Object)this.layer);
            return;
        }
        ModuleLayerAccess layer = this.getModuleLayer();
        module.setName(newName);
        ModuleReference root = this.getRootDirect(name);
        if (Objects.nonNull(root)) {
            this.removeRoot(name);
            this.addRoot(newName, root);
        }
        configuration.renameModule(name, newName);
        layer.renameModule(name, newName);
    }

    @IndirectCallers
    public Map<String, ModuleReference> resolvedRoots() {
        return (Map)this.getDirect("resolvedRoots");
    }

    public String toString() {
        String layerVal = String.valueOf(this.layer);
        return "ModuleClassLoaderAccess[" + layerVal + "]";
    }

    @Generated
    public void setLayer(IModuleLayerManager.Layer layer) {
        this.layer = layer;
    }
}

