/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules;

import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.LayerInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import org.apache.logging.log4j.Logger;

public class ModuleLayerHandlerAccess
extends AbstractModuleSystemAccessor {
    ModuleLayerHandlerAccess(Object layerHandler, Object accessorOrLogger) {
        super(layerHandler, accessorOrLogger);
    }

    ModuleLayerAccess asModuleLayer(Object moduleLayer) {
        return moduleLayer instanceof ModuleLayerAccess ? (ModuleLayerAccess)moduleLayer : this.getModuleLayer(moduleLayer);
    }

    public Map<IModuleLayerManager.Layer, ?> completedLayers() {
        return (Map)this.getDirect("completedLayers");
    }

    public Map<String, Collection<String>> getAllModuleNames(IModuleLayerManager.Layer ... layers) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (Map.Entry<ModuleLayerAccess, String> layerEntry : this.getAllNamedModuleLayers(layers).entrySet()) {
            map.put(layerEntry.getValue(), layerEntry.getKey().moduleNames());
        }
        return map;
    }

    public Map<ModuleLayerAccess, String> getAllNamedModuleLayers(IModuleLayerManager.Layer ... layers) {
        HashMap<ModuleLayerAccess, String> layerToName = new HashMap<ModuleLayerAccess, String>();
        HashMap<ModuleLayer, ModuleLayerAccess> layerToWrapper = new HashMap<ModuleLayer, ModuleLayerAccess>();
        HashSet<ModuleLayer> moduleLayers = new HashSet<ModuleLayer>();
        for (IModuleLayerManager.Layer layer : layers) {
            ModuleLayerAccess moduleLayer = this.getModuleLayer(layer);
            moduleLayers.add((ModuleLayer)moduleLayer.accessAs());
            layerToName.put(moduleLayer, layer.name());
            layerToWrapper.put((ModuleLayer)moduleLayer.accessAs(), moduleLayer);
            for (Object parent : moduleLayer.parents()) {
                moduleLayers.add((ModuleLayer)parent);
            }
        }
        int unknownParentCounter = 0;
        for (ModuleLayer layer : moduleLayers) {
            if (layerToWrapper.containsKey(layer)) continue;
            ModuleLayerAccess layerAccess = this.asModuleLayer(layer);
            layerToWrapper.put(layer, layerAccess);
            layerToName.put(layerAccess, "UNKNOWN-PARENT-" + unknownParentCounter);
            ++unknownParentCounter;
        }
        return layerToName;
    }

    @IndirectCallers
    public ClassLoader getLayerClassLoader(IModuleLayerManager.Layer layer) {
        return this.getLayerInfo(layer).getClassLoader();
    }

    public LayerInfoAccess getLayerInfo(IModuleLayerManager.Layer layer) {
        Object layerInfo = this.completedLayers().get(layer);
        LayerInfoAccess layerInfoAccess = NeoforgeModuleAccess.getLayerInfo(layerInfo, (Object)this);
        layerInfoAccess.setLayer(layer);
        return layerInfoAccess;
    }

    @IndirectCallers
    public ModuleClassLoaderAccess getLayerModuleClassLoader(IModuleLayerManager.Layer layer) {
        return this.getLayerInfo(layer).getModuleClassLoader();
    }

    public Map<String, Collection<String>> getLayerPathNames(IModuleLayerManager.Layer ... layers) {
        HashMap<String, Collection<String>> pathMap = new HashMap<String, Collection<String>>();
        for (IModuleLayerManager.Layer layer : layers) {
            pathMap.put(layer.name(), this.getLayerPaths(layer).stream().map(this::printPathOrJar).collect(Collectors.toSet()));
        }
        if (pathMap.isEmpty()) {
            this.logOrPrint("Returning empty path map for layers " + Arrays.toString(layers), Logger::warn);
        }
        return pathMap;
    }

    public List<Object> getLayerPaths(IModuleLayerManager.Layer layer) {
        Map<IModuleLayerManager.Layer, List<Object>> map = this.layerPathMap();
        if (Objects.isNull(layer)) {
            this.logOrPrintError("Failed to get null Layer! Cannot return paths");
            return Collections.emptyList();
        }
        if (!map.containsKey(layer)) {
            this.logOrPrint("Layer path map does not contain paths for " + String.valueOf(layer), Logger::warn);
            return Collections.emptyList();
        }
        return map.get(layer);
    }

    public ModuleLayerAccess getModuleLayer(IModuleLayerManager.Layer layer) {
        return this.getLayerInfo(layer).getModuleLayer();
    }

    public Map<IModuleLayerManager.Layer, List<Object>> layerPathMap() {
        return (Map)this.getDirect("layers");
    }

    @IndirectCallers
    public void printAllModuleNames(IModuleLayerManager.Layer ... layers) {
        this.defaultMapPrinter().accept(this.getAllModuleNames(layers));
    }

    @IndirectCallers
    void printForLayers(Function<IModuleLayerManager.Layer[], Map<?, ?>> mapGetter, IModuleLayerManager.Layer ... layers) {
        this.defaultMapPrinter().accept(mapGetter.apply(layers));
    }

    @IndirectCallers
    public void printLayerPaths(IModuleLayerManager.Layer ... layers) {
        this.defaultMapPrinter().accept(this.getLayerPathNames(layers));
    }

    String printPathOrJar(Object pathOrJar) {
        try {
            NamedPath path = (NamedPath)Hacks.invoke(pathOrJar, "path", new Object[0]);
            String name = Objects.nonNull(path) ? path.name() : "null";
            String paths = Arrays.toString(Objects.nonNull(path) ? path.paths() : new Path[]{});
            return "name = '" + name + "' | paths = '" + paths + "'";
        }
        catch (Throwable t) {
            this.logOrPrintError("Failed to extract path string from " + String.valueOf(pathOrJar), t);
            return "Unknown path object '" + String.valueOf(pathOrJar) + "'";
        }
    }
}

