/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules;

import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;

public record ResolvedModuleHolder(ResolvedModuleAccess module, ModuleClassLoaderAccess loader) {
    public static ResolvedModuleHolder findModule(String moduleName, ModuleClassLoaderAccess ... loaders) {
        for (ModuleClassLoaderAccess loader : loaders) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findModule(moduleName, loader);
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    public static ResolvedModuleHolder findModule(String moduleName, ModuleClassLoaderAccess loader) {
        ResolvedModuleAccess resolvedModule = loader.configuration().getModule(moduleName);
        return Objects.nonNull(resolvedModule) ? new ResolvedModuleHolder(resolvedModule, loader) : null;
    }

    public static ResolvedModuleHolder findPackage(String pkg, ModuleClassLoaderAccess ... loaders) {
        for (ModuleClassLoaderAccess loader : loaders) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findPackage(pkg, loader);
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    @IndirectCallers
    public static ResolvedModuleHolder findPackage(String pkg, IModuleLayerManager.Layer ... layers) {
        for (IModuleLayerManager.Layer layer : layers) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findPackage(pkg, NeoforgeModuleAccess.getModuleClassLoader(layer));
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    public static ResolvedModuleHolder findPackage(String pkg, ModuleClassLoaderAccess loader) {
        ResolvedModuleAccess resolvedModule = loader.getResolvedModule(pkg);
        return Objects.nonNull(resolvedModule) ? new ResolvedModuleHolder(resolvedModule, loader) : null;
    }

    @IndirectCallers
    public IModuleLayerManager.Layer getLayer() {
        return this.loader.layer;
    }

    @IndirectCallers
    public Set<String> getPackages() {
        return this.module.packages();
    }

    public String layerName() {
        return this.getLayer().name();
    }

    public String moduleName() {
        return this.module.name();
    }

    @IndirectCallers
    public ResolvedModuleHolder otherPackageRef(String pkg) {
        ResolvedModuleHolder holder = ResolvedModuleHolder.findPackage(pkg, this.loader);
        if (Objects.nonNull(holder) && this.moduleName().equals(holder.moduleName())) {
            return this;
        }
        return holder;
    }

    public void removePackagesFromLoader() {
        this.loader.removePackagesForModule(this.module);
    }
}

