/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.m4.network;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m4.network.MessageWrapper1_20_4;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m4.network.Network1_20_4;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public class NetworkNeoForge1_20_4
extends Network1_20_4<Object, Object> {
    public static void registerPayloads(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("theimpossiblelibrary");
        NetworkNeoForge1_20_4.registerPayload(registrar, MessageWrapper1_20_4.Client.class);
        NetworkNeoForge1_20_4.registerPayload(registrar, MessageWrapper1_20_4.Server.class);
    }

    static <M extends MessageWrapper1_20_4<IPayloadContext>> void registerPayload(IPayloadRegistrar registrar, Class<M> msgCls) {
        PacketFlow dir = MessageWrapper1_20_4.getClassFlow(msgCls);
        Function decoder = MessageWrapper1_20_4.streamDecoder((Object)dir);
        registrar.play(MessageWrapper1_20_4.getClassID(msgCls), decoder::apply, NetworkNeoForge1_20_4.registerSidedPayloadHandler(dir));
    }

    static <M extends MessageWrapper1_20_4<IPayloadContext>> IPlayPayloadHandler<M> registerPayloadHandler() {
        return (msg, ctx) -> {
            MessageWrapperAPI reply = msg.handle((Object)ctx);
            if (reply instanceof MessageWrapper1_20_4) {
                MessageWrapper1_20_4 neoReply = (MessageWrapper1_20_4)reply;
                ctx.replyHandler().send((CustomPacketPayload)neoReply);
            }
        };
    }

    static <M extends MessageWrapper1_20_4<IPayloadContext>> Consumer<IDirectionAwarePayloadHandlerBuilder<M, IPlayPayloadHandler<M>>> registerSidedPayloadHandler(Object dir) {
        return sidedHandler -> {
            if (PacketFlow.CLIENTBOUND == dir) {
                sidedHandler.client(NetworkNeoForge1_20_4.registerPayloadHandler());
            } else if (PacketFlow.SERVERBOUND == dir) {
                sidedHandler.server(NetworkNeoForge1_20_4.registerPayloadHandler());
            }
        };
    }

    public Object getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_SERVER", "PLAY_TO_SERVER" -> PacketFlow.SERVERBOUND;
            default -> PacketFlow.CLIENTBOUND;
        };
    }

    public String getNameFromDir(Object dir) {
        return dir == PacketFlow.CLIENTBOUND ? "PLAY_TO_CLIENT" : "PLAY_TO_SERVER";
    }

    public Object getDirToClient() {
        return PacketFlow.CLIENTBOUND;
    }

    public Object getDirToClientLogin() {
        return PacketFlow.CLIENTBOUND;
    }

    public Object getDirToServer() {
        return PacketFlow.SERVERBOUND;
    }

    public Object getDirToServerLogin() {
        return PacketFlow.SERVERBOUND;
    }

    public Object getNetwork() {
        return null;
    }

    @Nullable
    public Object getOppositeDir(Object dir) {
        return ((PacketFlow)dir).getOpposite();
    }

    public boolean isDirToClient(Object dir) {
        return dir == PacketFlow.CLIENTBOUND;
    }

    public boolean isDirLogin(Object dir) {
        return dir == PacketFlow.SERVERBOUND;
    }

    public void registerMessage(MessageDirectionInfo<Object> dir, int id) {
    }

    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{(MessageWrapper1_20_4)message});
    }

    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{(MessageWrapper1_20_4)message});
    }

    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(Object dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_4.getPayloadInstance((Object)dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessage(dir, message);
        }
        return wrapper;
    }

    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(Object dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_4.getPayloadInstance((Object)dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        }
        return wrapper;
    }

    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(Object dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_4.getPayloadInstance((Object)dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        }
        return wrapper;
    }
}

