/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core;

import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.Collections;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILBetterModScan;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;

public class MultiVersionLanguageLoader
implements IModLanguageLoader {
    static boolean loadedNewCore;

    String ensureOuterClassName(String className) {
        return className.contains("$") ? className.substring(0, className.indexOf(36)) : className;
    }

    public ModContainer loadMod(IModInfo info, ModFileScanData scan, ModuleLayer layer) throws ModLoadingException {
        if (scan instanceof TILBetterModScan) {
            TILBetterModScan betterScan = (TILBetterModScan)scan;
            String modid = info.getModId();
            String modClass = this.ensureOuterClassName(betterScan.getModClass(modid));
            String coreName = betterScan.getCore().getClass().getName();
            try {
                ClassLoader loader = NeoForgeCoreLoader.layerClassLoader(IModuleLayerManager.Layer.GAME);
                betterScan.defineClasses(loader);
                if (!loadedNewCore) {
                    this.setCoreAPI(Class.forName(coreName, true, loader));
                }
                NeoForgeCoreLoader.verifyModule(modClass, info, layer);
                TILRef.logInfo("Attempting to initialize container in module {} for {}", info.getOwningFile().moduleName(), modClass);
                FMLModContainer container = new FMLModContainer(info, Collections.singletonList(modClass), scan, layer);
                TILRef.logInfo("Successfully initialized mod container for {}", modClass);
                return container;
            }
            catch (Throwable t) {
                String msg = "Failed to load mod " + modid + " with " + modClass;
                TILRef.logError(msg, t);
                throw new RuntimeException(msg, t);
            }
        }
        return null;
    }

    public String name() {
        return "multiversionprovider";
    }

    protected void setCoreAPI(Class<?> implClass) {
        try {
            Hacks.checkBurningWaveInit();
            implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            loadedNewCore = true;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to set CoreAPI instance {}", implClass, t);
        }
    }

    public String version() {
        return "0.4.7";
    }

    static {
        Package pkg = MultiVersionLanguageLoader.class.getPackage();
        Object versionInfo = Hacks.getFieldDirect(pkg, "versionInfo");
        if (Objects.nonNull(versionInfo)) {
            Hacks.setFieldDirect(versionInfo, "implVersion", "0.4.7");
            TILDev.logDebug("Set implementation version of {} to {}", pkg, "0.4.7");
        }
    }
}

