/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core;

import cpw.mods.jarhandling.JarContents;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.NeoForgeModLoading;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class TILModFinderNeoForge1_21 {
    private final CoreAPI core = CoreAPI.getInstance();
    private final MultiVersionLoaderAPI loader = Objects.nonNull(this.core) ? this.core.getLoader() : null;
    protected final Logger logger = this.initializeLogger(this.getClass());

    protected TILModFinderNeoForge1_21() {
    }

    @Nullable
    protected IModFile findAndLoad(JarContents contents, Supplier<Object> attributeSupplier) {
        IModFile[] files = this.findAndLoad(new JarContents[]{contents}, attributeSupplier, IModFile.Type.MOD, false);
        return Objects.nonNull(files) && files.length > 0 ? files[0] : null;
    }

    @Nullable
    protected IModFile[] findAndLoadSelf(Path[] paths, Supplier<Object> attributeSupplier) {
        JarContents[] contents = new JarContents[]{NeoForgeModLoading.buildJarContents("theimpossiblelibrary", paths), NeoForgeModLoading.buildJarContents("theimpossibleloader", paths)};
        return this.findAndLoad(contents, attributeSupplier, null, true);
    }

    @Nullable
    protected IModFile[] findAndLoad(JarContents[] contents, Supplier<Object> attributeSupplier, IModFile.Type type, boolean loader) {
        IModFile[] iModFileArray;
        MultiVersionModCandidate candidate = this.findCandidate(contents[0]);
        Collection<?> infos = this.loadCandidate(candidate);
        if (Objects.isNull(candidate) || infos.isEmpty()) {
            return null;
        }
        if (loader) {
            return NeoForgeModLoading.createLoaderFiles(contents, attributeSupplier.get(), candidate, infos);
        }
        IModFile file = NeoForgeModLoading.createModFile((Object)contents[0], attributeSupplier.get(), candidate, infos, type);
        if (Objects.nonNull(file)) {
            IModFile[] iModFileArray2 = new IModFile[1];
            iModFileArray = iModFileArray2;
            iModFileArray2[0] = file;
        } else {
            iModFileArray = null;
        }
        return iModFileArray;
    }

    @Nullable
    private MultiVersionModCandidate findAndMergeCandidates(File file, Function<File, Attributes> attributesGetter) {
        MultiVersionModCandidate coreCandidate = MultiVersionModFinder.discoverCoreCandidate(this.loader, file, attributesGetter);
        MultiVersionModCandidate modCandidate = MultiVersionModFinder.discoverModCandidate(this.loader, file, attributesGetter);
        return this.mergeCandidates(coreCandidate, modCandidate);
    }

    @Nullable
    private MultiVersionModCandidate findCandidate(JarContents jar) {
        Manifest manifest = this.getManifest(jar);
        if (Objects.nonNull(manifest) && MultiVersionModFinder.hasMods(manifest.getMainAttributes())) {
            File file;
            Path path = jar.getPrimaryPath();
            if (Objects.nonNull(this.loader)) {
                this.loader.addPotentialModPath(path);
                this.logger.info("[{}]: Found mod candidate at {}", (Object)this.loaderName(), (Object)path);
            }
            return this.queryFile(file = path.toFile()) ? null : this.findAndMergeCandidates(file, f -> manifest.getMainAttributes());
        }
        return null;
    }

    protected Manifest getManifest(JarContents jar) {
        return jar.getManifest();
    }

    Logger initializeLogger(Class<?> c) {
        Logger logger = TILRef.createLogger(c.getSimpleName());
        if (Objects.nonNull(this.loader)) {
            logger.info("Successfully initialized {}", c);
        } else {
            logger.error("Failed to initialize {}", c);
        }
        return logger;
    }

    private Collection<?> loadCandidate(@Nullable MultiVersionModCandidate candidate) {
        if (Objects.isNull(candidate) || Objects.isNull(this.core) || Objects.isNull(this.loader)) {
            return Collections.emptyList();
        }
        return this.core.loadCandidate(candidate, this.loader, this.getClass().getClassLoader());
    }

    protected String loaderName() {
        return Objects.nonNull(this.loader) ? this.loader.getName() : null;
    }

    @Nullable
    private MultiVersionModCandidate mergeCandidates(@Nullable MultiVersionModCandidate candidate1, @Nullable MultiVersionModCandidate candidate2) {
        if (Objects.nonNull(candidate1)) {
            if (Objects.nonNull(candidate2)) {
                candidate1.merge(candidate2);
            }
            return candidate1;
        }
        return candidate2;
    }

    private boolean queryFile(File file) {
        return Objects.nonNull(this.loader) && this.queryFile(this.loaderName(), file);
    }

    protected boolean queryFile(String loaderName, File file) {
        this.queryLoaderFile(loaderName, file, file.getName());
        return false;
    }

    protected void queryLoaderFile(String loaderName, File file, String fileName) {
        this.logger.info("[{}]: Checking if file {} is the loader", (Object)loaderName, (Object)fileName);
        if (Objects.isNull(MultiVersionModCandidate.getLoaderFile()) && TILDev.isLoaderName(fileName)) {
            TILDev.logInfo("[{}]: File is the loader", loaderName);
            MultiVersionModCandidate.setLoaderFile(file);
        }
    }

    protected URL selfLocation() {
        Class<?> c = this.getClass();
        ProtectionDomain pd = this.getClass().getProtectionDomain();
        if (Objects.nonNull(pd)) {
            CodeSource source = pd.getCodeSource();
            if (Objects.nonNull(source)) {
                URL location = source.getLocation();
                this.logger.debug("Found {} at {}", c, (Object)location);
                return location;
            }
            this.logger.error("CodeSource instance for {} did not exist!", c);
        } else {
            this.logger.error("ProtectionDomain instance for {} did not exist!", c);
        }
        return null;
    }

    static {
        System.out.println("Class init: " + TILModFinderNeoForge1_21.class.getName());
    }
}

