/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.niofs.union.UnionPath;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.TILModFinderNeoForge1_21;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public class TILSelfLocator
extends TILModFinderNeoForge1_21
implements IModFileCandidateLocator {
    static final String API_PKG = "mods.thecomputerizer.theimpossiblelibrary.api";
    static final String SOURCE_NAME = "tilneoforge";
    static final String[] RELATIVE_SOURCE_PATHS = new String[]{"classes" + File.separatorChar + "java" + File.separatorChar + "main", "classes" + File.separatorChar + "java" + File.separatorChar + "tilneoforge", "resources" + File.separatorChar + "tilneoforge"};

    boolean addSelf(URL url, IDiscoveryPipeline pipeline) throws Exception {
        this.logger.info("Attempting to read self from URL {}", (Object)url);
        Object[] paths = this.fixedPath(url);
        this.logger.info("Attempting to read self from paths {}", (Object)Arrays.toString(paths));
        IModFile[] files = this.findAndLoadSelf((Path[])paths, () -> this);
        if (Objects.nonNull(files)) {
            if (files.length != 2) {
                this.logger.error("Read the wrong number of loader files?? ({} files)", (Object)files.length);
                return false;
            }
            for (IModFile file : files) {
                pipeline.addModFile(file);
            }
            return true;
        }
        this.logger.error("Read loader IModFile instances as null!");
        return false;
    }

    Path[] expandedLoaderPaths(String basePath) {
        Path[] newPaths = new Path[3];
        for (int i = 0; i < RELATIVE_SOURCE_PATHS.length; ++i) {
            newPaths[i] = Path.of(basePath + RELATIVE_SOURCE_PATHS[i], new String[0]);
        }
        return newPaths;
    }

    String extractBasePath(String pathStr) {
        for (String relativePath : RELATIVE_SOURCE_PATHS) {
            if (!pathStr.endsWith(relativePath)) continue;
            return pathStr.substring(0, pathStr.length() - relativePath.length());
        }
        this.logger.error("Failed to extract base path from {}", (Object)pathStr);
        return pathStr;
    }

    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        try {
            if (this.addSelf(this.selfLocation(), pipeline)) {
                this.logger.info("Successfully added mod file for {}", (Object)"theimpossiblelibrary");
            } else {
                this.logger.error("Failed to add self mod! Any dependents trying to load will likely break!");
            }
        }
        catch (Throwable t) {
            this.logger.error("Caught exception while trying to add self mod!", t);
        }
    }

    Path[] fixedPath(URL url) throws Exception {
        Path path;
        Path path2 = Paths.get(url.toURI());
        if (path2 instanceof UnionPath) {
            UnionPath union = (UnionPath)path2;
            path = union.getFileSystem().getPrimaryPath();
        } else {
            path = path2;
        }
        path2 = path.toAbsolutePath();
        if (TILDev.DEV) {
            File f = path2.toFile();
            String fileName = f.getName();
            if (f.isDirectory() && ("main".equals(fileName) || SOURCE_NAME.equals(fileName))) {
                return this.expandedLoaderPaths(this.extractBasePath(path2.toString()));
            }
        }
        return new Path[]{path2};
    }

    @Override
    protected Manifest getManifest(JarContents jar) {
        Manifest manifest = super.getManifest(jar);
        Attributes attributes = manifest.getMainAttributes();
        attributes.putIfAbsent(MultiVersionModFinder.MULTIVERSION_COREMODS, "mods.thecomputerizer.theimpossiblelibrary.api.core.TILCoreEntryPoint");
        attributes.putIfAbsent(MultiVersionModFinder.MULTIVERSION_MODS, "mods.thecomputerizer.theimpossiblelibrary.api.common.TILCommonEntryPoint");
        return manifest;
    }

    public int getPriority() {
        return 999;
    }
}

