/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v20.client.font;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.client.render.Render1_20;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Font1_20
extends FontAPI<Font> {
    public Font1_20() {
        super((MinecraftAPI<?> mc) -> ((Minecraft)mc.unwrap()).font);
    }

    protected void draw(@Nullable GuiGraphics graphics, String text, int x, int y, int color, boolean shadow) {
        if (Objects.nonNull(graphics) && Objects.nonNull(text)) {
            graphics.drawString((Font)this.getWrapped(), text, x, y, color, shadow);
        }
    }

    @Override
    public void draw(RenderAPI renderer, String text, float x, float y, int color) {
        this.draw(this.getGraphics(renderer), text, (int)x, (int)y, color, false);
    }

    @Override
    public void drawInBatch(Object text, float x, float y, int color, boolean shadow, Object matrix, Object source, boolean transparent, int bgColor, int light) {
        if (text instanceof FormattedCharSequence) {
            FormattedCharSequence chars = (FormattedCharSequence)text;
            if (matrix instanceof Matrix4f) {
                Matrix4f mat4f = (Matrix4f)matrix;
                if (source instanceof MultiBufferSource) {
                    MultiBufferSource buffer = (MultiBufferSource)source;
                    ((Font)this.getWrapped()).drawInBatch(chars, x, y, color, shadow, mat4f, buffer, Font.DisplayMode.NORMAL, bgColor, light);
                }
            }
        }
    }

    @Override
    public void drawWithShadow(RenderAPI renderer, String text, float x, float y, int color) {
        this.draw(this.getGraphics(renderer), text, (int)x, (int)y, color, true);
    }

    @Override
    public int getCharWidth(char c) {
        return this.getStringWidth("" + c);
    }

    @Override
    public int getFontHeight() {
        Objects.requireNonNull((Font)this.getWrapped());
        return 9;
    }

    @Nullable
    protected GuiGraphics getGraphics(RenderAPI renderer) {
        GuiGraphics guiGraphics;
        if (renderer instanceof Render1_20) {
            Render1_20 render20 = (Render1_20)renderer;
            guiGraphics = render20.getGraphics();
        } else {
            guiGraphics = null;
        }
        return guiGraphics;
    }

    @Override
    public int getStringWidth(String str) {
        return this.getStringWidth(str, Font::width);
    }

    @Override
    public String trimStringTo(String str, int width, boolean withReset) {
        if (Objects.isNull(str)) {
            return "";
        }
        String trimmed = ((Font)this.getWrapped()).plainSubstrByWidth(str, width);
        String reset = ChatFormatting.RESET.toString();
        return !withReset && trimmed.endsWith(reset) ? trimmed.substring(0, trimmed.length() - reset.length()) : trimmed;
    }
}

