/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v20.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;

public class VertexWrapper1_20
extends VertexWrapper {
    protected final VertexFormat format;
    protected final VertexFormat.Mode formatMode;
    protected final Tesselator tesselator;
    protected final BufferBuilder buffer;

    public VertexWrapper1_20(VertexFormat.Mode mode, VertexFormat format, int numVertices, int ... vertexSizes) {
        super(mode.asGLMode, numVertices, vertexSizes);
        this.format = format;
        this.formatMode = mode;
        this.tesselator = mode == VertexFormat.Mode.LINES || mode == VertexFormat.Mode.LINE_STRIP ? RenderSystem.renderThreadTesselator() : Tesselator.getInstance();
        this.buffer = this.tesselator.getBuilder();
    }

    @Override
    protected void begin() {
        this.buffer.begin(this.formatMode, this.format);
    }

    @Override
    protected void draw() {
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)this.buffer.end());
    }

    @Override
    protected void onVertexEnded(Number[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            this.pushBuffer((VertexFormatElement)this.format.getElements().get(i), numbers[i]);
        }
        this.buffer.endVertex();
    }

    protected void pushBuffer(VertexFormatElement element, Number[] numbers) {
        int count = element.getCount();
        VertexFormatElement.Type type = element.getType();
        VertexFormatElement.Usage usage = element.getUsage();
        if (numbers.length != count && (numbers.length != 1 || usage != VertexFormatElement.Usage.COLOR)) {
            TILRef.logError("Incorrect buffer size {} for VertextFormatElement! (Count={}|Type={}|Usage={}!", numbers.length, count, type, usage);
            return;
        }
        switch (usage) {
            case COLOR: {
                if (numbers.length == 1) {
                    this.buffer.color(numbers[0].intValue());
                } else {
                    Number r = numbers[0];
                    Number g = numbers[1];
                    Number b = numbers[2];
                    Number a = numbers[3];
                    if (r instanceof Integer || r instanceof Long || r instanceof Short) {
                        this.buffer.color(r.intValue(), g.intValue(), b.intValue(), a.intValue());
                    } else {
                        this.buffer.color(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
                    }
                }
                return;
            }
            case NORMAL: {
                this.buffer.normal(numbers[0].floatValue(), numbers[1].floatValue(), numbers[2].floatValue());
                return;
            }
            case POSITION: {
                this.buffer.vertex(numbers[0].doubleValue(), numbers[1].doubleValue(), numbers[2].doubleValue());
                return;
            }
            case UV: {
                Number u = numbers[0];
                Number v = numbers[1];
                if (type == VertexFormatElement.Type.FLOAT) {
                    this.buffer.uv(u.floatValue(), v.floatValue());
                } else {
                    this.buffer.uv2(u.intValue(), v.intValue());
                }
                return;
            }
        }
        TILRef.logError("Unsupported VertextFormatElement (Count={}|Type={}|Usage={}!", count, type, usage);
    }
}

