/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v21.network;

import io.netty.buffer.ByteBuf;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public abstract class MessageWrapper1_21<CTX>
extends MessageWrapperAPI<ServerPlayer, CTX>
implements CustomPacketPayload {
    protected static final String TYPE_BASE = "message_wrapper";

    public static <M extends MessageWrapper1_21<?>> M getPayloadInstance(Object dir) {
        return (M)((MessageWrapper1_21)GenericUtils.cast(NetworkHelper.isDirToClient(dir) ? new Client() : new Server()));
    }

    public static <M extends MessageWrapper1_21<?>> M getPayloadInstance(ByteBuf buf, Object dir) {
        return (M)((MessageWrapper1_21)GenericUtils.cast(NetworkHelper.isDirToClient(dir) ? new Client(buf) : new Server(buf)));
    }

    public static PacketFlow getClassFlow(Class<?> msgCls) {
        return (PacketFlow)Hacks.getFieldStatic(msgCls, "FLOW");
    }

    public static <CTX, M extends MessageWrapper1_21<CTX>> CustomPacketPayload.Type<M> getClassType(Class<?> msgCls) {
        return (CustomPacketPayload.Type)Hacks.getFieldStatic(msgCls, "TYPE");
    }

    public static <B extends ByteBuf, CTX, M extends MessageWrapper1_21<CTX>> StreamCodec<B, M> streamCodec(Object dir) {
        StreamEncoder encoder = (buf, msg) -> msg.encode((ByteBuf)buf);
        StreamDecoder decoder = buf -> MessageWrapper1_21.getPayloadInstance(buf, dir);
        return StreamCodec.of((StreamEncoder)encoder, (StreamDecoder)decoder);
    }

    protected MessageWrapper1_21() {
    }

    protected MessageWrapper1_21(ByteBuf buf) {
        super(buf);
    }

    public static final class Client<CTX>
    extends MessageWrapper1_21<CTX> {
        @IndirectCallers
        public static PacketFlow FLOW = PacketFlow.CLIENTBOUND;
        public static CustomPacketPayload.Type<Client<?>> TYPE = new CustomPacketPayload.Type((ResourceLocation)TILRef.res("message_wrapper_client").unwrap());

        Client() {
        }

        Client(ByteBuf buf) {
            super(buf);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static final class Server<CTX>
    extends MessageWrapper1_21<CTX> {
        @IndirectCallers
        public static PacketFlow FLOW = PacketFlow.SERVERBOUND;
        public static CustomPacketPayload.Type<Client<?>> TYPE = new CustomPacketPayload.Type((ResourceLocation)TILRef.res("message_wrapper_server").unwrap());

        Server() {
        }

        Server(ByteBuf buf) {
            super(buf);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

