/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.Context;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Fields;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MembersRetriever;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;

public class Classes
implements MembersRetriever {
    Field[] emtpyFieldsArray = new Field[0];
    Method[] emptyMethodsArray = new Method[0];
    Constructor<?>[] emptyConstructorsArray = new Constructor[0];

    private Classes() {
    }

    public static Classes create() {
        return new Classes();
    }

    public <T> Class<T> retrieveFrom(Object object) {
        return object != null ? object.getClass() : null;
    }

    public Class<?>[] retrieveFrom(Object ... objects) {
        Class[] classes = null;
        if (objects != null) {
            classes = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                classes[i] = this.retrieveFrom(objects[i]);
            }
        } else {
            classes = new Class[]{null};
        }
        return classes;
    }

    public String retrieveName(Throwable exc) {
        String className = exc.getMessage();
        if (className != null) {
            if (className.contains("Could not initialize class ")) {
                className = className.replace("Could not initialize class ", "");
            }
            if (className.contains("NoClassDefFoundError: ")) {
                className = className.substring(className.lastIndexOf("NoClassDefFoundError: ") + "NoClassDefFoundError: ".length());
            }
            if (className.contains("class: ")) {
                className = className.substring(className.lastIndexOf("class: ") + "class: ".length());
            }
            return className.contains(" ") ? null : className.replace("/", ".");
        }
        return className;
    }

    public Collection<String> retrieveNames(Throwable exc) {
        LinkedHashSet<String> classesName = new LinkedHashSet<String>();
        Optional.ofNullable(this.retrieveName(exc)).map(classesName::add);
        if (exc.getCause() != null) {
            classesName.addAll(this.retrieveNames(exc.getCause()));
        }
        return classesName;
    }

    public String retrievePackageName(String className) {
        String packageName = null;
        if (className.contains(".")) {
            packageName = className.substring(0, className.lastIndexOf("."));
        }
        return packageName;
    }

    public String retrieveSimpleName(String className) {
        String classSimpleName = null;
        classSimpleName = className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
        if (classSimpleName.contains("$")) {
            classSimpleName = classSimpleName.substring(classSimpleName.lastIndexOf("$") + 1);
        }
        return classSimpleName;
    }

    public String toPath(Class<?> cls) {
        String path = cls.getSimpleName().replace(".", "$");
        Package pckg = cls.getPackage();
        if (pckg != null) {
            path = pckg.getName().replace(".", "/") + "/" + path + ".class";
        }
        return path;
    }

    public String toPath(String className) {
        return className.replace(".", "/");
    }

    public ClassLoader getClassLoader(Class<?> cls) {
        ClassLoader clsLoader = cls.getClassLoader();
        if (clsLoader == null) {
            clsLoader = ClassLoader.getSystemClassLoader();
        }
        return clsLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getByteCode(Class<?> cls) {
        if (cls.isPrimitive()) {
            return null;
        }
        ClassLoader clsLoader = this.getClassLoader(cls);
        try (InputStream inputStream = clsLoader.getResourceAsStream(cls.getName().replace(".", "/") + ".class");){
            ByteBuffer byteBuffer = StaticComponentContainer.Streams.toByteBuffer(inputStream);
            return byteBuffer;
        }
        catch (IOException exc) {
            return (ByteBuffer)StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public <T> T newInstance(Constructor<T> ctor, Object ... params) {
        if (params == null) {
            params = new Object[]{null};
        }
        try {
            return ctor.newInstance(params);
        }
        catch (Throwable exc) {
            return StaticComponentContainer.Driver.newInstance(ctor, params);
        }
    }

    @Override
    public Field[] getDeclaredFields(Class<?> cls) {
        return StaticComponentContainer.Cache.classLoaderForFields.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredFields(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not retrieve fields of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emtpyFieldsArray;
            }
        });
    }

    @Override
    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) {
        return StaticComponentContainer.Cache.classLoaderForConstructors.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredConstructors(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not retrieve constructors of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emptyConstructorsArray;
            }
        });
    }

    @Override
    public Method[] getDeclaredMethods(Class<?> cls) {
        return StaticComponentContainer.Cache.classLoaderForMethods.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredMethods(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not retrieve methods of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emptyMethodsArray;
            }
        });
    }

    String getCacheKey(Class<?> cls) {
        return cls.getName().replace(".", "/");
    }

    public boolean isLoadedBy(Class<?> cls, ClassLoader classLoader) {
        ClassLoader parentClassLoader = null;
        if (cls.getClassLoader() == classLoader) {
            return true;
        }
        if (classLoader != null && (parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(classLoader)) != null) {
            return this.isLoadedBy(cls, parentClassLoader);
        }
        return false;
    }

    public boolean isAssignableFrom(Class<?> cls_01, Class<?> cls_02) {
        return this.getClassOrWrapper(cls_01).isAssignableFrom(this.getClassOrWrapper(cls_02));
    }

    public Class<?> getClassOrWrapper(Class<?> cls) {
        return io.github.toolfactory.jvm.util.Classes.getClassOrWrapper(cls);
    }

    public <I> Function<Integer, ?> buildArrayValueRetriever(I items) {
        Class<?> componentType = items.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Short.TYPE) {
                short[] itemArray = (short[])items;
                return index -> itemArray[index];
            }
            if (componentType == Integer.TYPE) {
                int[] itemArray = (int[])items;
                return index -> itemArray[index];
            }
            if (componentType == Long.TYPE) {
                long[] itemArray = (long[])items;
                return index -> itemArray[index];
            }
            if (componentType == Float.TYPE) {
                float[] itemArray = (float[])items;
                return index -> Float.valueOf(itemArray[index]);
            }
            if (componentType == Double.TYPE) {
                double[] itemArray = (double[])items;
                return index -> itemArray[index];
            }
            if (componentType == Boolean.TYPE) {
                boolean[] itemArray = (boolean[])items;
                return index -> itemArray[index];
            }
            if (componentType == Byte.TYPE) {
                byte[] itemArray = (byte[])items;
                return index -> itemArray[index];
            }
            if (componentType == Character.TYPE) {
                char[] itemArray = (char[])items;
                return index -> Character.valueOf(itemArray[index]);
            }
        }
        Object[] itemArray = (Object[])items;
        return index -> itemArray[index];
    }

    public Class<?> getComponentType(Class<?> cls) {
        if (!cls.isArray()) {
            throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("{} is not an array type", cls.getName()));
        }
        while ((cls = cls.getComponentType()).isArray()) {
        }
        return cls;
    }

    public static class Loaders
    implements Closeable {
        protected Map<ClassLoader, Map<String, ?>> classLoadersPackages = new HashMap();
        protected Map<String, MethodHandle> classLoadersMethods = new HashMap<String, MethodHandle>();
        protected Field builtinClassLoaderClassParentField;
        protected Collection<NotificationListenerOfParentsChange> registeredNotificationListenerOfParentsChange;

        private Loaders() {
            Class<?> builtinClassLoaderClass = StaticComponentContainer.Driver.getBuiltinClassLoaderClass();
            if (builtinClassLoaderClass != null) {
                this.builtinClassLoaderClassParentField = StaticComponentContainer.Fields.findFirstAndMakeItAccessible(builtinClassLoaderClass, "parent", builtinClassLoaderClass);
            }
            this.registeredNotificationListenerOfParentsChange = ConcurrentHashMap.newKeySet();
            Class cls = ChangeParentsContext.class;
            cls = ChangeParentsContext.Elements.class;
        }

        public static Loaders create() {
            return new Loaders();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerNotificationListenerOfParentsChange(NotificationListenerOfParentsChange listener) {
            Collection<NotificationListenerOfParentsChange> collection = this.registeredNotificationListenerOfParentsChange;
            synchronized (collection) {
                this.registeredNotificationListenerOfParentsChange.add(listener);
            }
        }

        private void notifyParentsChange(ChangeParentsContext context) {
            for (NotificationListenerOfParentsChange listener : this.registeredNotificationListenerOfParentsChange) {
                try {
                    listener.receive(context);
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Could not notify parent change to listener {}", exc, listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterNotificationListenerOfParentsChange(NotificationListenerOfParentsChange listener) {
            Collection<NotificationListenerOfParentsChange> collection = this.registeredNotificationListenerOfParentsChange;
            synchronized (collection) {
                this.registeredNotificationListenerOfParentsChange.remove(listener);
            }
        }

        public Collection<ClassLoader> getAllParents(ClassLoader classLoader) {
            return this.getHierarchy(classLoader, false);
        }

        public Collection<ClassLoader> getHierarchy(ClassLoader classLoader) {
            return this.getHierarchy(classLoader, true);
        }

        private Collection<ClassLoader> getHierarchy(ClassLoader classLoader, boolean includeClassLoader) {
            LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
            if (includeClassLoader) {
                classLoaders.add(classLoader);
            }
            while ((classLoader = this.getParent(classLoader)) != null) {
                classLoaders.add(classLoader);
            }
            return classLoaders;
        }

        public Function<Boolean, ClassLoader> setAsMaster(ClassLoader classLoader, ClassLoader futureParent) {
            return this.setAsParent(this.getMaster(classLoader), futureParent);
        }

        public Function<Boolean, ClassLoader> setAsParent(ClassLoader target, ClassLoader originalFutureParent) {
            return this.setAsParent(target, originalFutureParent, true);
        }

        public Function<Boolean, ClassLoader> setAsParent(ClassLoader target, ClassLoader newParent, boolean mantainHierarchy) {
            if (target == newParent) {
                throw new IllegalArgumentException("The target cannot be the same instance");
            }
            ClassLoader oldParent = this.getParent(target);
            if (oldParent == newParent) {
                throw new IllegalArgumentException("The new parent cannot be the same of the old parent");
            }
            return StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(target), () -> StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getIdOrUUIDIfNull(newParent), () -> {
                if (mantainHierarchy) {
                    AtomicReference<Function<Boolean, ClassLoader>> resetterOne = new AtomicReference<Function<Boolean, ClassLoader>>();
                    if (oldParent != null && newParent != null) {
                        ClassLoader masterClassLoaderOfOriginalFutureParent = this.getMaster(newParent);
                        if (masterClassLoaderOfOriginalFutureParent != newParent) {
                            resetterOne.set(this.setAsParent0(masterClassLoaderOfOriginalFutureParent, oldParent));
                        } else {
                            resetterOne.set(this.setAsParent0(newParent, oldParent));
                        }
                    }
                    Function<Boolean, ClassLoader> resetterTwo = this.setAsParent0(target, newParent);
                    return resetterOne.get() != null ? reset -> StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(target), () -> StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getIdOrUUIDIfNull(newParent), () -> {
                        ClassLoader targetExParent = (ClassLoader)resetterTwo.apply((Boolean)reset);
                        ((Function)resetterOne.get()).apply(reset);
                        return targetExParent;
                    })) : resetterTwo;
                }
                return this.setAsParent0(target, newParent);
            }));
        }

        private Function<Boolean, ClassLoader> setAsParent0(ClassLoader target, ClassLoader originalFutureParent) {
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(target)) {
                return this.setAsParent((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)target, "classLoader"), originalFutureParent);
            }
            ClassLoader futureParentTemp = originalFutureParent;
            if (StaticComponentContainer.Driver.isBuiltinClassLoader(target) && futureParentTemp != null) {
                futureParentTemp = this.convertToBuiltinClassLoader(futureParentTemp);
            }
            ClassLoader targetExParent = (ClassLoader)StaticComponentContainer.Fields.get((Object)target, "parent");
            ClassLoader futureParent = futureParentTemp;
            this.checkAndRegisterOrUnregisterMemoryClassLoaders(target, targetExParent, originalFutureParent);
            StaticComponentContainer.Fields.setDirect((Object)target, "parent", (Object)futureParent);
            this.notifyParentsChange(new ChangeParentsContext(target, futureParent, targetExParent));
            return reset -> {
                if (reset.booleanValue()) {
                    StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(target), () -> StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getIdOrUUIDIfNull(originalFutureParent), () -> {
                        this.checkAndRegisterOrUnregisterMemoryClassLoaders(target, originalFutureParent, targetExParent);
                        StaticComponentContainer.Fields.setDirect((Object)target, "parent", (Object)targetExParent);
                        this.notifyParentsChange(new ChangeParentsContext(target, targetExParent, futureParent));
                    }));
                }
                return targetExParent;
            };
        }

        private void checkAndRegisterOrUnregisterMemoryClassLoaders(ClassLoader target, ClassLoader exParent, ClassLoader futureParent) {
            MemoryClassLoader targetMemoryClassLoader;
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(target)) {
                target = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)target, "classLoader");
            }
            if (exParent != null && StaticComponentContainer.Driver.isClassLoaderDelegate(exParent)) {
                exParent = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)exParent, "classLoader");
            }
            if (StaticComponentContainer.Driver.getBuiltinClassLoaderClass() != null && futureParent != null && StaticComponentContainer.Driver.isClassLoaderDelegate(futureParent)) {
                futureParent = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)futureParent, "classLoader");
            }
            MemoryClassLoader exParentMC = exParent instanceof MemoryClassLoader ? (MemoryClassLoader)exParent : null;
            MemoryClassLoader futureParentMC = futureParent instanceof MemoryClassLoader ? (MemoryClassLoader)futureParent : null;
            MemoryClassLoader memoryClassLoader = targetMemoryClassLoader = target instanceof MemoryClassLoader ? (MemoryClassLoader)target : null;
            if (targetMemoryClassLoader != null) {
                if (futureParentMC != null) {
                    futureParentMC.register(targetMemoryClassLoader);
                }
                if (exParentMC != null) {
                    exParentMC.unregister(targetMemoryClassLoader);
                }
            }
        }

        public ClassLoader convertToBuiltinClassLoader(ClassLoader classLoader) {
            if (StaticComponentContainer.Driver.getBuiltinClassLoaderClass() == null) {
                return null;
            }
            if (StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                return classLoader;
            }
            try {
                return (ClassLoader)StaticComponentContainer.Constructors.newInstanceDirectOf(StaticComponentContainer.Driver.getClassLoaderDelegateClass(), null, classLoader, StaticComponentContainer.Methods.findFirstDirectHandle((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("loadClass"::equals)).and()).parameterTypesAreAssignableFrom(String.class, Boolean.TYPE), classLoader.getClass()));
            }
            catch (Throwable exc) {
                return (ClassLoader)StaticComponentContainer.Driver.throwException(exc);
            }
        }

        public ClassLoader getParent(ClassLoader classLoader) {
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.getParent((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"));
            }
            if (StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                return Executor.get(() -> (ClassLoader)this.builtinClassLoaderClassParentField.get(classLoader));
            }
            return classLoader.getParent();
        }

        public ClassLoader getMaster(ClassLoader classLoader) {
            ClassLoader parentClassLoader = null;
            while ((parentClassLoader = this.getParent(classLoader)) != null) {
                classLoader = parentClassLoader;
            }
            return classLoader;
        }

        public MethodHandle getDefinePackageMethod(ClassLoader classLoader) {
            return this.getMethod(classLoader.getClass().getName() + "_definePackage", () -> this.findDefinePackageMethodAndMakeItAccesible(classLoader));
        }

        private MethodHandle findDefinePackageMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("definePackage"::equals)).and()).parameterTypesAreAssignableFrom(String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), classLoader.getClass());
        }

        public MethodHandle getDefineClassMethod(ClassLoader classLoader) {
            return this.getMethod(StaticComponentContainer.Classes.getClassLoader(classLoader.getClass()) + "_" + classLoader + "_defineClass", () -> this.findDefineClassMethodAndMakeItAccesible(classLoader));
        }

        Object getClassLoadingLock(ClassLoader classLoader, String className) {
            try {
                return this.getGetClassLoadingLockMethod(classLoader).invokeWithArguments(classLoader, className);
            }
            catch (Throwable exc) {
                return StaticComponentContainer.Driver.throwException(exc);
            }
        }

        public MethodHandle getGetClassLoadingLockMethod(ClassLoader classLoader) {
            return this.getMethod(StaticComponentContainer.Classes.getClassLoader(classLoader.getClass()) + "_" + classLoader + "_getClassLoadingLock", () -> this.findGetClassLoadingLockMethodAndMakeItAccesible(classLoader));
        }

        private MethodHandle findDefineClassMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle(((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name((classLoader instanceof MemoryClassLoader ? "_defineClass" : "defineClass")::equals)).and()).parameterTypes(params -> ((Class[])params).length == 3)).and()).parameterTypesAreAssignableFrom(String.class, ByteBuffer.class, ProtectionDomain.class)).and()).returnType(cls -> cls.getName().equals(Class.class.getName())), classLoader.getClass());
        }

        private MethodHandle findGetClassLoadingLockMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("getClassLoadingLock"::equals)).and()).parameterTypes(params -> ((Class[])params).length == 1)).and()).parameterTypesAreAssignableFrom(String.class), classLoader.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MethodHandle getMethod(String key, Supplier<MethodHandle> methodSupplier) {
            MethodHandle method = this.classLoadersMethods.get(key);
            if (method == null) {
                Map<String, MethodHandle> map = this.classLoadersMethods;
                synchronized (map) {
                    method = this.classLoadersMethods.get(key);
                    if (method == null) {
                        method = methodSupplier.get();
                        this.classLoadersMethods.put(key, method);
                    }
                }
            }
            return method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, ?> retrieveLoadedPackages(ClassLoader classLoader) {
            Map<String, ?> packages = this.classLoadersPackages.get(classLoader);
            if (packages == null) {
                Map<ClassLoader, Map<String, ?>> map = this.classLoadersPackages;
                synchronized (map) {
                    packages = this.classLoadersPackages.get(classLoader);
                    if (packages == null) {
                        packages = StaticComponentContainer.Driver.retrieveLoadedPackages(classLoader);
                        this.classLoadersPackages.put(classLoader, packages);
                    }
                }
            }
            if (packages == null) {
                StaticComponentContainer.Driver.throwException("Could not find packages Map on {}", classLoader);
            }
            return packages;
        }

        public <T> Class<T> loadOrDefineByJavaClass(JavaClass javaClass, ClassLoader classLoader) throws ClassNotFoundException {
            HashMap<String, JavaClass> repository = new HashMap<String, JavaClass>();
            repository.put(javaClass.getName(), javaClass);
            return this.loadOrDefineByJavaClass(javaClass.getName(), repository, classLoader);
        }

        public <T> Class<T> loadOrDefineByJavaClass(String className, Map<String, JavaClass> byteCodes, ClassLoader classLoader) throws ClassNotFoundException {
            if (!(classLoader instanceof MemoryClassLoader)) {
                return this.loadOrDefineByByteCode(className, clsName -> ((JavaClass)byteCodes.get(clsName)).getByteCode(), classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
            }
            for (Map.Entry<String, JavaClass> clazz : byteCodes.entrySet()) {
                ((MemoryClassLoader)classLoader).addByteCode(clazz.getKey(), clazz.getValue().getByteCode());
            }
            return classLoader.loadClass(className);
        }

        public Class<?> loadOrDefineByByteCode(ByteBuffer byteCode, ClassLoader classLoader) throws ClassNotFoundException {
            HashMap repository = new HashMap();
            return JavaClass.extractByUsing(byteCode, javaClass -> {
                repository.put(javaClass.getName(), javaClass);
                return this.loadOrDefineByJavaClass(javaClass.getName(), repository, classLoader);
            });
        }

        public <T> Class<T> loadOrDefineByByteCode(String className, Map<String, ByteBuffer> repository, ClassLoader classLoader) throws ClassNotFoundException {
            if (!(classLoader instanceof MemoryClassLoader)) {
                return this.loadOrDefineByByteCode(className, clsName -> (ByteBuffer)repository.get(clsName), classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
            }
            for (Map.Entry<String, ByteBuffer> clazz : repository.entrySet()) {
                ((MemoryClassLoader)classLoader).addByteCode(clazz.getKey(), clazz.getValue());
            }
            return classLoader.loadClass(className);
        }

        private <T> Class<T> loadOrDefineByByteCode(String className, Function<String, ByteBuffer> byteCodeSupplier, ClassLoader classLoader, MethodHandle defineClassMethod, MethodHandle definePackageMethod) throws ClassNotFoundException {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                try {
                    Class<T> cls = this.defineOrLoad(classLoader, defineClassMethod, className, byteCodeSupplier.apply(className));
                    this.definePackageFor(cls, classLoader, definePackageMethod);
                    return cls;
                }
                catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc2) {
                    if (byteCodeSupplier.apply(className) == null) {
                        throw new ClassNotFoundException(className);
                    }
                    String newNotFoundClassName = StaticComponentContainer.Classes.retrieveNames(exc2).stream().findFirst().orElseGet(() -> null);
                    this.loadOrDefineByByteCode(newNotFoundClassName, byteCodeSupplier, classLoader, defineClassMethod, definePackageMethod);
                    return this.loadOrDefineByByteCode(className, byteCodeSupplier, classLoader, defineClassMethod, definePackageMethod);
                }
            }
        }

        public <T> Class<T> loadOrDefine(Class<T> toLoad, ClassLoader classLoader) throws ClassNotFoundException {
            return this.loadOrDefine(toLoad, classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
        }

        private <T> Class<T> loadOrDefine(Class<T> toLoad, ClassLoader classLoader, MethodHandle defineClassMethod, MethodHandle definePackageMethod) throws ClassNotFoundException {
            String className = toLoad.getName();
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                try {
                    Class<T> cls = this.defineOrLoad(classLoader, defineClassMethod, className, StaticComponentContainer.BufferHandler.shareContent(StaticComponentContainer.Classes.getByteCode(toLoad)));
                    this.definePackageFor(cls, classLoader, definePackageMethod);
                    return cls;
                }
                catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc2) {
                    String newNotFoundClassName = StaticComponentContainer.Classes.retrieveNames(exc2).stream().findFirst().orElseGet(() -> null);
                    this.loadOrDefine(StaticComponentContainer.Driver.getClassByName(newNotFoundClassName, false, StaticComponentContainer.Classes.getClassLoader(toLoad), this.getClass()), classLoader, defineClassMethod, definePackageMethod);
                    return this.loadOrDefine(StaticComponentContainer.Driver.getClassByName(className, false, StaticComponentContainer.Classes.getClassLoader(toLoad), this.getClass()), classLoader, defineClassMethod, definePackageMethod);
                }
            }
        }

        public <T> Class<T> defineOrLoad(ClassLoader classLoader, JavaClass javaClass) throws ReflectiveOperationException {
            String className = javaClass.getName();
            Class<T> definedClass = this.defineOrLoad(classLoader, this.getDefineClassMethod(classLoader), className, javaClass.getByteCode());
            this.definePackageFor(definedClass, classLoader, this.getDefinePackageMethod(classLoader));
            return definedClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Class<T> defineOrLoad(ClassLoader classLoader, MethodHandle method, String className, ByteBuffer byteCode) throws ClassNotFoundException, InvocationTargetException, NoClassDefFoundError {
            try {
                Object object = this.getClassLoadingLock(classLoader, className);
                synchronized (object) {
                    return (Class)method.invokeWithArguments(classLoader, className, byteCode, null);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc) {
                throw exc;
            }
            catch (LinkageError exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Class {} is already defined", className);
                return classLoader.loadClass(className);
            }
            catch (Throwable exc) {
                if (byteCode == null) {
                    throw new ClassNotFoundException(className);
                }
                return (Class)StaticComponentContainer.Driver.throwException(exc);
            }
        }

        private Package definePackage(ClassLoader classLoader, MethodHandle definePackageMethod, String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
            return Executor.get(() -> {
                try {
                    return (Package)definePackageMethod.invokeWithArguments(classLoader, name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
                catch (IllegalArgumentException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Package " + name + " already defined");
                    return this.retrieveLoadedPackage(classLoader, name);
                }
            });
        }

        private void definePackageFor(Class<?> cls, ClassLoader classLoader, MethodHandle definePackageMethod) {
            String pckgName;
            if (cls.getName().contains(".") && this.retrieveLoadedPackage(classLoader, pckgName = cls.getName().substring(0, cls.getName().lastIndexOf("."))) == null) {
                StaticComponentContainer.Synchronizer.execute(classLoader + "_" + pckgName, () -> {
                    if (this.retrieveLoadedPackage(classLoader, pckgName) == null) {
                        this.definePackage(classLoader, definePackageMethod, pckgName, null, null, null, null, null, null, null);
                    }
                });
            }
        }

        public Package retrieveLoadedPackage(ClassLoader classLoader, String packageName) {
            Map<String, ?> packages = this.retrieveLoadedPackages(classLoader);
            Object packageToFind = packages.get(packageName);
            ClassLoader parentClassLoader = null;
            if (packageToFind != null) {
                if (packageToFind instanceof Package) {
                    return (Package)packageToFind;
                }
                return StaticComponentContainer.Driver.getPackage(classLoader, packageName);
            }
            parentClassLoader = this.getParent(classLoader);
            if (parentClassLoader != null) {
                return this.retrieveLoadedPackage(parentClassLoader, packageName);
            }
            return null;
        }

        public ClassLoader getClassLoaderOfPath(ClassLoader classLoader, String path) {
            FileSystemItem fIS = FileSystemItem.ofPath(path);
            ClassLoader pathLoader = null;
            for (ClassLoader cl : this.getHierarchy(classLoader)) {
                URL[] urls = this.getURLs(cl);
                if (urls == null) continue;
                for (URL url : urls) {
                    FileSystemItem loadedPathFIS = FileSystemItem.of(url);
                    if (!loadedPathFIS.equals(fIS) && !loadedPathFIS.isParentOf(fIS)) continue;
                    pathLoader = cl;
                }
            }
            return pathLoader;
        }

        public boolean isItPossibleToAddClassPaths(ClassLoader classLoader) {
            if (classLoader != null) {
                if (classLoader instanceof URLClassLoader || StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader) || classLoader instanceof PathScannerClassLoader) {
                    return true;
                }
                return this.isItPossibleToAddClassPaths(this.getParent(classLoader));
            }
            return false;
        }

        public Collection<String> addClassPath(ClassLoader classLoader, String ... classPaths) {
            return this.addClassPaths(classLoader, Arrays.asList(classPaths));
        }

        public Collection<String> addClassPath(ClassLoader classLoader, Predicate<String> checkForAddedClasses, String ... classPaths) {
            return this.addClassPaths(classLoader, checkForAddedClasses, Arrays.asList(classPaths));
        }

        public Collection<String> addClassPaths(ClassLoader classLoader, Predicate<String> checkForAddedClasses, Collection<String> ... classPathCollections) {
            if (!(classLoader instanceof URLClassLoader || StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader) || classLoader instanceof PathScannerClassLoader)) {
                if (!this.isItPossibleToAddClassPaths(classLoader)) {
                    throw new UnsupportedException(StaticComponentContainer.Strings.compile("Could not add class paths to {} because the type {} is not supported", StaticComponentContainer.Objects.getId(classLoader), classLoader.getClass()));
                }
                return this.addClassPaths(this.getParent(classLoader), checkForAddedClasses, classPathCollections);
            }
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.addClassPaths((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"), checkForAddedClasses, classPathCollections);
            }
            HashSet<String> paths = new HashSet<String>();
            for (Collection<String> classPaths : classPathCollections) {
                paths.addAll(classPaths);
            }
            return StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(classLoader), () -> {
                if (classLoader instanceof URLClassLoader || StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                    paths.removeAll(this.getAllLoadedPaths(classLoader));
                    if (!paths.isEmpty()) {
                        ClassLoader target;
                        ClassLoader classLoader2 = target = classLoader instanceof URLClassLoader ? classLoader : StaticComponentContainer.Fields.getDirect((Object)classLoader, "ucp");
                        if (target != null) {
                            Consumer<URL> classPathAdder = urls -> StaticComponentContainer.Methods.invokeDirect(target, "addURL", urls);
                            paths.stream().map(classPath -> FileSystemItem.ofPath(classPath).getURL()).forEach(url -> classPathAdder.accept((URL)url));
                            return paths;
                        }
                    }
                } else if (classLoader instanceof PathScannerClassLoader) {
                    return ((PathScannerClassLoader)classLoader).scanPathsAndAddAllByteCodesFound(paths, checkForAddedClasses);
                }
                return new HashSet();
            });
        }

        public Collection<String> addClassPaths(ClassLoader classLoader, Collection<String> ... classPathCollections) {
            return this.addClassPaths(classLoader, (String path) -> true, classPathCollections);
        }

        public Collection<String> getLoadedPaths(ClassLoader classLoader) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (classLoader instanceof PathScannerClassLoader) {
                paths.addAll(((PathScannerClassLoader)classLoader).loadedPaths.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
            } else {
                URL[] resUrl = this.getURLs(classLoader);
                if (resUrl != null) {
                    for (URL element : resUrl) {
                        paths.add(StaticComponentContainer.Paths.convertURLPathToAbsolutePath(element.getPath()));
                    }
                }
            }
            return paths;
        }

        public Collection<String> getAllLoadedPaths(ClassLoader classLoader) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            while (classLoader != null) {
                paths.addAll(this.getLoadedPaths(classLoader));
                classLoader = this.getParent(classLoader);
            }
            return paths;
        }

        public URL[] getURLs(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return ((URLClassLoader)classLoader).getURLs();
            }
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.getURLs((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"));
            }
            if (StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                Object urlClassPath = StaticComponentContainer.Fields.getDirect((Object)classLoader, "ucp");
                ArrayList<URL> urls = new ArrayList<URL>();
                if (urlClassPath != null) {
                    urls.addAll(Arrays.asList((URL[])StaticComponentContainer.Methods.invoke(urlClassPath, "getURLs", new Object[0])));
                }
                Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)classLoader, "nameToModule");
                Map moduleToReader = (Map)StaticComponentContainer.Fields.getDirect((Object)classLoader, "moduleToReader");
                if (nameToModule != null) {
                    for (Object moduleReference : nameToModule.values()) {
                        URI uri = (URI)StaticComponentContainer.Fields.getDirect(moduleReference, "location");
                        try {
                            URL url = uri.toURL();
                            if (!url.toString().startsWith("file")) continue;
                            Object moduleReader = moduleToReader.get(moduleReference);
                            try {
                                Collection finders = (Collection)StaticComponentContainer.Fields.getDirect(moduleReader, "finders");
                                if (finders != null) {
                                    for (Object finder : finders) {
                                        Path path = (Path)StaticComponentContainer.Fields.getDirect(finder, "dir");
                                        if (path == null) continue;
                                        urls.add(path.toUri().toURL());
                                    }
                                }
                            }
                            catch (Fields.NoSuchFieldException noSuchFieldException) {
                                // empty catch block
                            }
                            urls.add(url);
                        }
                        catch (MalformedURLException exc) {
                            StaticComponentContainer.Driver.throwException(exc);
                        }
                    }
                }
                return urls.toArray(new URL[urls.size()]);
            }
            if (classLoader instanceof PathScannerClassLoader) {
                return ((PathScannerClassLoader)classLoader).getURLs();
            }
            return null;
        }

        public void unregister(ClassLoader classLoader) {
            this.classLoadersPackages.remove(classLoader);
        }

        @Override
        public void close() {
            if (this != StaticComponentContainer.ClassLoaders) {
                this.classLoadersMethods.clear();
                this.classLoadersMethods = null;
                this.classLoadersPackages.clear();
                this.classLoadersPackages = null;
                this.builtinClassLoaderClassParentField = null;
            } else {
                StaticComponentContainer.Driver.throwException("Could not close singleton instance {}", this);
            }
        }

        public static class ChangeParentsContext
        extends Context {
            private ChangeParentsContext(ClassLoader target, ClassLoader newParent, ClassLoader oldParent) {
                this.put(Elements.TARGET, target);
                this.put(Elements.NEW_PARENT, newParent);
                this.put(Elements.OLD_PARENT, oldParent);
            }

            public <C extends ClassLoader> C getTarget() {
                return (C)((ClassLoader)this.get(Elements.TARGET));
            }

            public <C extends ClassLoader> C getNewParent() {
                return (C)((ClassLoader)this.get(Elements.NEW_PARENT));
            }

            public <C extends ClassLoader> C getOldParent() {
                return (C)((ClassLoader)this.get(Elements.OLD_PARENT));
            }

            private static enum Elements {
                TARGET,
                NEW_PARENT,
                OLD_PARENT;

            }
        }

        public static interface NotificationListenerOfParentsChange {
            public void receive(ChangeParentsContext var1);
        }

        public static class UnsupportedException
        extends RuntimeException {
            private static final long serialVersionUID = 8964839983768809586L;

            public UnsupportedException(String s) {
                super(s);
            }

            public UnsupportedException(String s, Throwable cause) {
                super(s, cause);
            }
        }
    }
}

