/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.IterableObjectHelperImpl;

class ThreadBasedIterator
extends IterableObjectHelperImpl.Iterator {
    ThreadBasedIterator(IterableObjectHelperImpl iterableObjectHelper) {
        super(iterableObjectHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <I, IC, OC> OC iterate(IC items, Predicate<IC> predicateForParallelIteration, OC output, BiConsumer<I, Consumer<Consumer<OC>>> action, Integer priority) {
        if (items == IterableObjectHelperImpl.Iterator.NO_ITEMS) {
            return output;
        }
        java.lang.Thread currentThread = Thread.currentThread();
        int initialThreadPriority = currentThread.getPriority();
        if (priority == null) {
            priority = initialThreadPriority;
        } else if (initialThreadPriority != priority) {
            currentThread.setPriority(priority);
        }
        try {
            int taskCountThatCanBeCreated;
            if (predicateForParallelIteration == null) {
                predicateForParallelIteration = collectionOrArray -> this.iterableObjectHelper.defaultMinimumCollectionSizeForParallelIterationPredicate.test(collectionOrArray);
            }
            if ((taskCountThatCanBeCreated = this.iterableObjectHelper.getCountOfTasksThatCanBeCreated(items, predicateForParallelIteration)) > 1) {
                Consumer outputItemsHandler = this.buildOutputCollectionHandler(output);
                AtomicReference terminateIterationNotification = new AtomicReference();
                ConcurrentHashMap<Thread, Thread> threads = new ConcurrentHashMap<Thread, Thread>();
                if (items instanceof List) {
                    List itemList = (List)items;
                    int splittedIteratorSize = itemList.size() / taskCountThatCanBeCreated;
                    int currentIndex = 0;
                    int splittedIteratorIndex = 0;
                    while (currentIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                        ListIterator itemIterator = itemList.listIterator(splittedIteratorIndex);
                        int itemsCount = currentIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : itemList.size() - splittedIteratorSize * currentIndex;
                        ThrowingConsumer iterator = thread -> {
                            try {
                                for (int remainedItems = itemsCount; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                    action.accept(itemIterator.next(), outputItemsHandler);
                                }
                            }
                            catch (IterableObjectHelper.TerminateIteration exc) {
                                this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                            }
                            catch (Throwable exc) {
                                terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                throw exc;
                            }
                            finally {
                                this.removeThread((Map<Thread, Thread>)threads, (Thread)thread);
                            }
                        };
                        if (currentIndex < taskCountThatCanBeCreated - 1) {
                            this.createAndStartThread(threads, iterator, priority);
                        } else {
                            this.consume(iterator);
                        }
                        ++currentIndex;
                        splittedIteratorIndex += splittedIteratorSize;
                    }
                } else if (items instanceof Collection) {
                    Iterator itemIterator = ((Collection)items).iterator();
                    ThrowingConsumer iterator = thread -> {
                        Object item = null;
                        try {
                            while (terminateIterationNotification.get() == null) {
                                try {
                                    Iterator iterator = itemIterator;
                                    synchronized (iterator) {
                                        item = itemIterator.next();
                                    }
                                }
                                catch (NoSuchElementException exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    break;
                                }
                                action.accept(item, outputItemsHandler);
                            }
                        }
                        catch (IterableObjectHelper.TerminateIteration exc) {
                            this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                        }
                        catch (Throwable exc) {
                            terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                            throw exc;
                        }
                        finally {
                            this.removeThread((Map<Thread, Thread>)threads, (Thread)thread);
                        }
                    };
                    for (int taskIndex = 0; taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null; ++taskIndex) {
                        if (taskIndex < taskCountThatCanBeCreated - 1) {
                            this.createAndStartThread(threads, iterator, priority);
                            continue;
                        }
                        this.consume(iterator);
                    }
                } else {
                    int arrayLength = Array.getLength(items);
                    int splittedIteratorSize = arrayLength / taskCountThatCanBeCreated;
                    Class<?> componentType = items.getClass().getComponentType();
                    if (componentType.isPrimitive()) {
                        Function<Integer, ?> itemRetriever = StaticComponentContainer.Classes.buildArrayValueRetriever(items);
                        int taskIndex = 0;
                        int currentSplittedIteratorIndex = 0;
                        while (taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                            int itemsCount = taskIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : arrayLength - splittedIteratorSize * taskIndex;
                            int splittedIteratorIndex = currentSplittedIteratorIndex;
                            ThrowingConsumer iterator = thread -> {
                                try {
                                    int itemIndex = splittedIteratorIndex;
                                    for (int remainedItems = itemsCount; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                        action.accept(itemRetriever.apply(itemIndex++), outputItemsHandler);
                                    }
                                }
                                catch (IterableObjectHelper.TerminateIteration exc) {
                                    this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                                }
                                catch (Throwable exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    throw exc;
                                }
                                finally {
                                    this.removeThread((Map<Thread, Thread>)threads, (Thread)thread);
                                }
                            };
                            if (taskIndex < taskCountThatCanBeCreated - 1) {
                                this.createAndStartThread(threads, iterator, priority);
                            } else {
                                this.consume(iterator);
                            }
                            ++taskIndex;
                            currentSplittedIteratorIndex += splittedIteratorSize;
                        }
                    } else {
                        int taskIndex = 0;
                        int currentSplittedIteratorIndex = 0;
                        while (taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                            int itemsCount = taskIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : arrayLength - splittedIteratorSize * taskIndex;
                            int splittedIteratorIndex = currentSplittedIteratorIndex;
                            Object[] itemArray = (Object[])items;
                            ThrowingConsumer iterator = thread -> {
                                try {
                                    int itemIndex = splittedIteratorIndex;
                                    for (int remainedItems = itemsCount; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                        action.accept(itemArray[itemIndex++], outputItemsHandler);
                                    }
                                }
                                catch (IterableObjectHelper.TerminateIteration exc) {
                                    this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                                }
                                catch (Throwable exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    throw exc;
                                }
                                finally {
                                    this.removeThread((Map<Thread, Thread>)threads, (Thread)thread);
                                }
                            };
                            if (taskIndex < taskCountThatCanBeCreated - 1) {
                                this.createAndStartThread(threads, iterator, priority);
                            } else {
                                this.consume(iterator);
                            }
                            ++taskIndex;
                            currentSplittedIteratorIndex += splittedIteratorSize;
                        }
                    }
                }
                if (!threads.isEmpty()) {
                    ConcurrentHashMap<Thread, Thread> arrayLength = threads;
                    synchronized (arrayLength) {
                        if (!threads.isEmpty()) {
                            try {
                                threads.wait();
                            }
                            catch (InterruptedException exc) {
                                StaticComponentContainer.Driver.throwException(exc);
                            }
                        }
                    }
                }
                Object arrayLength = output;
                return arrayLength;
            }
            Consumer<Consumer> outputItemsHandler = output != null ? outputCollectionConsumer -> outputCollectionConsumer.accept(output) : null;
            try {
                if (items instanceof Collection) {
                    for (Object item : (Collection)items) {
                        action.accept(item, outputItemsHandler);
                    }
                } else if (!items.getClass().getComponentType().isPrimitive()) {
                    Object[] itemArray;
                    for (Object item : itemArray = (Object[])items) {
                        action.accept(item, outputItemsHandler);
                    }
                } else {
                    Function<Integer, ?> itemRetriever = StaticComponentContainer.Classes.buildArrayValueRetriever(items);
                    int arrayLength = Array.getLength(items);
                    for (int i = 0; i < arrayLength; ++i) {
                        action.accept(itemRetriever.apply(i), outputItemsHandler);
                    }
                }
            }
            catch (IterableObjectHelper.TerminateIteration terminateIteration) {
                // empty catch block
            }
        }
        finally {
            if (initialThreadPriority != priority) {
                currentThread.setPriority(initialThreadPriority);
            }
        }
        return output;
    }

    private Thread createAndStartThread(Map<Thread, Thread> threads, ThrowingConsumer<Thread, ? extends Throwable> iterator, int priority) {
        Thread thread = StaticComponentContainer.ThreadSupplier.getOrCreateThread().setExecutable(iterator);
        thread.setPriority(priority);
        threads.put(thread, thread);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThread(Map<Thread, Thread> threads, Thread thread) {
        if (thread != null) {
            threads.remove(thread);
            if (threads.isEmpty()) {
                Map<Thread, Thread> map = threads;
                synchronized (map) {
                    threads.notify();
                }
            }
        }
    }

    private void consume(ThrowingConsumer<Thread, ? extends Throwable> iterator) {
        try {
            iterator.accept(null);
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
        }
    }
}

