/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests;

import com.mojang.logging.LogUtils;
import com.trivialcraft.riddlerchests.ClientSetup;
import com.trivialcraft.riddlerchests.lootr.RiddleFileManager;
import com.trivialcraft.riddlerchests.lootr.RiddleNetworking;
import com.trivialcraft.riddlerchests.lootr.RiddlerConfig;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="riddler_chests")
public class RiddlerChests {
    public static final String MOD_ID = "riddler_chests";
    public static final Logger LOGGER = LogUtils.getLogger();

    public RiddlerChests(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(RiddleNetworking::register);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RiddlerConfig.SPEC);
        if (FMLEnvironment.dist.isClient()) {
            ClientSetup.init(modEventBus);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RiddleFileManager.loadRiddles();
        boolean lootrLoaded = ModList.get().isLoaded("lootr");
        if (lootrLoaded) {
            LOGGER.info("Riddler Chests initialized with Lootr integration!");
        } else {
            LOGGER.info("Riddler Chests initialized in standalone mode (no Lootr detected)");
        }
        LOGGER.info("Riddle chance: {}%", (Object)((Double)RiddlerConfig.RIDDLE_CHANCE.get() * 100.0));
        LOGGER.info("Loaded {} riddles", (Object)RiddleFileManager.getEnabledRiddles().size());
    }
}

