/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import com.trivialcraft.riddlerchests.RiddlerChests;
import com.trivialcraft.riddlerchests.lootr.PerPlayerInventoryManager;
import com.trivialcraft.riddlerchests.lootr.RiddleManager;
import com.trivialcraft.riddlerchests.lootr.RiddleNetworking;
import com.trivialcraft.riddlerchests.lootr.RiddlerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="riddler_chests")
public class LootrRiddleHandler {
    private static final boolean LOOTR_LOADED = ModList.get().isLoaded("lootr");
    private static final Map<UUID, BreakWarning> breakWarnings = new HashMap<UUID, BreakWarning>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Level level = event.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos = event.getPos());
        if (!LootrRiddleHandler.isValidContainer(blockEntity)) {
            return;
        }
        if (event.getEntity().isShiftKeyDown()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ChestIdentifier chestId = LootrRiddleHandler.getChestIdentifier(blockEntity, pos, level);
        if (chestId == null) {
            return;
        }
        if (LootrRiddleHandler.isPlayerPlaced(blockEntity)) {
            return;
        }
        if (RiddleManager.hasPlayerAccessedChest(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.getServer())) {
            event.setCanceled(true);
            if (LOOTR_LOADED) {
                try {
                    Object provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, pos, level);
                    if (provider != null) {
                        Class.forName("noobanidus.mods.lootr.common.api.LootrAPI").getMethod("handleProviderOpen", Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider"), ServerPlayer.class).invoke(null, provider, serverPlayer);
                    }
                }
                catch (Exception e) {
                    RiddlerChests.LOGGER.error("Failed to open Lootr chest", (Throwable)e);
                }
            } else {
                PerPlayerInventoryManager.openInventory(serverPlayer, chestId, (RandomizableContainerBlockEntity)blockEntity);
            }
            return;
        }
        if (!((Boolean)RiddlerConfig.ENABLE_RIDDLES.get()).booleanValue()) {
            RiddleManager.markChestAccessed(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.getServer());
            event.setCanceled(true);
            if (LOOTR_LOADED) {
                try {
                    Object provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, pos, level);
                    if (provider != null) {
                        Class.forName("noobanidus.mods.lootr.common.api.LootrAPI").getMethod("handleProviderOpen", Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider"), ServerPlayer.class).invoke(null, provider, serverPlayer);
                    }
                }
                catch (Exception e) {
                    RiddlerChests.LOGGER.error("Failed to open Lootr chest", (Throwable)e);
                }
            } else {
                PerPlayerInventoryManager.openInventory(serverPlayer, chestId, (RandomizableContainerBlockEntity)blockEntity);
            }
            return;
        }
        boolean needsRiddle = RiddleManager.doesPlayerNeedRiddle(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.getServer());
        if (!needsRiddle) {
            RiddleManager.markChestAccessed(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.getServer());
            event.setCanceled(true);
            if (LOOTR_LOADED) {
                try {
                    Object provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, pos, level);
                    if (provider != null) {
                        Class.forName("noobanidus.mods.lootr.common.api.LootrAPI").getMethod("handleProviderOpen", Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider"), ServerPlayer.class).invoke(null, provider, serverPlayer);
                    }
                }
                catch (Exception e) {
                    RiddlerChests.LOGGER.error("Failed to open Lootr chest", (Throwable)e);
                }
            } else {
                PerPlayerInventoryManager.openInventory(serverPlayer, chestId, (RandomizableContainerBlockEntity)blockEntity);
            }
            return;
        }
        event.setCanceled(true);
        String riddle = RiddleManager.getRiddleForChest(chestId.uuid(), serverPlayer.getServer());
        RiddleNetworking.sendRiddleToClient(serverPlayer, pos, riddle);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean isConfirmed;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = serverPlayer.level();
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!LootrRiddleHandler.isValidContainer(blockEntity)) {
            return;
        }
        ChestIdentifier chestId = LootrRiddleHandler.getChestIdentifier(blockEntity, pos, level);
        if (chestId == null) {
            return;
        }
        if (LootrRiddleHandler.isPlayerPlaced(blockEntity)) {
            return;
        }
        if (RiddleManager.hasPlayerAccessedChest(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.getServer())) {
            return;
        }
        if (!((Boolean)RiddlerConfig.ENABLE_BREAK_WARNING.get()).booleanValue()) {
            if (((Boolean)RiddlerConfig.DELETE_ITEMS_ON_BREAK.get()).booleanValue()) {
                LootrRiddleHandler.clearChestLoot(blockEntity);
            }
            return;
        }
        UUID playerUUID = serverPlayer.getUUID();
        BreakWarning warning = breakWarnings.get(playerUUID);
        boolean shiftRequired = (Boolean)RiddlerConfig.REQUIRE_SHIFT_TO_BREAK.get();
        boolean isShiftBreaking = serverPlayer.isShiftKeyDown();
        boolean bl = isConfirmed = warning != null && warning.position.equals((Object)pos) && !warning.isExpired() && (!shiftRequired || isShiftBreaking);
        if (isConfirmed) {
            if (((Boolean)RiddlerConfig.DELETE_ITEMS_ON_BREAK.get()).booleanValue()) {
                LootrRiddleHandler.clearChestLoot(blockEntity);
            }
            breakWarnings.remove(playerUUID);
            if (((Boolean)RiddlerConfig.DELETE_ITEMS_ON_BREAK.get()).booleanValue()) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Chest broken. All items inside have been deleted.").withStyle(RiddlerConfig.getWarningColorFormatting()));
            }
            return;
        }
        event.setCanceled(true);
        breakWarnings.put(playerUUID, new BreakWarning(pos, System.currentTimeMillis()));
        ChatFormatting color = RiddlerConfig.getWarningColorFormatting();
        if (((Boolean)RiddlerConfig.DELETE_ITEMS_ON_BREAK.get()).booleanValue()) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u26a0 WARNING: Breaking this chest will DELETE all items inside!").withStyle(new ChatFormatting[]{color, ChatFormatting.BOLD}));
        } else {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u26a0 WARNING: You haven't solved this riddle yet!").withStyle(new ChatFormatting[]{color, ChatFormatting.BOLD}));
        }
        serverPlayer.sendSystemMessage((Component)Component.literal((String)"This chest contains a riddle you haven't solved yet.").withStyle(ChatFormatting.YELLOW));
        if (shiftRequired) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"If you're sure you want to break it, hold SHIFT while mining.").withStyle(ChatFormatting.AQUA));
        } else {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"Mine again to confirm breaking.").withStyle(ChatFormatting.AQUA));
        }
        LootrRiddleHandler.cleanupExpiredWarnings();
    }

    private static void clearChestLoot(BlockEntity blockEntity) {
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
            container.setLootTable(null);
            container.clearContent();
        }
    }

    private static void cleanupExpiredWarnings() {
        breakWarnings.entrySet().removeIf(entry -> ((BreakWarning)entry.getValue()).isExpired());
    }

    private static boolean isValidContainer(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        if (LOOTR_LOADED) {
            try {
                Class<?> lootrInterface = Class.forName("noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity");
                if (lootrInterface.isInstance(blockEntity)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return blockEntity instanceof RandomizableContainerBlockEntity;
    }

    private static ChestIdentifier getChestIdentifier(BlockEntity blockEntity, BlockPos pos, Level level) {
        if (LOOTR_LOADED) {
            try {
                Object provider;
                Class<?> lootrInterface = Class.forName("noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity");
                if (lootrInterface.isInstance(blockEntity) && (provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, pos, level)) != null) {
                    UUID uuid = (UUID)provider.getClass().getMethod("getInfoUUID", new Class[0]).invoke(provider, new Object[0]);
                    return new ChestIdentifier(uuid, pos);
                }
            }
            catch (Exception e) {
                RiddlerChests.LOGGER.error("Failed to get Lootr chest UUID", (Throwable)e);
            }
        }
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            UUID uuid = PerPlayerInventoryManager.getOrCreateChestUUID(pos, level);
            return new ChestIdentifier(uuid, pos);
        }
        return null;
    }

    private static boolean isPlayerPlaced(BlockEntity blockEntity) {
        if (LOOTR_LOADED) {
            try {
                Class<?> lootrInterface = Class.forName("noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity");
                if (lootrInterface.isInstance(blockEntity)) {
                    Object lootTable = lootrInterface.getMethod("getInfoLootTable", new Class[0]).invoke((Object)blockEntity, new Object[0]);
                    return lootTable == null;
                }
            }
            catch (Exception e) {
                RiddlerChests.LOGGER.error("Failed to check Lootr loot table", (Throwable)e);
            }
        }
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
            return container.getLootTable() == null;
        }
        return false;
    }

    public record ChestIdentifier(UUID uuid, BlockPos pos) {
    }

    private record BreakWarning(BlockPos position, long timestamp) {
        boolean isExpired() {
            long timeout = RiddlerConfig.getWarningTimeoutMillis();
            return System.currentTimeMillis() - this.timestamp > timeout;
        }
    }
}

