/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import com.trivialcraft.riddlerchests.lootr.LootrRiddleHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerPlayerInventoryManager
extends SavedData {
    private static final String DATA_NAME = "riddlechest_inventories";
    private final Map<UUID, ChestData> chestInventories = new HashMap<UUID, ChestData>();
    private final Map<BlockPos, UUID> positionToUUID = new HashMap<BlockPos, UUID>();

    public static UUID getOrCreateChestUUID(BlockPos pos, Level level) {
        PerPlayerInventoryManager manager = PerPlayerInventoryManager.get(level);
        return manager.positionToUUID.computeIfAbsent(pos, p -> {
            UUID uuid = UUID.randomUUID();
            manager.setDirty();
            return uuid;
        });
    }

    public static void openInventory(ServerPlayer player, LootrRiddleHandler.ChestIdentifier chestId, final RandomizableContainerBlockEntity originalContainer) {
        final PerPlayerInventoryManager manager = PerPlayerInventoryManager.get((Level)player.serverLevel());
        ChestData chestData = manager.chestInventories.computeIfAbsent(chestId.uuid(), uuid -> {
            ChestData data = new ChestData((UUID)uuid);
            manager.setDirty();
            return data;
        });
        final NonNullList<ItemStack> playerInventory = chestData.getOrCreatePlayerInventory(player.getUUID(), originalContainer, (HolderLookup.Provider)player.level().registryAccess());
        manager.setDirty();
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return originalContainer.getDisplayName();
            }

            @NotNull
            public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInv, @NotNull Player player) {
                return ChestMenu.threeRows((int)containerId, (Inventory)playerInv, (Container)new PerPlayerContainer((NonNullList<ItemStack>)playerInventory, manager));
            }
        };
        player.openMenu(menuProvider);
    }

    private static PerPlayerInventoryManager get(Level level) {
        if (level.isClientSide()) {
            throw new IllegalStateException("Cannot access PerPlayerInventoryManager on client side");
        }
        DimensionDataStorage storage = level.getServer().overworld().getDataStorage();
        return (PerPlayerInventoryManager)storage.computeIfAbsent(new SavedData.Factory(PerPlayerInventoryManager::new, PerPlayerInventoryManager::load, null), DATA_NAME);
    }

    public static PerPlayerInventoryManager load(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag list;
        PerPlayerInventoryManager manager = new PerPlayerInventoryManager();
        if (nbt.contains("PositionMappings", 9)) {
            list = nbt.getList("PositionMappings", 10);
            for (Tag tag : list) {
                CompoundTag mapping = (CompoundTag)tag;
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)mapping, (String)"Pos").orElse(null);
                if (pos == null || !mapping.hasUUID("UUID")) continue;
                UUID uuid = mapping.getUUID("UUID");
                manager.positionToUUID.put(pos, uuid);
            }
        }
        if (nbt.contains("ChestData", 9)) {
            list = nbt.getList("ChestData", 10);
            for (Tag tag : list) {
                CompoundTag chestTag = (CompoundTag)tag;
                ChestData chestData = ChestData.load(chestTag, provider);
                if (chestData == null) continue;
                manager.chestInventories.put(chestData.chestUUID, chestData);
            }
        }
        return manager;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag positionList = new ListTag();
        for (Map.Entry<BlockPos, UUID> entry : this.positionToUUID.entrySet()) {
            CompoundTag mapping = new CompoundTag();
            mapping.put("Pos", NbtUtils.writeBlockPos((BlockPos)entry.getKey()));
            mapping.putUUID("UUID", entry.getValue());
            positionList.add((Object)mapping);
        }
        nbt.put("PositionMappings", (Tag)positionList);
        ListTag chestList = new ListTag();
        for (ChestData chestData : this.chestInventories.values()) {
            chestList.add((Object)chestData.save(provider));
        }
        nbt.put("ChestData", (Tag)chestList);
        return nbt;
    }

    private static class ChestData {
        private final UUID chestUUID;
        private final Map<UUID, NonNullList<ItemStack>> playerInventories = new HashMap<UUID, NonNullList<ItemStack>>();
        private boolean baseInventoryGenerated = false;
        private NonNullList<ItemStack> baseInventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

        public ChestData(UUID chestUUID) {
            this.chestUUID = chestUUID;
        }

        public NonNullList<ItemStack> getOrCreatePlayerInventory(UUID playerUUID, RandomizableContainerBlockEntity originalContainer, HolderLookup.Provider registryAccess) {
            return this.playerInventories.computeIfAbsent(playerUUID, uuid -> {
                NonNullList inventory = NonNullList.withSize((int)originalContainer.getContainerSize(), (Object)ItemStack.EMPTY);
                ResourceKey lootTableKey = originalContainer.getLootTable();
                if (lootTableKey != null && originalContainer.getLevel() != null) {
                    ServerLevel serverLevel = (ServerLevel)originalContainer.getLevel();
                    LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableKey);
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)originalContainer.getBlockPos()));
                    LootParams params = builder.create(LootContextParamSets.CHEST);
                    SimpleContainer tempContainer = new SimpleContainer(originalContainer.getContainerSize());
                    long seed = originalContainer.getLootTableSeed();
                    if (seed == 0L) {
                        seed = serverLevel.random.nextLong();
                    }
                    lootTable.fill((Container)tempContainer, params, seed ^= uuid.getLeastSignificantBits());
                    for (int i = 0; i < tempContainer.getContainerSize() && i < inventory.size(); ++i) {
                        inventory.set(i, (Object)tempContainer.getItem(i).copy());
                    }
                }
                return inventory;
            });
        }

        private void generateBaseInventory(RandomizableContainerBlockEntity container) {
            if (this.baseInventoryGenerated) {
                return;
            }
            container.unpackLootTable(null);
            this.baseInventory = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < container.getContainerSize() && i < this.baseInventory.size(); ++i) {
                this.baseInventory.set(i, (Object)container.getItem(i).copy());
            }
            this.baseInventoryGenerated = true;
        }

        public CompoundTag save(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putUUID("ChestUUID", this.chestUUID);
            tag.putBoolean("BaseGenerated", this.baseInventoryGenerated);
            if (this.baseInventoryGenerated) {
                ListTag baseList = new ListTag();
                for (int i = 0; i < this.baseInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.baseInventory.get(i);
                    if (stack.isEmpty()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.putByte("Slot", (byte)i);
                    itemTag.put("item", stack.save(provider));
                    baseList.add((Object)itemTag);
                }
                tag.put("BaseInventory", (Tag)baseList);
            }
            ListTag playerList = new ListTag();
            for (Map.Entry<UUID, NonNullList<ItemStack>> entry : this.playerInventories.entrySet()) {
                CompoundTag playerTag = new CompoundTag();
                playerTag.putUUID("PlayerUUID", entry.getKey());
                ListTag itemsList = new ListTag();
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    ItemStack stack = (ItemStack)entry.getValue().get(i);
                    if (stack.isEmpty()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.putByte("Slot", (byte)i);
                    itemTag.put("item", stack.save(provider));
                    itemsList.add((Object)itemTag);
                }
                playerTag.put("Items", (Tag)itemsList);
                playerList.add((Object)playerTag);
            }
            tag.put("PlayerInventories", (Tag)playerList);
            return tag;
        }

        @Nullable
        public static ChestData load(CompoundTag tag, HolderLookup.Provider provider) {
            if (!tag.hasUUID("ChestUUID")) {
                return null;
            }
            UUID chestUUID = tag.getUUID("ChestUUID");
            ChestData data = new ChestData(chestUUID);
            data.baseInventoryGenerated = tag.getBoolean("BaseGenerated");
            if (tag.contains("BaseInventory", 9)) {
                ListTag baseList = tag.getList("BaseInventory", 10);
                data.baseInventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
                for (Tag itemTag : baseList) {
                    CompoundTag itemCompound = (CompoundTag)itemTag;
                    int slot = itemCompound.getByte("Slot") & 0xFF;
                    if (slot >= data.baseInventory.size() || !itemCompound.contains("item")) continue;
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound.getCompound("item"));
                    data.baseInventory.set(slot, (Object)stack);
                }
            }
            if (tag.contains("PlayerInventories", 9)) {
                ListTag playerList = tag.getList("PlayerInventories", 10);
                for (Tag playerTag : playerList) {
                    CompoundTag playerCompound = (CompoundTag)playerTag;
                    if (!playerCompound.hasUUID("PlayerUUID")) continue;
                    UUID playerUUID = playerCompound.getUUID("PlayerUUID");
                    NonNullList inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
                    if (playerCompound.contains("Items", 9)) {
                        ListTag itemsList = playerCompound.getList("Items", 10);
                        for (Tag itemTag : itemsList) {
                            CompoundTag itemCompound = (CompoundTag)itemTag;
                            int slot = itemCompound.getByte("Slot") & 0xFF;
                            if (slot >= inventory.size() || !itemCompound.contains("item")) continue;
                            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound.getCompound("item"));
                            inventory.set(slot, (Object)stack);
                        }
                    }
                    data.playerInventories.put(playerUUID, (NonNullList<ItemStack>)inventory);
                }
            }
            return data;
        }
    }

    private static class PerPlayerContainer
    implements Container {
        private final NonNullList<ItemStack> items;
        private final PerPlayerInventoryManager manager;

        public PerPlayerContainer(NonNullList<ItemStack> items, PerPlayerInventoryManager manager) {
            this.items = items;
            this.manager = manager;
        }

        public int getContainerSize() {
            return this.items.size();
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.items) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack getItem(int slot) {
            return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack removeItem(int slot, int amount) {
            ItemStack result = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
            if (!result.isEmpty()) {
                this.setChanged();
            }
            return result;
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int slot) {
            return ContainerHelper.takeItem(this.items, (int)slot);
        }

        public void setItem(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot < this.items.size()) {
                this.items.set(slot, (Object)stack);
                this.setChanged();
            }
        }

        public void setChanged() {
            this.manager.setDirty();
        }

        public boolean stillValid(@NotNull Player player) {
            return true;
        }

        public void clearContent() {
            this.items.clear();
            this.setChanged();
        }
    }
}

