/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import com.trivialcraft.riddlerchests.RiddlerChests;
import com.trivialcraft.riddlerchests.lootr.LootrRiddleHandler;
import com.trivialcraft.riddlerchests.lootr.PerPlayerInventoryManager;
import com.trivialcraft.riddlerchests.lootr.RiddleManager;
import com.trivialcraft.riddlerchests.lootr.client.ClientRiddleHandler;
import com.trivialcraft.riddlerchests.lootr.client.RiddleScreen;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class RiddleNetworking {
    private static final boolean LOOTR_LOADED = ModList.get().isLoaded("lootr");

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("riddler_chests");
        registrar.playToClient(RiddlePayload.TYPE, RiddlePayload.STREAM_CODEC, RiddleNetworking::handleRiddlePayload);
        registrar.playToServer(AnswerPayload.TYPE, AnswerPayload.STREAM_CODEC, RiddleNetworking::handleAnswerPayload);
        registrar.playToClient(ResultPayload.TYPE, ResultPayload.STREAM_CODEC, RiddleNetworking::handleResultPayload);
    }

    public static void sendRiddleToClient(ServerPlayer player, BlockPos pos, String riddle) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RiddlePayload(pos, riddle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendResultToClient(ServerPlayer player, boolean correct) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ResultPayload(correct), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleRiddlePayload(RiddlePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().level().isClientSide()) {
                ClientRiddleHandler.openRiddleScreen(payload.riddle, payload.pos);
            }
        });
    }

    private static void handleAnswerPayload(AnswerPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                BlockPos pos;
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                Level level = serverPlayer.level();
                BlockEntity blockEntity = level.getBlockEntity(pos = payload.pos);
                LootrRiddleHandler.ChestIdentifier chestId = RiddleNetworking.getChestIdentifier(blockEntity, pos, level);
                if (chestId == null) {
                    return;
                }
                boolean correct = RiddleManager.validateAnswer(chestId.uuid(), payload.answer, serverPlayer.server);
                if (correct) {
                    RiddleManager.markChestAccessed(chestId.uuid(), serverPlayer.getUUID(), serverPlayer.server);
                    RiddleNetworking.sendResultToClient(serverPlayer, true);
                    if (LOOTR_LOADED) {
                        RiddleNetworking.openLootrChest(chestId, serverPlayer, level);
                    } else if (blockEntity instanceof RandomizableContainerBlockEntity) {
                        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                        PerPlayerInventoryManager.openInventory(serverPlayer, chestId, container);
                    }
                } else {
                    RiddleNetworking.sendResultToClient(serverPlayer, false);
                }
            }
        });
    }

    private static void openLootrChest(LootrRiddleHandler.ChestIdentifier chestId, ServerPlayer player, Level level) {
        try {
            Object provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, chestId.pos(), level);
            if (provider != null) {
                Class.forName("noobanidus.mods.lootr.common.api.LootrAPI").getMethod("handleProviderOpen", Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider"), ServerPlayer.class).invoke(null, provider, player);
            }
        }
        catch (Exception e) {
            RiddlerChests.LOGGER.error("Failed to open Lootr chest", (Throwable)e);
        }
    }

    private static LootrRiddleHandler.ChestIdentifier getChestIdentifier(BlockEntity blockEntity, BlockPos pos, Level level) {
        if (LOOTR_LOADED) {
            try {
                Object provider;
                Class<?> lootrInterface = Class.forName("noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity");
                if (lootrInterface.isInstance(blockEntity) && (provider = Class.forName("noobanidus.mods.lootr.common.api.data.ILootrInfoProvider").getMethod("of", BlockPos.class, Level.class).invoke(null, pos, level)) != null) {
                    UUID uuid = (UUID)provider.getClass().getMethod("getInfoUUID", new Class[0]).invoke(provider, new Object[0]);
                    return new LootrRiddleHandler.ChestIdentifier(uuid, pos);
                }
            }
            catch (Exception e) {
                RiddlerChests.LOGGER.error("Failed to get Lootr chest UUID", (Throwable)e);
            }
        }
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            UUID uuid = PerPlayerInventoryManager.getOrCreateChestUUID(pos, level);
            return new LootrRiddleHandler.ChestIdentifier(uuid, pos);
        }
        return null;
    }

    private static void handleResultPayload(ResultPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            Screen patt0$temp = minecraft.screen;
            if (patt0$temp instanceof RiddleScreen) {
                RiddleScreen riddleScreen = (RiddleScreen)patt0$temp;
                if (payload.correct) {
                    riddleScreen.setCorrectAnswer();
                } else {
                    riddleScreen.setIncorrectAnswer();
                }
            }
        });
    }

    public static void sendAnswerToServer(BlockPos pos, String answer) {
        PacketDistributor.sendToServer((CustomPacketPayload)new AnswerPayload(pos, answer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record RiddlePayload(BlockPos pos, String riddle) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RiddlePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"riddler_chests", (String)"riddle"));
        public static final StreamCodec<ByteBuf, RiddlePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RiddlePayload::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, RiddlePayload::riddle, RiddlePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record AnswerPayload(BlockPos pos, String answer) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AnswerPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"riddler_chests", (String)"answer"));
        public static final StreamCodec<ByteBuf, AnswerPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, AnswerPayload::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, AnswerPayload::answer, AnswerPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ResultPayload(boolean correct) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ResultPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"riddler_chests", (String)"result"));
        public static final StreamCodec<ByteBuf, ResultPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ResultPayload::correct, ResultPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

