/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import net.minecraft.ChatFormatting;
import net.neoforged.neoforge.common.ModConfigSpec;

public class RiddlerConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.DoubleValue RIDDLE_CHANCE;
    public static final ModConfigSpec.BooleanValue ENABLE_RIDDLES;
    public static final ModConfigSpec.BooleanValue DELETE_ITEMS_ON_BREAK;
    public static final ModConfigSpec.BooleanValue ENABLE_BREAK_WARNING;
    public static final ModConfigSpec.BooleanValue REQUIRE_SHIFT_TO_BREAK;
    public static final ModConfigSpec.IntValue WARNING_TIMEOUT_SECONDS;
    public static final ModConfigSpec.ConfigValue<String> WARNING_COLOR;
    public static final ModConfigSpec.ConfigValue<String> RIDDLE_GUI_TITLE;
    public static final ModConfigSpec.BooleanValue SHOW_RIDDLE_NUMBER;

    public static boolean shouldShowRiddle() {
        if (!((Boolean)ENABLE_RIDDLES.get()).booleanValue()) {
            return false;
        }
        double chance = (Double)RIDDLE_CHANCE.get();
        if (chance >= 1.0) {
            return true;
        }
        if (chance <= 0.0) {
            return false;
        }
        return Math.random() < chance;
    }

    public static long getWarningTimeoutMillis() {
        return (long)((Integer)WARNING_TIMEOUT_SECONDS.get()).intValue() * 1000L;
    }

    public static ChatFormatting getWarningColorFormatting() {
        try {
            return ChatFormatting.valueOf((String)((String)WARNING_COLOR.get()));
        }
        catch (IllegalArgumentException e) {
            return ChatFormatting.RED;
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Riddle Behavior Settings").push("riddles");
        RIDDLE_CHANCE = builder.comment(new String[]{"Probability that a riddle will appear when opening a chest", "1.0 = 100% (every chest has a riddle)", "0.5 = 50% (half of chests have riddles)", "0.0 = 0% (riddles disabled)"}).defineInRange("riddleChance", 1.0, 0.0, 1.0);
        ENABLE_RIDDLES = builder.comment(new String[]{"Master switch for the entire riddle system", "Set to false to disable all riddles"}).define("enableRiddles", true);
        builder.pop();
        builder.comment("Chest Break Protection Settings").push("breakProtection");
        DELETE_ITEMS_ON_BREAK = builder.comment(new String[]{"Whether items are deleted when breaking unsolved riddle chests", "true = Items deleted (punishing)", "false = Items drop normally"}).define("deleteItemsOnBreak", true);
        ENABLE_BREAK_WARNING = builder.comment(new String[]{"Whether to show a warning when trying to break a chest", "true = Show warning and require confirmation", "false = Allow immediate breaking (dangerous if deleteItemsOnBreak is true!)"}).define("enableBreakWarning", true);
        REQUIRE_SHIFT_TO_BREAK = builder.comment(new String[]{"Whether player must hold SHIFT to confirm breaking after warning", "true = Requires SHIFT + mine (safer)", "false = Just mine twice (no SHIFT needed)"}).define("requireShiftToBreak", true);
        WARNING_TIMEOUT_SECONDS = builder.comment(new String[]{"How long (in seconds) the break warning lasts", "After this time, player must trigger the warning again"}).defineInRange("warningTimeoutSeconds", 10, 1, 300);
        builder.pop();
        builder.comment("Display and UI Settings").push("display");
        WARNING_COLOR = builder.comment(new String[]{"Color of warning messages", "Valid colors: BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED,", "DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED,", "LIGHT_PURPLE, YELLOW, WHITE"}).define("warningColor", (Object)"RED");
        RIDDLE_GUI_TITLE = builder.comment("Title shown at the top of the riddle GUI").define("riddleGuiTitle", (Object)"Solve the Riddle");
        SHOW_RIDDLE_NUMBER = builder.comment("Whether to show riddle number in GUI (future feature)").define("showRiddleNumber", true);
        builder.pop();
        SPEC = builder.build();
    }
}

