/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr.client;

import com.trivialcraft.riddlerchests.RiddlerChests;
import com.trivialcraft.riddlerchests.lootr.RiddleNetworking;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RiddleScreen
extends Screen {
    private final String riddle;
    private final BlockPos chestPos;
    private EditBox answerBox;
    private Component statusMessage = Component.empty();
    private int statusColor = 0xFFFFFF;
    private int statusTimer = 0;

    public RiddleScreen(String riddle, BlockPos chestPos) {
        super((Component)Component.literal((String)"Riddle Chest"));
        this.riddle = riddle;
        this.chestPos = chestPos;
    }

    protected void init() {
        super.init();
        int boxWidth = 200;
        int boxHeight = 20;
        int boxX = (this.width - boxWidth) / 2;
        int boxY = this.height / 2 + 30;
        this.answerBox = new EditBox(this.font, boxX, boxY, boxWidth, boxHeight, (Component)Component.literal((String)"Answer"));
        this.answerBox.setMaxLength(50);
        this.answerBox.setHint((Component)Component.literal((String)"Type your answer here..."));
        this.addRenderableWidget((GuiEventListener)this.answerBox);
        this.setInitialFocus((GuiEventListener)this.answerBox);
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonX = (this.width - buttonWidth) / 2;
        int buttonY = boxY + 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Submit"), button -> this.submitAnswer()).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build());
    }

    private void submitAnswer() {
        String answer = this.answerBox.getValue();
        if (answer.isEmpty()) {
            this.statusMessage = Component.literal((String)"Please enter an answer!");
            this.statusColor = 0xFF5555;
            this.statusTimer = 60;
            return;
        }
        RiddleNetworking.sendAnswerToServer(this.chestPos, answer);
    }

    public void setCorrectAnswer() {
        this.statusMessage = Component.literal((String)"Correct! Opening chest...");
        this.statusColor = 0x55FF55;
        this.statusTimer = 40;
        this.minecraft.execute(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                RiddlerChests.LOGGER.error("Interrupted while waiting to close riddle screen", (Throwable)e);
            }
            this.onClose();
        });
    }

    public void setIncorrectAnswer() {
        this.statusMessage = Component.literal((String)"Incorrect! Try again.");
        this.statusColor = 0xFF5555;
        this.statusTimer = 60;
        this.answerBox.setValue("");
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        MutableComponent title = Component.literal((String)"Solve the Riddle to Open the Chest");
        graphics.drawCenteredString(this.font, (Component)title, this.width / 2, 20, 0xFFFFFF);
        int riddleY = 50;
        int maxWidth = this.width - 40;
        int riddleX = 20;
        String[] words = this.riddle.split(" ");
        StringBuilder currentLine = new StringBuilder();
        int lineHeight = 10;
        for (String word : words) {
            Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            int testWidth = this.font.width((String)testLine);
            if (testWidth > maxWidth && currentLine.length() > 0) {
                graphics.drawString(this.font, currentLine.toString(), riddleX, riddleY, 0xFFFFAA);
                riddleY += lineHeight;
                currentLine = new StringBuilder(word);
                continue;
            }
            currentLine = new StringBuilder((String)testLine);
        }
        if (currentLine.length() > 0) {
            graphics.drawString(this.font, currentLine.toString(), riddleX, riddleY, 0xFFFFAA);
        }
        if (this.statusTimer > 0) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height / 2 + 60, this.statusColor);
            --this.statusTimer;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.submitAnswer();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

