/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.ring_of_flight.mixin;

import net.biorfn.ring_of_flight.Ring_Of_Flight;
import net.biorfn.ring_of_flight.items.FlightRing;
import net.biorfn.ring_of_flight.util.FlightManager;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class PlayerEntityMixin {
    @Unique
    private static final String TAG_FLIGHT_ENABLED = "FlightEnabled";
    @Unique
    private boolean shouldFlyOnJoin = false;
    @Unique
    private class_1934 previousGameModeFlight = null;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player.method_7337() || player.method_7325()) {
            return;
        }
        boolean hasFlightRing = this.checkForFlightRing(player);
        if (!Ring_Of_Flight.isTrinketsLoaded) {
            if (hasFlightRing) {
                FlightManager.startFlying((class_1657)player);
                if (this.shouldFlyOnJoin && !player.method_31549().field_7479) {
                    FlightManager.restartFlying((class_1657)player);
                    this.shouldFlyOnJoin = false;
                }
            } else {
                FlightManager.stopFlying((class_1657)player);
            }
        }
    }

    @Inject(method={"changeGameMode"}, at={@At(value="HEAD")})
    private void beforeGameModeChange(class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        this.previousGameModeFlight = player.field_13974.method_14257();
    }

    @Inject(method={"changeGameMode"}, at={@At(value="RETURN")})
    private void onGameModeChange(class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        if (!(this.previousGameModeFlight != class_1934.field_9220 && this.previousGameModeFlight != class_1934.field_9219 && this.previousGameModeFlight != class_1934.field_9215 && this.previousGameModeFlight != class_1934.field_9216 || gameMode != class_1934.field_9215 && gameMode != class_1934.field_9216)) {
            boolean hasFlightRing = this.checkForFlightRing(player);
            if (!Ring_Of_Flight.isTrinketsLoaded) {
                if (hasFlightRing) {
                    FlightManager.restartFlying((class_1657)player);
                } else {
                    FlightManager.stopFlying((class_1657)player);
                }
            }
        }
    }

    @Unique
    private boolean checkForFlightRing(class_3222 player) {
        if (Ring_Of_Flight.isTrinketsLoaded) {
            return false;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (!(player.method_31548().method_5438(i).method_7909() instanceof FlightRing)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    private void saveFlightStateToNbt(class_2487 nbt, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        boolean isCurrentlyFlying = player.method_31549().field_7478 && player.method_31549().field_7479;
        nbt.method_10556(TAG_FLIGHT_ENABLED, isCurrentlyFlying);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    private void loadFlightStateFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.shouldFlyOnJoin = nbt.method_10577(TAG_FLIGHT_ENABLED);
    }
}

