/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.gen_template;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.gen_template.TextureKey;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackMaterial;
import net.minecraft.resources.ResourceLocation;

public interface TrackGenTemplate {
    public static final TrackGenTemplate DEFAULT = new Default();

    public ResourceLocation getTexture(TrackMaterial var1, TextureKey var2);

    public ResourceLocation getParentModel(TrackMaterial var1, String var2);

    public static class Default
    implements TrackGenTemplate {
        protected Default() {
        }

        @Override
        public ResourceLocation getTexture(TrackMaterial material, TextureKey key) {
            if (key == TextureKey.PARTICLE) {
                return material.particle;
            }
            if (material == CRTrackMaterials.NARROW_GAUGE_ANDESITE || material == CRTrackMaterials.WIDE_GAUGE_ANDESITE) {
                return Create.asResource((String)("block/" + key.getPath()));
            }
            String resName = material.trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? material.resourceName().replaceFirst("_narrow", "") : (material.trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE ? material.resourceName().replaceFirst("_wide", "") : material.resourceName());
            String texturePrefix = "block/track/" + resName + "/";
            return material.id.m_247449_(texturePrefix + key.getPrefix() + resName);
        }

        @Override
        public ResourceLocation getParentModel(TrackMaterial material, String model) {
            ResourceLocation prefix = material.trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? Railways.asResource("block/narrow_gauge_base/") : (material.trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE ? Railways.asResource("block/wide_gauge_base/") : Create.asResource((String)"block/track/"));
            return prefix.m_266382_(model);
        }
    }
}

