/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.bogey_menu.handler;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.api.bogeymenu.v0.entry.BogeyEntry;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.gui.widget.Indicator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Pair;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BogeyMenuHandlerClient {
    private static final Map<BogeyStyle, List<Pair<BogeyStyle, BogeySizes.BogeySize>>> CACHED_RENDER_CYCLES = new HashMap<BogeyStyle, List<Pair<BogeyStyle, BogeySizes.BogeySize>>>();
    private static final Map<BogeyEntry, Indicator.State[]> CACHED_COMPATS = new HashMap<BogeyEntry, Indicator.State[]>();
    @Nullable
    private static List<BogeyStyle> favorites = null;

    public static void addFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (favorites.contains(style)) {
            return;
        }
        favorites.add(style);
        BogeyMenuHandlerClient.saveFavorites();
    }

    public static void removeFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (!favorites.contains(style)) {
            return;
        }
        favorites.remove(style);
        BogeyMenuHandlerClient.saveFavorites();
    }

    public static void toggleFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (favorites.contains(style)) {
            BogeyMenuHandlerClient.removeFavorite(style);
        } else {
            BogeyMenuHandlerClient.addFavorite(style);
        }
    }

    public static boolean isFavorited(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        return favorites.contains(style);
    }

    @NotNull
    public static List<BogeyStyle> getFavorites() {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        return favorites;
    }

    private static void optimizeFavorites() {
        ArrayList<BogeyStyle> newFavorites = new ArrayList<BogeyStyle>();
        for (BogeyStyle style : BogeyMenuHandlerClient.getFavorites()) {
            if (newFavorites.contains(style)) continue;
            newFavorites.add(style);
        }
        favorites = newFavorites;
        BogeyMenuHandlerClient.saveFavorites();
    }

    private static void loadFavorites() {
        favorites = new ArrayList<BogeyStyle>();
        try {
            class_310 mc = class_310.method_1551();
            File file = new File(mc.field_1697, "snr_favorite_styles.nbt");
            class_2487 tag = class_2507.method_10633((File)file);
            if (tag == null) {
                return;
            }
            if (tag.method_10573("Favorites", 9)) {
                class_2499 favoritesList = tag.method_10554("Favorites", 8);
                if (favorites == null) {
                    favorites = new ArrayList<BogeyStyle>();
                }
                favorites.clear();
                for (class_2520 favoriteTag : favoritesList) {
                    class_2519 stringTag;
                    class_2960 loc;
                    if (!(favoriteTag instanceof class_2519) || (loc = class_2960.method_12829((String)(stringTag = (class_2519)favoriteTag).method_10714())) == null || !AllBogeyStyles.BOGEY_STYLES.containsKey(loc)) continue;
                    favorites.add((BogeyStyle)AllBogeyStyles.BOGEY_STYLES.get(loc));
                }
            }
            BogeyMenuHandlerClient.optimizeFavorites();
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to load favorite styles", (Throwable)e);
        }
    }

    private static void saveFavorites() {
        if (favorites == null) {
            return;
        }
        try {
            class_2487 tag = new class_2487();
            class_2499 listTag = new class_2499();
            for (BogeyStyle style : favorites) {
                listTag.add((Object)class_2519.method_23256((String)style.displayName.toString()));
            }
            tag.method_10566("Favorites", (class_2520)listTag);
            class_2507.method_10630((class_2487)tag, (File)new File(class_310.method_1551().field_1697, "snr_favorite_styles.nbt"));
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to save favorite styles", (Throwable)e);
        }
    }

    @Nullable
    public static BogeySizes.BogeySize getSize(BogeyStyle style) {
        Iterator iterator = style.validSizes().iterator();
        if (iterator.hasNext()) {
            BogeySizes.BogeySize size = (BogeySizes.BogeySize)iterator.next();
            return size;
        }
        return null;
    }

    public static List<Pair<BogeyStyle, BogeySizes.BogeySize>> getRenderCycle(BogeyStyle style) {
        return CACHED_RENDER_CYCLES.computeIfAbsent(style, s -> {
            ArrayList<Pair> cycle = new ArrayList<Pair>();
            for (BogeySizes.BogeySize size : style.validSizes()) {
                cycle.add(Pair.of((Object)style, (Object)size));
            }
            for (BogeyStyle subStyle : CRBogeyStyles.getSubStyles(style)) {
                for (BogeySizes.BogeySize size : subStyle.validSizes()) {
                    cycle.add(Pair.of((Object)subStyle, (Object)size));
                }
            }
            return cycle;
        });
    }

    public static Indicator.State[] getTrackCompat(BogeyEntry bogeyEntry) {
        return CACHED_COMPATS.computeIfAbsent(bogeyEntry, k -> new Indicator.State[]{BogeyMenuHandlerClient.styleFits(bogeyEntry, CRTrackMaterials.CRTrackType.NARROW_GAUGE), BogeyMenuHandlerClient.styleFits(bogeyEntry, TrackMaterial.TrackType.STANDARD), BogeyMenuHandlerClient.styleFits(bogeyEntry, CRTrackMaterials.CRTrackType.WIDE_GAUGE)});
    }

    private static Indicator.State styleFits(BogeyEntry bogeyEntry, TrackMaterial.TrackType trackType) {
        if (CRBogeyStyles.styleFitsTrack(bogeyEntry.bogeyStyle(), trackType)) {
            return Indicator.State.GREEN;
        }
        for (BogeyStyle subStyle : CRBogeyStyles.getSubStyles(bogeyEntry.bogeyStyle())) {
            if (!CRBogeyStyles.styleFitsTrack(subStyle, trackType)) continue;
            return Indicator.State.GREEN;
        }
        return Indicator.State.RED;
    }
}

