/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplayHolder;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.RenderedElement;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.RenderedElementProvider;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@ApiStatus.Internal
public class UnifiedBogeyRenderer
implements BogeyRenderer,
BogeyDisplayHolder {
    private final Couple<Renderer> renderers = Couple.createWithContext(inContraption -> Renderer.create(factory, inContraption));
    @Nullable
    private final BogeyRenderer customRenderer;

    public UnifiedBogeyRenderer(BogeyDisplay.Factory factory) {
        this.customRenderer = factory.createCustomRenderer();
    }

    @Override
    public void runWithDisplay(Consumer<BogeyDisplay> consumer) {
        consumer.accept(((Renderer)this.renderers.getFirst()).display);
        consumer.accept(((Renderer)this.renderers.getSecond()).display);
        BogeyRenderer bogeyRenderer = this.customRenderer;
        if (bogeyRenderer instanceof BogeyDisplayHolder) {
            BogeyDisplayHolder customDisplayHolder = (BogeyDisplayHolder)bogeyRenderer;
            customDisplayHolder.runWithDisplay(consumer);
        }
    }

    public void render(class_2487 bogeyData, float wheelAngle, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean inContraption) {
        Matrix4f mat;
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23579());
        class_2680 air = class_2246.field_10124.method_9564();
        Renderer renderer = (Renderer)this.renderers.get(inContraption);
        Matrix4f pose = poseStack.method_23760().method_23761();
        for (RenderedElement element : renderer.allElements) {
            element.setTransform(pose);
        }
        renderer.display.update(bogeyData, wheelAngle);
        class_4587 ms = new class_4587();
        for (RenderedElement.Single single : renderer.singleElements) {
            mat = single.element().pose;
            ms.method_23760().method_23761().set((Matrix4fc)mat);
            ms.method_23760().method_23762().set((Matrix4fc)mat);
            CachedBuffers.partial((PartialModel)single.model(), (class_2680)air).light(packedLight).overlay(packedOverlay).renderInto(ms, buffer);
        }
        for (RenderedElement.Multiple multiple : renderer.multipleElements) {
            SuperByteBuffer sbb = CachedBuffers.partial((PartialModel)multiple.model(), (class_2680)air);
            for (RenderedElement element : multiple.elements()) {
                Matrix4f mat2 = element.pose;
                ms.method_23760().method_23761().set((Matrix4fc)mat2);
                ms.method_23760().method_23762().set((Matrix4fc)mat2);
                sbb.light(packedLight).overlay(packedOverlay).renderInto(ms, buffer);
            }
        }
        for (RenderedElement.Scrolling scrolling : renderer.scrollingElements) {
            mat = scrolling.element.pose;
            ms.method_23760().method_23761().set((Matrix4fc)mat);
            ms.method_23760().method_23762().set((Matrix4fc)mat);
            float spriteSize = scrolling.entry.getTarget().method_4575() - scrolling.entry.getTarget().method_4593();
            float scrollV = scrolling.shiftV;
            scrollV -= (float)class_3532.method_15375((float)scrollV);
            scrollV = scrollV * spriteSize * 0.5f;
            CachedBuffers.partial((PartialModel)scrolling.model, (class_2680)air).light(packedLight).overlay(packedOverlay).shiftUVScrolling(scrolling.entry, scrollV).renderInto(ms, buffer);
        }
        if (this.customRenderer != null) {
            this.customRenderer.render(bogeyData, wheelAngle, partialTick, poseStack, bufferSource, packedLight, packedOverlay, inContraption);
        }
    }

    private record Renderer(BogeyDisplay display, List<RenderedElement.Single> singleElements, List<RenderedElement.Multiple> multipleElements, List<RenderedElement.Scrolling> scrollingElements, List<RenderedElement> allElements) {
        private static Renderer create(BogeyDisplay.Factory factory, boolean inContraption) {
            ArrayList<RenderedElement.Single> singleElements = new ArrayList<RenderedElement.Single>();
            ArrayList<RenderedElement.Multiple> multipleElements = new ArrayList<RenderedElement.Multiple>();
            ArrayList<RenderedElement.Scrolling> scrollingElements = new ArrayList<RenderedElement.Scrolling>();
            RenderedElementProvider prov = new RenderedElementProvider(singleElements, multipleElements, scrollingElements);
            BogeyDisplay display = factory.create(prov, inContraption);
            prov.freeze();
            ArrayList<RenderedElement> allElements = new ArrayList<RenderedElement>();
            singleElements.forEach(s -> allElements.add(s.element()));
            multipleElements.forEach(m -> Collections.addAll(allElements, m.elements()));
            scrollingElements.forEach(s -> allElements.add(s.element));
            return new Renderer(display, singleElements, multipleElements, scrollingElements, allElements);
        }
    }
}

