/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.casing.RuntimeFakePartialModel;
import com.railwayteam.railways.content.custom_tracks.casing.SpriteCopyingBakedModel;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.MathUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackMaterial;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.LightShaders;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class CasingRenderUtils {
    private static final HashMap<Pair<PartialModel, class_2482>, PartialModel> reTexturedModels = new HashMap();

    public static void clearModelCache() {
        reTexturedModels.clear();
        CRBlockPartials.registerCasingSpecs();
        class_310.method_1551().field_1769.method_3279();
    }

    public static PartialModel reTexture(PartialModel model, class_2482 block) {
        Pair key = Pair.of((Object)model, (Object)block);
        if (!reTexturedModels.containsKey(key)) {
            class_1087 slabModel = class_310.method_1551().method_1554().method_4743().method_3335(block.method_9564());
            SpriteCopyingBakedModel texturedCasing = new SpriteCopyingBakedModel(model.get(), slabModel);
            PartialModel texturedPartial = RuntimeFakePartialModel.make(Railways.asResource("runtime_casing"), texturedCasing);
            reTexturedModels.put((Pair<PartialModel, class_2482>)key, texturedPartial);
            return texturedPartial;
        }
        return reTexturedModels.get(key);
    }

    public static void renderBezierCasings(class_4587 ms, class_1937 level, PartialModel texturedPartial, class_2680 state, class_4588 vb, BezierConnection bc) {
        double shiftDown;
        int heightDiff = Math.abs(((class_2338)bc.bePositions.get(false)).method_10264() - ((class_2338)bc.bePositions.get(true)).method_10264());
        double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
        if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
            for (class_243 pos : CasingRenderUtils.casingPositions(bc)) {
                ms.method_22903();
                class_2338 tePosition = (class_2338)bc.bePositions.getFirst();
                int light = class_761.method_23794((class_1920)level, (class_2338)class_2338.method_49638((class_2374)pos).method_10081((class_2382)tePosition));
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)texturedPartial, (class_2680)state).translate(pos.field_1352, pos.field_1351, pos.field_1350)).translate(0.0, shiftDown, 0.0)).scale(1.001f)).light(light).renderInto(ms, vb);
                ms.method_22909();
            }
        } else {
            ms.method_22903();
            class_2338 tePosition = (class_2338)bc.bePositions.getFirst();
            BezierConnection.SegmentAngles segments = bc.getBakedSegments();
            TransformStack.of((class_4587)ms).nudge((int)tePosition.method_10063());
            for (int i = 1; i < segments.length; ++i) {
                if (i % 2 == 0) continue;
                int light = class_761.method_23794((class_1920)level, (class_2338)segments.lightPosition[i].method_10081((class_2382)tePosition));
                Matrix4f pose = MathUtils.copy(segments.tieTransform[i].method_23761());
                pose.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)texturedPartial, (class_2680)state).mulPose((Matrix4fc)pose)).mulNormal((Matrix3fc)segments.tieTransform[i].method_23762())).translate(0.0, shiftDown, 0.0)).scale(1.02f)).light(light).renderInto(ms, vb);
                TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
                if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                    for (boolean first : Iterate.trueAndFalse) {
                        for (boolean inner : Iterate.trueAndFalse) {
                            class_4587.class_4665 transform = (class_4587.class_4665)segments.railTransforms[i].get(first);
                            Matrix4f pose2 = MathUtils.copy(transform.method_23761());
                            pose2.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)texturedPartial, (class_2680)state).mulPose((Matrix4fc)pose2)).mulNormal((Matrix3fc)transform.method_23762())).translate((first ? -0.953125 : -0.03125) + (double)(inner ? 0 : (first ? 1 : -1)), shiftDown, 0.0)).light(light).renderInto(ms, vb);
                        }
                    }
                    continue;
                }
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 transform = (class_4587.class_4665)segments.railTransforms[i].get(first);
                    Matrix4f pose2 = MathUtils.copy(transform.method_23761());
                    pose2.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)texturedPartial, (class_2680)state).mulPose((Matrix4fc)pose2)).mulNormal((Matrix3fc)transform.method_23762())).translate(-0.5 + (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? (first ? 0.5 : -0.5) : 0.0), shiftDown, 0.0)).light(light).renderInto(ms, vb);
                }
            }
            ms.method_22909();
        }
    }

    public static List<class_243> casingPositions(BezierConnection bc) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        ArrayList<int[]> takenPositions = new ArrayList<int[]>();
        for (BezierConnection.Segment segment : bc) {
            double factor = 1.3;
            if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                factor += 0.5;
            } else if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
                factor -= 0.4375;
            }
            class_243 pos1 = segment.position.method_1019(segment.normal.method_1021(factor));
            class_243 pos2 = segment.position.method_1019(segment.normal.method_1021(-factor));
            float steps = 4.0f;
            class_243 stepVec = pos1.method_1035(pos2).method_1021((double)(1.0f / steps));
            class_243 curPos = pos1;
            int i = 0;
            while ((float)i <= steps) {
                int x = (int)Math.floor(curPos.field_1352);
                int z = (int)Math.floor(curPos.field_1350);
                if (takenPositions.stream().noneMatch(pos -> pos[0] == x && pos[1] == z)) {
                    takenPositions.add(new int[]{x, z});
                    positions.add(new class_243((double)x, curPos.field_1351 - 0.1875, (double)z));
                }
                curPos = curPos.method_1019(stepVec);
                ++i;
            }
        }
        return positions.stream().toList();
    }

    public static TransformedInstance makeCasingInstance(PartialModel baseModel, class_2482 slabBlock, InstancerProvider instancerProvider) {
        PartialModel texturedPartial = CasingRenderUtils.reTexture(baseModel, slabBlock);
        SimpleModel model = BakedModelBuilder.create((class_1087)texturedPartial.get()).materialFunc((renderType, shaded) -> SimpleMaterial.builderOf((Material)ModelUtil.getMaterial((class_1921)class_1921.method_23579(), (boolean)shaded)).light(LightShaders.FLAT).cardinalLightingMode(shaded != false ? CardinalLightingMode.CHUNK : CardinalLightingMode.OFF).build()).build();
        return (TransformedInstance)instancerProvider.instancer(InstanceTypes.TRANSFORMED, (Model)model).createInstance();
    }
}

