/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.AdventureUtils;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2482;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class SlabUseOnCurvePacket
implements C2SPacket {
    private class_2338 pos;
    private class_2338 targetPos;
    private class_2338 soundSource;

    public SlabUseOnCurvePacket(class_2338 pos, class_2338 targetPos, class_2338 soundSource) {
        this.pos = pos;
        this.targetPos = targetPos;
        this.soundSource = soundSource;
    }

    public SlabUseOnCurvePacket(class_2540 buffer) {
        this.pos = buffer.method_10811();
        this.targetPos = buffer.method_10811();
        this.soundSource = buffer.method_10811();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10807(this.pos);
        buffer.method_10807(this.targetPos);
        buffer.method_10807(this.soundSource);
    }

    @Override
    public void handle(class_3222 player) {
        class_1937 world = player.field_6002;
        if (AdventureUtils.isAdventure((class_1657)player)) {
            return;
        }
        if (!world.method_8477(this.pos)) {
            return;
        }
        if (!this.pos.method_19771((class_2382)player.method_24515(), 64.0)) {
            return;
        }
        class_2586 BlockEntity = world.method_8321(this.pos);
        if (BlockEntity instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)BlockEntity;
            this.applySettings(player, track);
            track.notifyUpdate();
        }
    }

    private class_1269 useOn(class_3222 player, class_1268 hand, class_1937 world, IHasTrackCasing casingAble) {
        class_2482 currentCasing;
        class_1747 blockItem;
        if (world.field_9236) {
            return class_1269.field_5814;
        }
        class_1799 handStack = player.method_5998(hand);
        class_1792 class_17922 = handStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2482) {
            class_2482 slabBlock = (class_2482)class_17922;
            currentCasing = casingAble.getTrackCasing();
            if (currentCasing == slabBlock) {
                casingAble.setAlternate(!casingAble.isAlternate());
                return class_1269.field_5812;
            }
            if (!player.method_7337()) {
                handStack.method_7934(1);
                if (currentCasing != null) {
                    class_1799 casingStack = new class_1799((class_1935)currentCasing);
                    EntityUtils.givePlayerItem((class_1657)player, casingStack);
                }
                player.method_6122(hand, handStack);
            }
            casingAble.setTrackCasing(slabBlock);
            return class_1269.field_5812;
        }
        if (handStack.method_7960() && (currentCasing = casingAble.getTrackCasing()) != null) {
            handStack = new class_1799((class_1935)currentCasing);
            casingAble.setTrackCasing(null);
            if (!player.method_7337()) {
                EntityUtils.givePlayerItem((class_1657)player, handStack);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void applySettings(class_3222 player, TrackBlockEntity te) {
        if (!te.method_11016().method_19771((class_2382)player.method_24515(), 128.0)) {
            Railways.LOGGER.warn(player.method_5820() + " too far away from slabbed Curve track");
            return;
        }
        class_1937 level = te.method_10997();
        BezierConnection bezierConnection = (BezierConnection)te.getConnections().get(this.targetPos);
        if (bezierConnection.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            Railways.LOGGER.warn(player.method_5820() + "tried to slab a monorail track");
            return;
        }
        if (level != null) {
            class_1268 hand = class_1268.field_5808;
            class_1269 result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            if (!result.method_23665()) {
                hand = class_1268.field_5810;
                result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            }
            if (result.method_23666()) {
                player.method_23667(hand, true);
            }
            te.notifyUpdate();
        }
    }
}

