/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.fabric.CRMountedStorageTypesImpl;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.WrapperMountedFluidStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.CreateCodecs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class FuelTankMountedStorage
extends WrapperMountedFluidStorage<Handler>
implements SyncedMountedStorage {
    public static final Codec<FuelTankMountedStorage> CODEC = RecordCodecBuilder.create(i -> i.group((App)CreateCodecs.NON_NEGATIVE_LONG.fieldOf("capacity").forGetter(FuelTankMountedStorage::getCapacity), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(FuelTankMountedStorage::getFluid)).apply((Applicative)i, FuelTankMountedStorage::new));
    private boolean dirty;

    protected FuelTankMountedStorage(long capacity, FluidStack stack) {
        super((MountedFluidStorageType)CRMountedStorageTypesImpl.FUEL_TANK.get(), (Storage)new Handler(capacity, stack));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        FuelTankBlockEntity tank;
        if (be instanceof FuelTankBlockEntity && (tank = (FuelTankBlockEntity)be).isController()) {
            FluidTank inventory = tank.getTankInventory();
            inventory.setFluid(((Handler)this.wrapped).getFluid());
        }
    }

    public FluidStack getFluid() {
        return Objects.requireNonNull(((Handler)this.wrapped).getFluid());
    }

    public long getCapacity() {
        return ((Handler)this.wrapped).getCapacity();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, class_2338 localPos) {
        class_2586 be = contraption.getOrCreateClientContraptionLazy().getBlockEntity(localPos);
        if (!(be instanceof FuelTankBlockEntity)) {
            return;
        }
        FuelTankBlockEntity tank = (FuelTankBlockEntity)be;
        FluidTank inv = tank.getTankInventory();
        inv.setFluid(this.getFluid());
        float fillLevel = (float)inv.getFluidAmount() / (float)inv.getCapacity();
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue((double)fillLevel));
        }
        tank.getFluidLevel().chase((double)fillLevel, 0.5, LerpedFloat.Chaser.EXP);
    }

    public static FuelTankMountedStorage fromTank(FuelTankBlockEntity tank) {
        FluidTank inventory = tank.getTankInventory();
        return new FuelTankMountedStorage(inventory.getCapacity(), inventory.getFluid().copy());
    }

    public static FuelTankMountedStorage fromLegacy(class_2487 nbt) {
        int capacity = nbt.method_10550("Capacity");
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((class_2487)nbt);
        return new FuelTankMountedStorage(capacity, fluid);
    }

    public static final class Handler
    extends FluidTank {
        private Runnable onChange = () -> {};

        public Handler(long capacity, FluidStack stack) {
            super(capacity);
            Objects.requireNonNull(stack);
            this.setFluid(stack);
        }

        protected void onContentsChanged() {
            this.onChange.run();
        }
    }
}

