/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.noportals.option;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kevinthegreat.noportals.NoPortals;
import com.kevinthegreat.noportals.option.SimpleBooleanOption;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2329;
import net.minecraft.class_2334;
import net.minecraft.class_2423;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NoPortalsOptions {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path optionsFile;
    public final SimpleBooleanOption disableNetherPortal = new SimpleBooleanOption("disableNetherPortal", "nether");
    public final SimpleBooleanOption disableEndPortal = new SimpleBooleanOption("disableEndPortal", "end");
    public final SimpleBooleanOption disableEndGateway = new SimpleBooleanOption("disableEndGateway", "endGateway");
    public final Map<String, SimpleBooleanOption> options = ImmutableMap.of((Object)this.disableNetherPortal.getName(), (Object)this.disableNetherPortal, (Object)this.disableEndPortal.getName(), (Object)this.disableEndPortal, (Object)this.disableEndGateway.getName(), (Object)this.disableEndGateway);

    public NoPortalsOptions(MinecraftServer server) {
        this.optionsFile = server.method_27050(class_5218.field_24188).resolve("noportals.json");
        this.load();
    }

    public boolean isNetherPortalDisabled() {
        return this.disableNetherPortal.getValue();
    }

    public boolean isEndPortalDisabled() {
        return this.disableEndPortal.getValue();
    }

    public boolean isEndGatewayDisabled() {
        return this.disableEndGateway.getValue();
    }

    @Nullable
    public SimpleBooleanOption getDisablePortalOption(class_2248 block) {
        class_2248 class_22482 = block;
        Objects.requireNonNull(class_22482);
        class_2248 class_22483 = class_22482;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2423.class, class_2334.class, class_2329.class}, (Object)class_22483, n)) {
            case 0 -> {
                class_2423 netherPortal = (class_2423)class_22483;
                yield this.disableNetherPortal;
            }
            case 1 -> {
                class_2334 endPortal = (class_2334)class_22483;
                yield this.disableEndPortal;
            }
            case 2 -> {
                class_2329 endGateway = (class_2329)class_22483;
                yield this.disableEndGateway;
            }
            default -> null;
        };
    }

    public void load() {
        JsonObject optionsJson;
        if (!Files.isRegularFile(this.optionsFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.optionsFile);){
            optionsJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            NoPortals.LOGGER.warn("Options file not found", (Throwable)e);
            return;
        }
        catch (IOException e) {
            NoPortals.LOGGER.error("Failed to load options", (Throwable)e);
            return;
        }
        this.options.entrySet().forEach(entry -> this.parseOption(optionsJson, (Map.Entry<String, SimpleBooleanOption>)entry));
    }

    private void parseOption(JsonObject optionsJson, Map.Entry<String, SimpleBooleanOption> option) {
        DataResult dataResult = Codec.BOOL.parse((DynamicOps)JsonOps.INSTANCE, (Object)optionsJson.get(option.getKey()));
        dataResult.error().ifPresent(error -> NoPortals.LOGGER.error("Error parsing option value {} for option {}: {}", new Object[]{optionsJson.get((String)option.getKey()), option.getKey(), error}));
        dataResult.result().ifPresent(option.getValue()::setValue);
    }

    public void save() {
        Path tempFile;
        JsonObject optionsJson = new JsonObject();
        this.options.entrySet().forEach(option -> this.saveOption(optionsJson, (Map.Entry<String, SimpleBooleanOption>)option));
        try {
            tempFile = Files.createTempFile(this.optionsFile.getParent(), "noportals", ".json", new FileAttribute[0]);
        }
        catch (IOException e) {
            NoPortals.LOGGER.error("Failed to save options file", (Throwable)e);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(tempFile, new OpenOption[0]);){
            GSON.toJson((JsonElement)optionsJson, (Appendable)writer);
        }
        catch (IOException e) {
            NoPortals.LOGGER.error("Failed to write options", (Throwable)e);
        }
        Path backup = this.optionsFile.getParent().resolve("noportals.json_old");
        class_156.method_30626((Path)this.optionsFile, (Path)tempFile, (Path)backup);
    }

    private void saveOption(JsonObject optionsJson, Map.Entry<String, SimpleBooleanOption> option) {
        DataResult dataResult = Codec.BOOL.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)option.getValue().getValue());
        dataResult.error().ifPresent(error -> NoPortals.LOGGER.error("Error encoding option value {} for option {}: {}", new Object[]{((SimpleBooleanOption)option.getValue()).getValue(), option.getKey(), error}));
        dataResult.result().ifPresent(optionJson -> optionsJson.add((String)option.getKey(), optionJson));
    }
}

