/*
 * Decompiled with CFR 0.152.
 */
package net.nycto_team.blockdonalds.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.nycto_team.blockdonalds.block.DeepFryer;
import net.nycto_team.blockdonalds.recipe.DeepFryingRecipe;
import net.nycto_team.blockdonalds.registries.ModBlockEntities;

public class DeepFryerEntity
extends BlockEntity
implements Clearable {
    private static final int _slots = 16;
    private final NonNullList<ItemStack> _items = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private final int[] _time = new int[16];
    private final int[] _progress = new int[16];
    private final RecipeManager.CachedCheck<Container, DeepFryingRecipe> _quick_check = RecipeManager.m_220267_((RecipeType)DeepFryingRecipe.Type._instance);

    public DeepFryerEntity(BlockPos _pos, BlockState _state) {
        super((BlockEntityType)ModBlockEntities._deep_fryer.get(), _pos, _state);
    }

    public static void ServerTick(Level _level, BlockPos _pos, BlockState _state, DeepFryerEntity _entity) {
        boolean _active_f = false;
        for (int i = 0; i < _entity._items.size(); ++i) {
            SimpleContainer _container;
            ItemStack _result;
            ItemStack _stack = (ItemStack)_entity._items.get(i);
            if (_stack.m_41619_() || (_result = (ItemStack)_entity._quick_check.m_213657_((Container)(_container = new SimpleContainer(new ItemStack[]{_stack})), _level).map(arg_0 -> DeepFryerEntity.lambda$ServerTick$0((Container)_container, _level, arg_0)).orElse(null)) == null) continue;
            _active_f = true;
            if (_entity._progress[i] >= _entity._time[i]) {
                if (!_result.m_246617_(_level.m_246046_())) continue;
                _entity._items.set(i, (Object)_result);
                _entity._progress[i] = -1;
                _entity.Update();
                _level.m_7260_(_pos, _state, _state, 3);
                _level.m_220407_(GameEvent.f_157792_, _pos, GameEvent.Context.m_223722_((BlockState)_state));
                continue;
            }
            int n = i;
            _entity._progress[n] = _entity._progress[n] + 1;
        }
        BlockState _new_state = (BlockState)((BlockState)_state.m_61124_((Property)DeepFryer._active, (Comparable)Boolean.valueOf(_active_f))).m_61124_((Property)DeepFryer._filled, (Comparable)Boolean.valueOf(!_entity.get_finished_items().isEmpty()));
        _level.m_7731_(_pos, _new_state, 2);
        if (_active_f) {
            DeepFryerEntity.m_155232_((Level)_level, (BlockPos)_pos, (BlockState)_new_state);
        }
    }

    public static void ClientTick(Level _level, BlockPos _pos, BlockState _state, DeepFryerEntity _entity) {
        RandomSource _random = _level.f_46441_;
        if (((Boolean)_state.m_61143_((Property)DeepFryer._active)).booleanValue() && _random.m_188501_() < 0.11f) {
            for (int i = 0; i < _random.m_188503_(2) + 2; ++i) {
                DeepFryer.MakeParticles(_level, _pos);
            }
        }
    }

    public boolean PlaceFood(@Nullable Entity _entity, ItemStack _stack, int _time) {
        boolean _placed = false;
        for (int i = 0; i < this._items.size() && !_stack.m_41619_(); ++i) {
            ItemStack _i_stack = (ItemStack)this._items.get(i);
            if (!_i_stack.m_41619_()) continue;
            this._time[i] = _time;
            this._progress[i] = 0;
            this._items.set(i, (Object)_stack.m_41620_(1));
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)_entity, (BlockState)this.m_58900_()));
            this.Update();
            _placed = true;
        }
        return _placed;
    }

    public List<ItemStack> get_finished_items() {
        ArrayList<ItemStack> _list = new ArrayList<ItemStack>();
        for (int i = 0; i < this._items.size(); ++i) {
            ItemStack _i_stack = (ItemStack)this._items.get(i);
            if (_i_stack.m_41619_() || this._progress[i] != -1) continue;
            _list.add(_i_stack);
        }
        return _list;
    }

    public void Update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public Optional<DeepFryingRecipe> get_recipe(ItemStack _stack) {
        return this._items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this._quick_check.m_213657_((Container)new SimpleContainer(new ItemStack[]{_stack}), this.f_58857_);
    }

    public NonNullList<ItemStack> get_items() {
        return this._items;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag _tag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)_tag, this._items, (boolean)true);
        return _tag;
    }

    public void m_142466_(CompoundTag _tag) {
        int[] _arr;
        super.m_142466_(_tag);
        this._items.clear();
        ContainerHelper.m_18980_((CompoundTag)_tag, this._items);
        if (_tag.m_128425_("Progress", 11)) {
            _arr = _tag.m_128465_("Progress");
            System.arraycopy(_arr, 0, this._progress, 0, Math.min(this._time.length, _arr.length));
        }
        if (_tag.m_128425_("Time", 11)) {
            _arr = _tag.m_128465_("Time");
            System.arraycopy(_arr, 0, this._time, 0, Math.min(this._time.length, _arr.length));
        }
    }

    protected void m_183515_(CompoundTag _tag) {
        super.m_183515_(_tag);
        ContainerHelper.m_18976_((CompoundTag)_tag, this._items, (boolean)true);
        _tag.m_128385_("Progress", this._progress);
        _tag.m_128385_("Time", this._time);
    }

    public void m_6211_() {
        this._items.clear();
    }

    private static /* synthetic */ ItemStack lambda$ServerTick$0(Container _container, Level _level, DeepFryingRecipe _recipe) {
        return _recipe.m_5874_(_container, _level.m_9598_());
    }
}

