/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop;

import eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopCommand;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import eu.mrneznamy.mrultimateshop.commands.MusCommand;
import eu.mrneznamy.mrultimateshop.commands.ShopCommand;
import eu.mrneznamy.mrultimateshop.managers.BuySellMenuManager;
import eu.mrneznamy.mrultimateshop.managers.ConfigManager;
import eu.mrneznamy.mrultimateshop.managers.EconomyManager;
import eu.mrneznamy.mrultimateshop.managers.FeatureManager;
import eu.mrneznamy.mrultimateshop.managers.LogManager;
import eu.mrneznamy.mrultimateshop.managers.MenuManager;
import eu.mrneznamy.mrultimateshop.managers.MessageManager;
import eu.mrneznamy.mrultimateshop.managers.SellGuiManager;
import eu.mrneznamy.mrultimateshop.managers.StatisticsManager;
import eu.mrneznamy.mrultimateshop.managers.WorldManager;
import eu.mrneznamy.mrultimateshop.utils.CheckUpdates;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MrUltimateShop
extends JavaPlugin {
    private static MrUltimateShop instance;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private EconomyManager economyManager;
    private MenuManager menuManager;
    private SellGuiManager sellGuiManager;
    private StatisticsManager statisticsManager;
    private CheckUpdates checkUpdates;
    private LogManager logManager;
    private WorldManager worldManager;
    private FeatureManager featureManager;
    private ChestShopManager chestShopManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.economyManager = new EconomyManager(this);
        this.statisticsManager = new StatisticsManager(this);
        this.checkUpdates = new CheckUpdates();
        this.logManager = new LogManager(this);
        this.worldManager = new WorldManager(this);
        this.featureManager = new FeatureManager(this);
        this.loadConfiguration();
        this.chestShopManager = new ChestShopManager(this);
        this.chestShopManager.loadShopsFromDisk();
        this.menuManager = new MenuManager(this);
        this.sellGuiManager = new SellGuiManager(this);
        this.economyManager.setupEconomy();
        this.registerCommands();
        MrUltimateShopAPI.initialize(this);
        this.checkUpdates.EnableMessage();
        this.checkUpdates.checkForUpdates();
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String title;
            if (player.getOpenInventory() == null || (title = player.getOpenInventory().getTitle()) == null || !title.contains("MrUltimateShop") && !title.contains("CHEST-SHOP")) continue;
            player.closeInventory();
        }
        if (this.chestShopManager != null) {
            this.chestShopManager.shutdown();
        }
        if (this.statisticsManager != null) {
            this.statisticsManager.saveStatistics();
        }
        MrUltimateShopAPI.clearAllRegistrations();
        this.getLogger().info(this.messageManager.getMessage("general.plugin-disabled", "MrUltimateShop has been successfully disabled!"));
    }

    private void loadConfiguration() {
        this.createDefaultFiles();
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
    }

    private void createDefaultFiles() {
        File sellAllGuiFile;
        File sellGuiFile;
        File buyGuiFile;
        File menuFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(menuFile = new File(this.getDataFolder(), "menu.yml")).exists()) {
            this.saveResource("menu.yml", false);
        }
        if (!(buyGuiFile = new File(this.getDataFolder(), "buy-gui.yml")).exists()) {
            this.saveResource("buy-gui.yml", false);
        }
        if (!(sellGuiFile = new File(this.getDataFolder(), "sell-gui.yml")).exists()) {
            this.saveResource("sell-gui.yml", false);
        }
        if (!(sellAllGuiFile = new File(this.getDataFolder(), "sell-all-gui.yml")).exists()) {
            this.saveResource("sell-all-gui.yml", false);
        }
        this.createDefaultShopsIfFirstRun();
    }

    private void createDefaultShopsIfFirstRun() {
        YamlConfiguration dataConfig;
        File dataFile = new File(this.getDataFolder(), "data.yml");
        if (!dataFile.exists()) {
            dataConfig = new YamlConfiguration();
            dataConfig.set("first-run-completed", (Object)false);
            dataConfig.set("default-shops-created", (Object)false);
            try {
                dataConfig.save(dataFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Could not create data.yml: " + e.getMessage());
                return;
            }
        } else {
            dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
        }
        if (!dataConfig.getBoolean("default-shops-created", false)) {
            String[] shopFiles;
            this.getLogger().info("First run detected - creating default shop files...");
            File shopsFolder = new File(this.getDataFolder(), "Shops");
            if (!shopsFolder.exists()) {
                shopsFolder.mkdirs();
            }
            for (String shopFile : shopFiles = new String[]{"blocks.yml", "weapons.yml", "food.yml", "redstone.yml", "decorations.yml", "colored_blocks.yml", "tools_weapons.yml", "spawners.yml", "ores.yml", "miscellaneous.yml"}) {
                File shop = new File(shopsFolder, shopFile);
                if (shop.exists()) continue;
                this.saveResource("Shops/" + shopFile, false);
                this.getLogger().info("Created default shop: " + shopFile);
            }
            dataConfig.set("default-shops-created", (Object)true);
            dataConfig.set("first-run-completed", (Object)true);
            try {
                dataConfig.save(dataFile);
                this.getLogger().info("Default shops created successfully! You can delete any unwanted shop files.");
            }
            catch (IOException e) {
                this.getLogger().warning("Could not save data.yml: " + e.getMessage());
            }
        }
    }

    private void registerCommands() {
        MusCommand musCommand = new MusCommand(this);
        ShopCommand shopCommand = new ShopCommand(this);
        this.getCommand("mus").setExecutor((CommandExecutor)musCommand);
        this.getCommand("mus").setTabCompleter((TabCompleter)musCommand);
        this.getCommand("shop").setExecutor((CommandExecutor)shopCommand);
        this.getCommand("shop").setTabCompleter((TabCompleter)shopCommand);
        if (this.chestShopManager != null) {
            ChestShopCommand cshopCommand = new ChestShopCommand(this, this.chestShopManager);
            this.getCommand("cshop").setExecutor((CommandExecutor)cshopCommand);
            this.getCommand("cshop").setTabCompleter((TabCompleter)cshopCommand);
        }
    }

    public void reloadConfiguration() {
        this.configManager.reloadConfig();
        this.messageManager.reloadMessages();
        this.menuManager.reloadMenus();
        this.sellGuiManager.reloadConfiguration();
        this.sellGuiManager.reloadSellAllGui();
        this.getBuySellMenuManager().reloadConfigurations();
        this.economyManager.setupEconomy();
        this.getLogger().info(this.messageManager.getMessage("general.config-loaded", "Configuration has been successfully loaded!"));
    }

    public static MrUltimateShop getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public SellGuiManager getSellGuiManager() {
        return this.sellGuiManager;
    }

    public BuySellMenuManager getBuySellMenuManager() {
        return this.menuManager.getBuySellMenuManager();
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public ChestShopManager getChestShopManager() {
        return this.chestShopManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }
}

