/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChestShopCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateShop plugin;
    private final ChestShopManager manager;

    public ChestShopCommand(MrUltimateShop plugin, ChestShopManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.manager.isEnabled()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.disabled", "{Prefix}&cChest-Shops are disabled."));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                return this.handleCreateCommand(player, args);
            }
            case "give": {
                return this.handleGiveCommand(player, args);
            }
            case "team": {
                return this.handleTeamCommand(player, args);
            }
        }
        this.sendHelpMessage(player);
        return true;
    }

    private boolean handleCreateCommand(Player player, String[] args) {
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        boolean enabled = cfg.getBoolean("ChestShops.Commands.Create.enabled", true);
        if (!enabled) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.disabled", "{Prefix}&cChest-Shops are disabled."));
            return true;
        }
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand == null || hand.getType() == Material.AIR) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-item-required", "{Prefix}&cHold an item in your main hand!"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.isAllowedBlock(target.getType().name())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-look-at-allowed", "{Prefix}&cLook at an allowed block and try again!"));
            return true;
        }
        if (this.manager.hasShopAt(target.getLocation())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-already-exists", "{Prefix}&cA shop already exists at this block!"));
            return true;
        }
        if (!this.manager.canPlaceShopAt(target.getLocation())) {
            int minDistance = this.plugin.getConfigManager().getConfig().getInt("ChestShops.Shops.Min-Distance-Between-Shops", 2);
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-too-close", "{Prefix}&cShops must be at least " + minDistance + " blocks apart from each other!"));
            return true;
        }
        if (!this.manager.canCreateShop(player)) {
            int limit = this.manager.getShopLimitForPlayer(player);
            int current = this.manager.getPlayerShopCount(player);
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.limit-reached", "{Prefix}&cYou have reached your shop limit! (" + current + "/" + limit + ")"));
            return true;
        }
        double price = cfg.getDouble("ChestShops.Commands.Create.Price-Per-Success-Command", 0.0);
        if (price > 0.0) {
            if (!this.plugin.getEconomyManager().isEconomyEnabled()) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-no-economy", "{Prefix}&cEconomy is not enabled!"));
                return true;
            }
            if (!this.plugin.getEconomyManager().hasEnough(player, price)) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-not-enough-money", "{Prefix}&cYou don't have enough money!"));
                return true;
            }
            boolean ok = this.plugin.getEconomyManager().withdrawMoney(player, price);
            if (!ok) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-transaction-failed", "{Prefix}&cPayment failed!"));
                return true;
            }
        }
        ChestShop shop = new ChestShop(player.getUniqueId());
        shop.setLocation(target.getLocation());
        shop.setItemForTrade(hand.clone());
        shop.setCreatedWithShopItem(false);
        this.manager.registerShop(shop);
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.create-success", "{Prefix}&aShop created!"));
        return true;
    }

    private boolean handleGiveCommand(Player player, String[] args) {
        if (!player.hasPermission("mrultimateshop.cshop.give")) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("errors.no-permission", "{Prefix}&cYou don't have permission to use this command!"));
            return true;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("shop")) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.give-usage", "{Prefix}&cUsage: /cshop give shop [player]"));
            return true;
        }
        Player target = player;
        if (args.length >= 3 && (target = player.getServer().getPlayerExact(args[2])) == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        ItemStack item = this.manager.buildShopItem();
        if (target.getInventory().firstEmpty() == -1) {
            target.getWorld().dropItemNaturally(target.getLocation(), item);
        } else {
            target.getInventory().addItem(new ItemStack[]{item});
        }
        if (target.equals((Object)player)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.give-success-self", "{Prefix}&aYou received a shop item!"));
        } else {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.give-success-other", "{Prefix}&aGave shop item to [player]!").replace("[player]", target.getName()));
            target.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.give-received", "{Prefix}&aYou received a shop item from [player]!").replace("[player]", player.getName()));
        }
        return true;
    }

    private boolean handleTeamCommand(Player player, String[] args) {
        String teamSubCommand;
        if (args.length < 2) {
            this.sendTeamHelpMessage(player);
            return true;
        }
        switch (teamSubCommand = args[1].toLowerCase()) {
            case "invite": {
                return this.handleTeamInvite(player, args);
            }
            case "remove": {
                return this.handleTeamRemove(player, args);
            }
            case "list": {
                return this.handleTeamList(player, args);
            }
        }
        this.sendTeamHelpMessage(player);
        return true;
    }

    private boolean handleTeamInvite(Player player, String[] args) {
        ChestShop.TeamRole role;
        if (args.length < 4) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-invite-usage", "{Prefix}&cUsage: /cshop team invite <player> <Editor|Supplementer>"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.isOwner(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-not-owner", "{Prefix}&cYou must be the owner to manage team members!"));
            return true;
        }
        Player invitedPlayer = player.getServer().getPlayerExact(args[2]);
        if (invitedPlayer == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        if (invitedPlayer.equals((Object)player)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-cannot-invite-self", "{Prefix}&cYou cannot invite yourself!"));
            return true;
        }
        String roleString = args[3].toLowerCase();
        if (roleString.equals("editor")) {
            role = ChestShop.TeamRole.EDITOR;
        } else if (roleString.equals("supplementer")) {
            role = ChestShop.TeamRole.SUPPLEMENTER;
        } else {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-invalid-role", "{Prefix}&cInvalid role! Use 'Editor' or 'Supplementer'"));
            return true;
        }
        shop.addTeamMember(invitedPlayer.getUniqueId(), role);
        this.manager.saveShops();
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-invite-success", "{Prefix}&aAdded [player] as [role] to your shop!").replace("[player]", invitedPlayer.getName()).replace("[role]", role.name()));
        invitedPlayer.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-invited", "{Prefix}&aYou have been added to [owner]'s shop as [role]!").replace("[owner]", player.getName()).replace("[role]", role.name()));
        return true;
    }

    private boolean handleTeamRemove(Player player, String[] args) {
        if (args.length < 3) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-remove-usage", "{Prefix}&cUsage: /cshop team remove <player>"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.isOwner(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-not-owner", "{Prefix}&cYou must be the owner to manage team members!"));
            return true;
        }
        Player removedPlayer = player.getServer().getPlayerExact(args[2]);
        if (removedPlayer == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        if (!shop.isTeamMember(removedPlayer.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-not-member", "{Prefix}&c[player] is not a team member!").replace("[player]", removedPlayer.getName()));
            return true;
        }
        shop.removeShopSpecificMember(removedPlayer.getUniqueId());
        this.manager.saveShops();
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-remove-success", "{Prefix}&aRemoved [player] from your shop!").replace("[player]", removedPlayer.getName()));
        removedPlayer.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-removed", "{Prefix}&cYou have been removed from [owner]'s shop!").replace("[owner]", player.getName()));
        return true;
    }

    private boolean handleGlobalTeamRemove(Player player, String[] args) {
        if (args.length < 3) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-global-remove-usage", "{Prefix}&cUsage: /cshop team remove <player>"));
            return true;
        }
        Player removedPlayer = player.getServer().getPlayerExact(args[2]);
        if (removedPlayer == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        this.manager.removePlayerFromAllShops(removedPlayer.getUniqueId());
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-global-remove-success", "{Prefix}&aRemoved [player] from ALL your shops!").replace("[player]", removedPlayer.getName()));
        removedPlayer.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-global-removed", "{Prefix}&cYou have been removed from [owner]'s ALL shops!").replace("[owner]", player.getName()));
        return true;
    }

    private boolean handleTeamList(Player player, String[] args) {
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.hasAccess(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-no-access", "{Prefix}&cYou don't have access to this shop!"));
            return true;
        }
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-list-header", "{Prefix}&aShop Team Members:"));
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)shop.getOwnerUuid());
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-list-owner", "&e[player] &7(Owner)").replace("[player]", owner.getName() != null ? owner.getName() : "Unknown"));
        for (Map.Entry<UUID, ChestShop.TeamRole> entry : shop.getTeamMembers().entrySet()) {
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            String roleName = entry.getValue().name().toLowerCase();
            roleName = roleName.substring(0, 1).toUpperCase() + roleName.substring(1);
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-list-member", "&a[player] &7([role])").replace("[player]", member.getName() != null ? member.getName() : "Unknown").replace("[role]", roleName));
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.help-header", "{Prefix}&aChest Shop Commands:"));
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.help-create", "&e/cshop create &f- Create a new chest shop"));
        if (player.hasPermission("mrultimateshop.cshop.give")) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.help-give", "&e/cshop give shop [player] &f- Give shop item"));
        }
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.help-team", "&e/cshop team &f- Manage shop team members"));
    }

    private void sendTeamHelpMessage(Player player) {
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-help-header", "{Prefix}&aTeam Commands:"));
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-help-invite", "&e/cshop team invite <player> <Editor|Supplementer> &f- Invite team member"));
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-help-remove", "&e/cshop team remove <player> &f- Remove team member"));
        player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-help-list", "&e/cshop team list &f- List team members"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("mrultimateshop.cshop.create")) {
                result.add("create");
            }
            if (sender.hasPermission("mrultimateshop.cshop.give")) {
                result.add("give");
            }
            if (sender.hasPermission("mrultimateshop.cshop.team")) {
                result.add("team");
            }
            return result.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("give") && sender.hasPermission("mrultimateshop.cshop.give")) {
                result.add("shop");
            } else if (args[0].equalsIgnoreCase("team") && sender.hasPermission("mrultimateshop.cshop.team")) {
                result.add("invite");
                result.add("remove");
                result.add("list");
            }
            return result.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give") && args[1].equalsIgnoreCase("shop") && sender.hasPermission("mrultimateshop.cshop.give")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    result.add(player.getName());
                }
            } else if (args[0].equalsIgnoreCase("team") && (args[1].equalsIgnoreCase("invite") || args[1].equalsIgnoreCase("remove")) && sender.hasPermission("mrultimateshop.cshop.team")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.equals((Object)sender) || !player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    result.add(player.getName());
                }
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("team") && args[1].equalsIgnoreCase("invite") && sender.hasPermission("mrultimateshop.cshop.team")) {
            if ("editor".startsWith(args[3].toLowerCase())) {
                result.add("Editor");
            }
            if ("supplementer".startsWith(args[3].toLowerCase())) {
                result.add("Supplementer");
            }
        }
        return result;
    }
}

