/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChestShopLogManager {
    private final MrUltimateShop plugin;
    private final File logFile;
    private final SimpleDateFormat dateFormat;

    public ChestShopLogManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        String logFileName = plugin.getConfigManager().getConfig().getString("Logging.file", "log.log");
        if (logFileName.equals("log.log")) {
            logFileName = "chestlog.log";
        }
        this.logFile = new File(plugin.getDataFolder(), logFileName);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create " + logFileName + ": " + e.getMessage());
            }
        }
    }

    public void logShopCreated(Player player, Location location) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] SHOP_CREATE: %s created shop at %s", this.dateFormat.format(new Date()), player.getName(), this.locationToString(location));
        this.writeToLog(logEntry);
    }

    public void logShopDestroyed(Player player, Location location) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] SHOP_DESTROY: %s destroyed shop at %s", this.dateFormat.format(new Date()), player.getName(), this.locationToString(location));
        this.writeToLog(logEntry);
    }

    public void logShopBuy(Player buyer, Location shopLocation, ItemStack item, int quantity, double price, double tax) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] SHOP_BUY: %s bought %dx %s for $%.2f (tax: $%.2f) at %s", this.dateFormat.format(new Date()), buyer.getName(), quantity, item.getType().name(), price, tax, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    public void logShopSell(Player seller, Location shopLocation, ItemStack item, int quantity, double price, double tax) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] SHOP_SELL: %s sold %dx %s for $%.2f (tax: $%.2f) at %s", this.dateFormat.format(new Date()), seller.getName(), quantity, item.getType().name(), price, tax, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    public void logEditorAction(Player editor, Location shopLocation, String action, String details) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] EDITOR_ACTION: %s (%s) %s at %s - %s", this.dateFormat.format(new Date()), editor.getName(), "EDITOR", action, this.locationToString(shopLocation), details);
        this.writeToLog(logEntry);
    }

    public void logSupplementerAction(Player supplementer, Location shopLocation, String action, String details) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] SUPPLEMENTER_ACTION: %s (%s) %s at %s - %s", this.dateFormat.format(new Date()), supplementer.getName(), "SUPPLEMENTER", action, this.locationToString(shopLocation), details);
        this.writeToLog(logEntry);
    }

    public void logPriceChange(Player player, Location shopLocation, String priceType, Double oldPrice, Double newPrice) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String oldPriceStr = oldPrice != null ? String.format("$%.2f", oldPrice) : "null";
        String newPriceStr = newPrice != null ? String.format("$%.2f", newPrice) : "null";
        String logEntry = String.format("[%s] PRICE_CHANGE: %s changed %s price from %s to %s at %s", this.dateFormat.format(new Date()), player.getName(), priceType, oldPriceStr, newPriceStr, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    public void logItemChange(Player player, Location shopLocation, ItemStack oldItem, ItemStack newItem) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String oldItemStr = oldItem != null ? oldItem.getType().name() : "null";
        String newItemStr = newItem != null ? newItem.getType().name() : "null";
        String logEntry = String.format("[%s] ITEM_CHANGE: %s changed trade item from %s to %s at %s", this.dateFormat.format(new Date()), player.getName(), oldItemStr, newItemStr, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    public void logTeamAction(Player player, Location shopLocation, String action, String targetPlayer, String role, boolean isGlobal) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String scope = isGlobal ? "GLOBAL" : "SHOP";
        String logEntry = String.format("[%s] TEAM_%s: %s %s %s (%s) %s at %s", this.dateFormat.format(new Date()), action.toUpperCase(), player.getName(), action.toLowerCase(), targetPlayer, role, scope, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    public void logInventoryAccess(Player player, Location shopLocation, String action) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        String logEntry = String.format("[%s] INVENTORY_ACCESS: %s %s shop inventory at %s", this.dateFormat.format(new Date()), player.getName(), action, this.locationToString(shopLocation));
        this.writeToLog(logEntry);
    }

    private String locationToString(Location location) {
        if (location == null) {
            return "unknown";
        }
        return String.format("(%s: %d,%d,%d)", location.getWorld() != null ? location.getWorld().getName() : "unknown", location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    private boolean isLoggingEnabled() {
        return this.plugin.getConfigManager().getConfig().getBoolean("Logging.enabled", true);
    }

    private void writeToLog(String entry) {
        try (FileWriter writer = new FileWriter(this.logFile, true);){
            writer.write(entry + "\n");
            writer.flush();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not write to " + this.logFile.getName() + ": " + e.getMessage());
        }
    }
}

