/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final MrUltimateShop plugin;
    private Economy vaultEconomy;
    private String economyType;
    private String currencySymbol;
    private boolean economyEnabled;

    public EconomyManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.economyEnabled = false;
    }

    public void setupEconomy() {
        this.economyType = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.EconomyType.Type", "Vault");
        switch (this.economyType.toLowerCase()) {
            case "vault": {
                this.setupVaultEconomy();
                break;
            }
            case "playerpoints": {
                break;
            }
            case "tokenmanager": {
                break;
            }
        }
    }

    private void setupVaultEconomy() {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("MrUltimateShop.EconomyType.Vault.Enable", true)) {
            return;
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.vaultEconomy = (Economy)rsp.getProvider();
        this.currencySymbol = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.EconomyType.Vault.Currency-Symbol", "\u20ac");
        this.economyEnabled = true;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public double getBalance(Player player) {
        if (!this.economyEnabled) {
            return 0.0;
        }
        return this.vaultEconomy != null ? this.vaultEconomy.getBalance((OfflinePlayer)player) : 0.0;
    }

    public boolean hasEnough(Player player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean withdrawMoney(Player player, double amount) {
        if (!this.economyEnabled) {
            return false;
        }
        switch (this.economyType.toLowerCase()) {
            case "vault": {
                if (this.vaultEconomy != null) {
                    return this.vaultEconomy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
                }
                return false;
            }
        }
        return false;
    }

    public boolean depositMoney(Player player, double amount) {
        if (!this.economyEnabled) {
            return false;
        }
        switch (this.economyType.toLowerCase()) {
            case "vault": {
                if (this.vaultEconomy != null) {
                    return this.vaultEconomy.depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
                }
                return false;
            }
        }
        return false;
    }

    public String formatMoney(double amount) {
        return String.format("%.2f %s", amount, this.currencySymbol);
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getEconomyType() {
        return this.economyType;
    }
}

