/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrUltimateShop plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.checkAndAddMissingChestShopMessages();
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.checkAndAddMissingChestShopMessages();
    }

    private void checkAndAddMissingChestShopMessages() {
        boolean messagesChanged = false;
        if (!this.messagesConfig.contains("Chest-Shop")) {
            this.plugin.getLogger().info("Adding missing Chest-Shop messages section...");
            this.addDefaultChestShopMessages();
            messagesChanged = true;
        } else {
            String[] requiredMessages;
            ConfigurationSection chestShopSection = this.messagesConfig.getConfigurationSection("Chest-Shop");
            for (String messagePath : requiredMessages = new String[]{"disabled", "create-start", "create-item-required", "create-look-at-allowed", "create-no-economy", "create-not-enough-money", "create-transaction-failed", "create-success", "create-already-exists", "buy-price-disabled", "sell-price-disabled", "buy-price-enabled", "sell-price-enabled", "enter-buy-price", "enter-sell-price", "invalid-price", "price-updated", "limit-reached", "break-not-owner", "help-header", "help-create", "help-give", "help-team", "give-usage", "give-success-self", "give-success-other", "give-received", "team-help-header", "team-help-invite", "team-help-remove", "team-help-list", "team-invite-usage", "team-remove-usage", "team-look-at-shop", "team-not-owner", "team-cannot-invite-self", "team-invalid-role", "team-invite-success", "team-invited", "team-remove-success", "team-removed", "team-not-member", "team-no-access", "team-list-header", "team-list-owner", "team-list-member", "team-enter-add-shop", "team-enter-add-global", "team-enter-remove-shop", "team-enter-remove-global", "team-enter-role", "team-shop-invite-success", "team-shop-invited", "team-shop-remove-success", "team-shop-removed", "team-global-invite-success", "team-global-invited", "team-global-remove-success", "team-global-removed", "team-global-remove-usage", "team-nobody", "team-limit-reached"}) {
                if (chestShopSection.contains(messagePath)) continue;
                this.plugin.getLogger().info("Adding missing Chest-Shop message: " + messagePath);
                this.addMissingChestShopMessage(chestShopSection, messagePath);
                messagesChanged = true;
            }
        }
        if (messagesChanged) {
            this.saveMessages();
            this.plugin.getLogger().info("ChestShop messages updated successfully!");
        }
    }

    private void addDefaultChestShopMessages() {
        ConfigurationSection chestShop = this.messagesConfig.createSection("Chest-Shop");
        chestShop.set("disabled", (Object)"{Prefix}&cChest-Shops are disabled.");
        chestShop.set("create-start", (Object)"{Prefix}&fLook at allowed block and hold item to create.");
        chestShop.set("create-item-required", (Object)"{Prefix}&cHold an item in your main hand!");
        chestShop.set("create-look-at-allowed", (Object)"{Prefix}&cLook at an allowed block and try again!");
        chestShop.set("create-no-economy", (Object)"{Prefix}&cEconomy is not enabled!");
        chestShop.set("create-not-enough-money", (Object)"{Prefix}&cYou don't have enough money!");
        chestShop.set("create-transaction-failed", (Object)"{Prefix}&cPayment failed!");
        chestShop.set("create-success", (Object)"{Prefix}&aShop created!");
        chestShop.set("create-already-exists", (Object)"{Prefix}&cA shop already exists at this block!");
        chestShop.set("buy-price-disabled", (Object)"{Prefix}&eBuy price disabled.");
        chestShop.set("sell-price-disabled", (Object)"{Prefix}&eSell price disabled.");
        chestShop.set("buy-price-enabled", (Object)"{Prefix}&aBuy price enabled (set a value).");
        chestShop.set("sell-price-enabled", (Object)"{Prefix}&aSell price enabled (set a value).");
        chestShop.set("enter-buy-price", (Object)"{Prefix}&fEnter new buy price in chat:");
        chestShop.set("enter-sell-price", (Object)"{Prefix}&fEnter new sell price in chat:");
        chestShop.set("invalid-price", (Object)"{Prefix}&cInvalid price!");
        chestShop.set("price-updated", (Object)"{Prefix}&aPrice updated.");
        chestShop.set("limit-reached", (Object)"{Prefix}&cYou have reached your shop limit!");
        chestShop.set("break-not-owner", (Object)"{Prefix}&cOnly the owner can break this shop!");
        chestShop.set("help-header", (Object)"{Prefix}&aChest Shop Commands:");
        chestShop.set("help-create", (Object)"&e/cshop create &f- Create a new chest shop");
        chestShop.set("help-give", (Object)"&e/cshop give shop [player] &f- Give shop item");
        chestShop.set("help-team", (Object)"&e/cshop team &f- Manage shop team members");
        chestShop.set("give-usage", (Object)"{Prefix}&cUsage: /cshop give shop [player]");
        chestShop.set("give-success-self", (Object)"{Prefix}&aYou received a shop item!");
        chestShop.set("give-success-other", (Object)"{Prefix}&aGave shop item to [player]!");
        chestShop.set("give-received", (Object)"{Prefix}&aYou received a shop item from [player]!");
        chestShop.set("team-help-header", (Object)"{Prefix}&aTeam Commands:");
        chestShop.set("team-help-invite", (Object)"&e/cshop team invite <player> <Editor|Supplementer> &f- Invite team member");
        chestShop.set("team-help-remove", (Object)"&e/cshop team remove <player> &f- Remove team member");
        chestShop.set("team-help-list", (Object)"&e/cshop team list &f- List team members");
        chestShop.set("team-invite-usage", (Object)"{Prefix}&cUsage: /cshop team invite <player> <Editor|Supplementer>");
        chestShop.set("team-remove-usage", (Object)"{Prefix}&cUsage: /cshop team remove <player>");
        chestShop.set("team-look-at-shop", (Object)"{Prefix}&cLook at your chest shop!");
        chestShop.set("team-not-owner", (Object)"{Prefix}&cYou must be the owner to manage team members!");
        chestShop.set("team-cannot-invite-self", (Object)"{Prefix}&cYou cannot invite yourself!");
        chestShop.set("team-invalid-role", (Object)"{Prefix}&cInvalid role! Use 'Editor' or 'Supplementer'");
        chestShop.set("team-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to your shop!");
        chestShop.set("team-invited", (Object)"{Prefix}&aYou have been added to [owner]'s shop as [role]!");
        chestShop.set("team-remove-success", (Object)"{Prefix}&aRemoved [player] from your shop!");
        chestShop.set("team-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s shop!");
        chestShop.set("team-not-member", (Object)"{Prefix}&c[player] is not a team member!");
        chestShop.set("team-no-access", (Object)"{Prefix}&cYou don't have access to this shop!");
        chestShop.set("team-list-header", (Object)"{Prefix}&aShop Team Members:");
        chestShop.set("team-list-owner", (Object)"&e[player] &7(Owner)");
        chestShop.set("team-list-member", (Object)"&a[player] &7([role])");
        chestShop.set("team-enter-add-shop", (Object)"{Prefix}&fEnter player name to add to THIS shop:");
        chestShop.set("team-enter-add-global", (Object)"{Prefix}&fEnter player name to add to ALL shops:");
        chestShop.set("team-enter-remove-shop", (Object)"{Prefix}&fEnter player name to remove from THIS shop:");
        chestShop.set("team-enter-remove-global", (Object)"{Prefix}&fEnter player name to remove from ALL shops:");
        chestShop.set("team-enter-role", (Object)"{Prefix}&fEnter role (Editor/Supplementer):");
        chestShop.set("team-shop-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to THIS shop!");
        chestShop.set("team-shop-invited", (Object)"{Prefix}&aYou have been added to [owner]'s shop as [role]!");
        chestShop.set("team-shop-remove-success", (Object)"{Prefix}&aRemoved [player] from THIS shop!");
        chestShop.set("team-shop-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s shop!");
        chestShop.set("team-global-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to ALL your shops!");
        chestShop.set("team-global-invited", (Object)"{Prefix}&aYou have been added to [owner]'s ALL shops as [role]!");
        chestShop.set("team-global-remove-success", (Object)"{Prefix}&aRemoved [player] from ALL your shops!");
        chestShop.set("team-global-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s ALL shops!");
        chestShop.set("team-global-remove-usage", (Object)"{Prefix}&cUsage: /cshop team remove <player>");
        chestShop.set("team-nobody", (Object)"Nobody");
        chestShop.set("team-limit-reached", (Object)"{Prefix}&cThis shop already has the maximum number of team members (4)!");
    }

    private void addMissingChestShopMessage(ConfigurationSection chestShopSection, String messagePath) {
        switch (messagePath) {
            case "disabled": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cChest-Shops are disabled.");
                break;
            }
            case "create-start": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&fLook at allowed block and hold item to create.");
                break;
            }
            case "create-item-required": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cHold an item in your main hand!");
                break;
            }
            case "create-look-at-allowed": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cLook at an allowed block and try again!");
                break;
            }
            case "create-no-economy": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cEconomy is not enabled!");
                break;
            }
            case "create-not-enough-money": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough money!");
                break;
            }
            case "create-transaction-failed": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cPayment failed!");
                break;
            }
            case "create-success": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aShop created!");
                break;
            }
            case "create-already-exists": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cA shop already exists at this block!");
                break;
            }
            case "team-limit-reached": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cThis shop already has the maximum number of team members (4)!");
                break;
            }
            default: {
                chestShopSection.set(messagePath, (Object)("{Prefix}&eMissing message: " + messagePath));
            }
        }
    }

    public void saveMessages() {
        if (this.messagesConfig == null || this.messagesFile == null) {
            return;
        }
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "&cZpr\u00e1va nenalezena: " + path;
        }
        String prefix = this.messagesConfig.getString("MrUltimateShop.Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return ColorSystem.colorize(message);
    }

    public String getMessage(String path, String defaultMessage) {
        String message = this.messagesConfig.getString(path, defaultMessage);
        String prefix = this.messagesConfig.getString("MrUltimateShop.Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return ColorSystem.colorize(message);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

