/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.integration.MrCommunityQuestIntegration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class StatisticsManager {
    private final MrUltimateShop plugin;
    private final File statisticsFile;
    private YamlConfiguration statisticsConfig;
    private final Map<UUID, PlayerStatistics> playerStatisticsCache;

    public StatisticsManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.statisticsFile = new File(plugin.getDataFolder(), "statistics.yml");
        this.playerStatisticsCache = new HashMap<UUID, PlayerStatistics>();
        this.loadStatistics();
    }

    private void loadStatistics() {
        if (!this.statisticsFile.exists()) {
            this.statisticsConfig = new YamlConfiguration();
            return;
        }
        try {
            this.statisticsConfig = YamlConfiguration.loadConfiguration((File)this.statisticsFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not load statistics.yml: " + e.getMessage());
            this.statisticsConfig = new YamlConfiguration();
        }
    }

    public void saveStatistics() {
        try {
            this.statisticsConfig.save(this.statisticsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save statistics.yml: " + e.getMessage());
        }
    }

    public void recordPurchase(Player player, ItemStack item, int quantity, double price) {
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        PlayerStatistics stats = this.getPlayerStatistics(playerId);
        stats.totalItemsPurchased += (long)quantity;
        stats.totalMoneySpent += price;
        String itemKey = this.getItemKey(item);
        stats.itemPurchaseCount.put(itemKey, stats.itemPurchaseCount.getOrDefault(itemKey, 0L) + (long)quantity);
        stats.itemMoneySpent.put(itemKey, stats.itemMoneySpent.getOrDefault(itemKey, 0.0) + price);
        String playerPath = "players." + playerId.toString();
        this.statisticsConfig.set(playerPath + ".name", (Object)playerName);
        this.statisticsConfig.set(playerPath + ".total-items-purchased", (Object)stats.totalItemsPurchased);
        this.statisticsConfig.set(playerPath + ".total-money-spent", (Object)stats.totalMoneySpent);
        this.statisticsConfig.set(playerPath + ".items." + itemKey + ".purchased", (Object)stats.itemPurchaseCount.get(itemKey));
        this.statisticsConfig.set(playerPath + ".items." + itemKey + ".money-spent", (Object)stats.itemMoneySpent.get(itemKey));
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveStatistics);
        MrCommunityQuestIntegration integration = MrCommunityQuestIntegration.getInstance(this.plugin);
        this.plugin.getLogger().info("Notifying MrCommunityQuest integration about purchase: Player=" + player.getName() + ", Item=" + this.getItemKey(item) + ", Quantity=" + quantity + ", Price=" + price + ", Integration enabled=" + integration.isEnabled());
        if (integration.isEnabled()) {
            integration.processPurchase(player, item, quantity, price);
        } else {
            this.plugin.getLogger().info("MrCommunityQuest integration is not enabled, skipping purchase notification");
        }
    }

    public void recordSale(Player player, ItemStack item, int quantity, double price) {
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        PlayerStatistics stats = this.getPlayerStatistics(playerId);
        stats.totalItemsSold += (long)quantity;
        stats.totalMoneyEarned += price;
        String itemKey = this.getItemKey(item);
        stats.itemSaleCount.put(itemKey, stats.itemSaleCount.getOrDefault(itemKey, 0L) + (long)quantity);
        stats.itemMoneyEarned.put(itemKey, stats.itemMoneyEarned.getOrDefault(itemKey, 0.0) + price);
        String playerPath = "players." + playerId.toString();
        this.statisticsConfig.set(playerPath + ".name", (Object)playerName);
        this.statisticsConfig.set(playerPath + ".total-items-sold", (Object)stats.totalItemsSold);
        this.statisticsConfig.set(playerPath + ".total-money-earned", (Object)stats.totalMoneyEarned);
        this.statisticsConfig.set(playerPath + ".items." + itemKey + ".sold", (Object)stats.itemSaleCount.get(itemKey));
        this.statisticsConfig.set(playerPath + ".items." + itemKey + ".money-earned", (Object)stats.itemMoneyEarned.get(itemKey));
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveStatistics);
        MrCommunityQuestIntegration integration = MrCommunityQuestIntegration.getInstance(this.plugin);
        this.plugin.getLogger().info("Notifying MrCommunityQuest integration about sale: Player=" + player.getName() + ", Item=" + this.getItemKey(item) + ", Quantity=" + quantity + ", Price=" + price + ", Integration enabled=" + integration.isEnabled());
        if (integration.isEnabled()) {
            integration.processSale(player, item, quantity, price);
        } else {
            this.plugin.getLogger().info("MrCommunityQuest integration is not enabled, skipping sale notification");
        }
    }

    private String getItemKey(ItemStack item) {
        if (item == null) {
            return "null";
        }
        return item.getType().name();
    }

    private PlayerStatistics getPlayerStatistics(UUID playerId) {
        return this.playerStatisticsCache.computeIfAbsent(playerId, this::loadPlayerStatistics);
    }

    private PlayerStatistics loadPlayerStatistics(UUID playerId) {
        String playerPath = "players." + playerId.toString();
        PlayerStatistics stats = new PlayerStatistics();
        stats.totalItemsPurchased = this.statisticsConfig.getLong(playerPath + ".total-items-purchased", 0L);
        stats.totalItemsSold = this.statisticsConfig.getLong(playerPath + ".total-items-sold", 0L);
        stats.totalMoneySpent = this.statisticsConfig.getDouble(playerPath + ".total-money-spent", 0.0);
        stats.totalMoneyEarned = this.statisticsConfig.getDouble(playerPath + ".total-money-earned", 0.0);
        if (this.statisticsConfig.contains(playerPath + ".items")) {
            for (String itemKey : this.statisticsConfig.getConfigurationSection(playerPath + ".items").getKeys(false)) {
                stats.itemPurchaseCount.put(itemKey, this.statisticsConfig.getLong(playerPath + ".items." + itemKey + ".purchased", 0L));
                stats.itemSaleCount.put(itemKey, this.statisticsConfig.getLong(playerPath + ".items." + itemKey + ".sold", 0L));
                stats.itemMoneySpent.put(itemKey, this.statisticsConfig.getDouble(playerPath + ".items." + itemKey + ".money-spent", 0.0));
                stats.itemMoneyEarned.put(itemKey, this.statisticsConfig.getDouble(playerPath + ".items." + itemKey + ".money-earned", 0.0));
            }
        }
        return stats;
    }

    public long getPlayerTotalPurchasedItems(Player player) {
        return this.getPlayerStatistics((UUID)player.getUniqueId()).totalItemsPurchased;
    }

    public long getPlayerTotalSoldItems(Player player) {
        return this.getPlayerStatistics((UUID)player.getUniqueId()).totalItemsSold;
    }

    public long getPlayerItemPurchaseCount(Player player, ItemStack item) {
        String itemKey = this.getItemKey(item);
        return this.getPlayerStatistics((UUID)player.getUniqueId()).itemPurchaseCount.getOrDefault(itemKey, 0L);
    }

    public long getPlayerItemSaleCount(Player player, ItemStack item) {
        String itemKey = this.getItemKey(item);
        return this.getPlayerStatistics((UUID)player.getUniqueId()).itemSaleCount.getOrDefault(itemKey, 0L);
    }

    public double getPlayerTotalEarnings(Player player) {
        return this.getPlayerStatistics((UUID)player.getUniqueId()).totalMoneyEarned;
    }

    public double getPlayerTotalSpending(Player player) {
        return this.getPlayerStatistics((UUID)player.getUniqueId()).totalMoneySpent;
    }

    public double getPlayerItemEarnings(Player player, ItemStack item) {
        String itemKey = this.getItemKey(item);
        return this.getPlayerStatistics((UUID)player.getUniqueId()).itemMoneyEarned.getOrDefault(itemKey, 0.0);
    }

    public double getPlayerItemSpending(Player player, ItemStack item) {
        String itemKey = this.getItemKey(item);
        return this.getPlayerStatistics((UUID)player.getUniqueId()).itemMoneySpent.getOrDefault(itemKey, 0.0);
    }

    private static class PlayerStatistics {
        public long totalItemsPurchased = 0L;
        public long totalItemsSold = 0L;
        public double totalMoneySpent = 0.0;
        public double totalMoneyEarned = 0.0;
        public final Map<String, Long> itemPurchaseCount = new HashMap<String, Long>();
        public final Map<String, Long> itemSaleCount = new HashMap<String, Long>();
        public final Map<String, Double> itemMoneySpent = new HashMap<String, Double>();
        public final Map<String, Double> itemMoneyEarned = new HashMap<String, Double>();

        private PlayerStatistics() {
        }
    }
}

