/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldManager {
    private final MrUltimateShop plugin;

    public WorldManager(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public boolean isShopEnabledInWorld(Player player) {
        return this.isShopEnabledInWorld(player.getWorld());
    }

    public boolean isShopEnabledInWorld(World world) {
        if (this.plugin.getConfig().getBoolean("World-Settings.enabled-everywhere", true)) {
            return true;
        }
        String worldName = world.getName();
        String configPath = "World-Settings." + worldName + ".enabled";
        return this.plugin.getConfig().getBoolean(configPath, true);
    }

    public void setShopEnabledInWorld(String worldName, boolean enabled) {
        String configPath = "World-Settings." + worldName + ".enabled";
        this.plugin.getConfig().set(configPath, (Object)enabled);
        this.plugin.saveConfig();
    }

    public void setShopEnabledEverywhere(boolean enabled) {
        this.plugin.getConfig().set("World-Settings.enabled-everywhere", (Object)enabled);
        this.plugin.saveConfig();
    }
}

