/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop.hologram;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class HologramManager {
    private final MrUltimateShop plugin;
    private final Map<String, List<ArmorStand>> hologramsByKey;
    private final Map<String, List<ArmorStand>> previewByKey;
    private int rotateTaskId = -1;

    public HologramManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.hologramsByKey = new HashMap<String, List<ArmorStand>>();
        this.previewByKey = new HashMap<String, List<ArmorStand>>();
        this.rotateTaskId = -1;
    }

    public void showLines(String key, Location base, List<String> lines) {
        this.remove(key);
        if (base == null || base.getWorld() == null) {
            return;
        }
        World world = base.getWorld();
        double y = (double)base.getBlockY() + 1.5;
        double x = (double)base.getBlockX() + 0.5;
        double z = (double)base.getBlockZ() + 0.5;
        ArrayList<ArmorStand> list = new ArrayList<ArmorStand>();
        for (int i = 0; i < lines.size(); ++i) {
            String raw = lines.get(i);
            if (raw == null || raw.trim().isEmpty()) continue;
            String text = ColorSystem.colorize(raw);
            Location lineLoc = new Location(world, x, y + (double)(lines.size() - i - 1) * 0.25, z);
            ArmorStand as = (ArmorStand)world.spawnEntity(lineLoc, EntityType.ARMOR_STAND);
            as.setMarker(true);
            as.setInvisible(true);
            as.setSmall(true);
            as.setGravity(false);
            as.setCustomName(ColorSystem.colorize(text));
            as.setCustomNameVisible(true);
            as.setMetadata("mrus_holo", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            list.add(as);
        }
        this.hologramsByKey.put(key, list);
    }

    public static List<String> applyPlaceholders(List<String> lines, Map<String, String> placeholders) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String l;
            String t = l = iterator.next();
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                t = t.replace(e.getKey(), e.getValue());
            }
            result.add(t);
        }
        return result;
    }

    public void remove(String key) {
        List<ArmorStand> prev;
        List<ArmorStand> list = this.hologramsByKey.remove(key);
        if (list != null) {
            for (ArmorStand as : list) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
        if ((prev = this.previewByKey.remove(key)) != null) {
            for (ArmorStand as : prev) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrus_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                as.remove();
            }
        }
        if (this.previewByKey.isEmpty() && this.rotateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.rotateTaskId);
            this.rotateTaskId = -1;
        }
    }

    public void removeAll() {
        for (String string : new ArrayList<String>(this.hologramsByKey.keySet())) {
            this.remove(string);
        }
        for (List list : this.previewByKey.values()) {
            if (list == null) continue;
            for (ArmorStand as : list) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrus_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                as.remove();
            }
        }
        this.previewByKey.clear();
        if (this.rotateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.rotateTaskId);
            this.rotateTaskId = -1;
        }
    }

    public boolean has(String key) {
        return this.hologramsByKey.containsKey(key);
    }

    public void removeLines(String key) {
        List<ArmorStand> list = this.hologramsByKey.remove(key);
        if (list == null) {
            return;
        }
        for (ArmorStand as : list) {
            if (as == null || as.isDead()) continue;
            if (as.hasMetadata("mrus_dropped_item")) {
                try {
                    Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                    if (droppedItem != null && !droppedItem.isDead()) {
                        droppedItem.remove();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            as.remove();
        }
    }

    public void showItemPreview(String key, Location base, ItemStack item, double yOffset) {
        List<ArmorStand> prev = this.previewByKey.remove(key);
        if (prev != null) {
            for (ArmorStand as : prev) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
        if (base == null || base.getWorld() == null || item == null) {
            return;
        }
        World world = base.getWorld();
        ArrayList<ArmorStand> previewList = new ArrayList<ArmorStand>();
        boolean enableGlassPreview = this.plugin.getConfigManager().getConfig().getBoolean("ChestShops.Shops.Enable-Glass-Item-Preview", true);
        if (enableGlassPreview) {
            Location glassLoc = new Location(world, (double)base.getBlockX() + 0.5, (double)base.getBlockY() + yOffset, (double)base.getBlockZ() + 0.5);
            ArmorStand glassAs = (ArmorStand)world.spawnEntity(glassLoc, EntityType.ARMOR_STAND);
            glassAs.setMarker(true);
            glassAs.setInvisible(true);
            glassAs.setSmall(false);
            glassAs.setGravity(false);
            glassAs.setCustomNameVisible(false);
            glassAs.setArms(false);
            if (glassAs.getEquipment() != null) {
                glassAs.getEquipment().setItemInMainHand(null);
                glassAs.getEquipment().setItemInOffHand(null);
                ItemStack glassBlock = new ItemStack(Material.GLASS);
                glassAs.getEquipment().setHelmet(glassBlock);
            }
            glassAs.setMetadata("mrus_glass", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            previewList.add(glassAs);
        }
        double itemYOffset = yOffset + 1.5;
        itemYOffset = enableGlassPreview ? (itemYOffset -= 0.15) : (itemYOffset += 0.25);
        Location itemLoc = new Location(world, (double)base.getBlockX() + 0.5, (double)base.getBlockY() + itemYOffset, (double)base.getBlockZ() + 0.5);
        ArmorStand holderAs = (ArmorStand)world.spawnEntity(itemLoc, EntityType.ARMOR_STAND);
        holderAs.setMarker(true);
        holderAs.setInvisible(true);
        holderAs.setSmall(true);
        holderAs.setGravity(false);
        holderAs.setCustomNameVisible(false);
        holderAs.setArms(false);
        holderAs.setMetadata("mrus_item_holder", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        ItemStack previewItem = item.clone();
        previewItem.setAmount(1);
        ItemMeta meta = previewItem.getItemMeta();
        if (meta != null) {
            NamespacedKey previewKey = new NamespacedKey((Plugin)this.plugin, "preview_item");
            meta.getPersistentDataContainer().set(previewKey, PersistentDataType.BYTE, (Object)1);
            previewItem.setItemMeta(meta);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (holderAs != null && !holderAs.isDead()) {
                Item droppedItem = world.dropItem(itemLoc, previewItem);
                droppedItem.setPickupDelay(Integer.MAX_VALUE);
                droppedItem.setVelocity(new Vector(0, 0, 0));
                droppedItem.setGravity(false);
                droppedItem.setInvulnerable(true);
                droppedItem.setMetadata("mrus_preview_item", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                holderAs.setMetadata("mrus_dropped_item", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)droppedItem));
            }
        });
        previewList.add(holderAs);
        this.previewByKey.put(key, previewList);
        if (this.rotateTaskId == -1) {
            this.rotateTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                for (List<ArmorStand> list : this.previewByKey.values()) {
                    if (list == null || list.isEmpty()) continue;
                    for (ArmorStand as : list) {
                        if (as == null || as.isDead() || !as.hasMetadata("mrus_item_holder") || !as.hasMetadata("mrus_dropped_item")) continue;
                        try {
                            Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                            if (droppedItem == null || droppedItem.isDead()) continue;
                            Location currentLoc = droppedItem.getLocation();
                            double floatOffset = Math.sin((double)System.currentTimeMillis() * 0.002) * 0.03;
                            Location newLoc = new Location(currentLoc.getWorld(), (double)base.getBlockX() + 0.5, as.getLocation().getY() + floatOffset, (double)base.getBlockZ() + 0.5, currentLoc.getYaw() + 3.0f, currentLoc.getPitch());
                            droppedItem.teleport(newLoc);
                        }
                        catch (Exception exception) {}
                    }
                }
            }, 1L, 1L);
        }
    }

    private boolean isHeadWearable(Material material) {
        return material.name().endsWith("_HELMET") || material == Material.PLAYER_HEAD || material == Material.DRAGON_HEAD || material == Material.ZOMBIE_HEAD || material == Material.SKELETON_SKULL || material == Material.WITHER_SKELETON_SKULL || material == Material.CREEPER_HEAD || material == Material.CARVED_PUMPKIN;
    }

    private boolean canDisplayOnHead(Material material) {
        if (material.name().contains("SWORD") || material.name().contains("AXE") || material.name().contains("PICKAXE") || material.name().contains("SHOVEL") || material.name().contains("HOE") || material.name().contains("BOW") || material.name().contains("CROSSBOW") || material.name().contains("TRIDENT") || material.name().contains("STICK") || material.name().contains("ROD") || material == Material.BLAZE_ROD || material == Material.BONE || material == Material.ARROW || material == Material.SPECTRAL_ARROW || material == Material.TIPPED_ARROW) {
            return false;
        }
        if (this.isHeadWearable(material) || material.name().contains("HELMET") || material.name().contains("HEAD") || material.name().contains("SKULL")) {
            return true;
        }
        if (material.isBlock() || material.name().contains("SPAWN") || material.name().contains("EGG") || material.name().contains("FOOD") || material.name().contains("APPLE") || material.name().contains("BREAD") || material.name().contains("MEAT") || material == Material.PAPER || material == Material.BOOK || material == Material.ENCHANTED_BOOK) {
            return true;
        }
        return true;
    }

    public void cleanupAllDroppedItems() {
        for (List<ArmorStand> previewList : this.previewByKey.values()) {
            if (previewList == null) continue;
            for (ArmorStand as : previewList) {
                if (as == null || as.isDead() || !as.hasMetadata("mrus_dropped_item")) continue;
                try {
                    Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                    if (droppedItem == null || droppedItem.isDead()) continue;
                    droppedItem.remove();
                }
                catch (Exception exception) {}
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Item item : world.getEntitiesByClass(Item.class)) {
                if (!item.hasMetadata("mrus_preview_item")) continue;
                item.remove();
            }
        }
    }
}

