/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.util.Arrays;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final MrUltimateShop plugin;
    private FileConfiguration config;

    public ConfigManager(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.checkAndAddMissingChestShopConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.checkAndAddMissingChestShopConfig();
    }

    private void checkAndAddMissingChestShopConfig() {
        boolean configChanged = false;
        if (!this.config.contains("ChestShops")) {
            this.plugin.getLogger().info("Adding missing ChestShops configuration section...");
            this.addDefaultChestShopConfig();
            configChanged = true;
        } else {
            ConfigurationSection chestShopsSection = this.config.getConfigurationSection("ChestShops");
            if (!chestShopsSection.contains("Enabled")) {
                chestShopsSection.set("Enabled", (Object)true);
                configChanged = true;
            }
            if (!chestShopsSection.contains("Holograms")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Holograms configuration...");
                this.addDefaultHologramConfig(chestShopsSection);
                configChanged = true;
            }
            if (!chestShopsSection.contains("Shops")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Shops configuration...");
                this.addDefaultShopsConfig(chestShopsSection);
                configChanged = true;
            } else {
                ConfigurationSection shopsSection = chestShopsSection.getConfigurationSection("Shops");
                if (shopsSection != null && !shopsSection.contains("Min-Distance-Between-Shops")) {
                    this.plugin.getLogger().info("Adding missing ChestShops.Shops.Min-Distance-Between-Shops configuration...");
                    shopsSection.set("Min-Distance-Between-Shops", (Object)2);
                    configChanged = true;
                }
            }
            if (!chestShopsSection.contains("Shop-Item")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Shop-Item configuration...");
                this.addDefaultShopItemConfig(chestShopsSection);
                configChanged = true;
            }
            if (!chestShopsSection.contains("Allowed-Blocks")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Allowed-Blocks configuration...");
                this.addDefaultAllowedBlocksConfig(chestShopsSection);
                configChanged = true;
            }
            if (!chestShopsSection.contains("Commands")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Commands configuration...");
                this.addDefaultCommandsConfig(chestShopsSection);
                configChanged = true;
            }
            if (!chestShopsSection.contains("Menu")) {
                this.plugin.getLogger().info("Adding missing ChestShops.Menu configuration...");
                this.addDefaultMenuConfig(chestShopsSection);
                configChanged = true;
            }
        }
        if (configChanged) {
            this.plugin.saveConfig();
            this.plugin.getLogger().info("ChestShop configuration updated successfully!");
        }
    }

    private void addDefaultChestShopConfig() {
        ConfigurationSection chestShops = this.config.createSection("ChestShops");
        chestShops.set("Enabled", (Object)true);
        this.addDefaultHologramConfig(chestShops);
        this.addDefaultShopsConfig(chestShops);
        this.addDefaultShopItemConfig(chestShops);
        this.addDefaultAllowedBlocksConfig(chestShops);
        this.addDefaultCommandsConfig(chestShops);
        this.addDefaultMenuConfig(chestShops);
    }

    private void addDefaultHologramConfig(ConfigurationSection parent) {
        ConfigurationSection holograms = parent.createSection("Holograms");
        holograms.set("Hologram-Provider", (Object)"CMIHolograms");
        holograms.set("Hologram-Update-Interval", (Object)20);
        holograms.set("Enable-View-Hologram-Only-When-Looking", (Object)true);
        holograms.set("Hologram-Lore", Arrays.asList("{#FF58DF>}&lMrUltimateShop{#FF58C4<}", "&f\u1d04\u029c\u1d07\ua731\u1d1b-\ua731\u029c\u1d0f\u1d18", "", "&fOwner: {#FF58DF}[PlayerName]", "&fItem: {#FF58DF}[Items]", "&fAvaible to buy {#FF58DF}[AvaibleBuy] &8| &fAvaible to sell {#FF58DF}[AvaibleSell]", "&fPrice: {#FF58DF}[Price] &8| &fSell-Price: {#FF58DF}[Sell-Price]", "&f", "{#FF58DF}Right-Click &8| &fTo open chest shop."));
    }

    private void addDefaultShopsConfig(ConfigurationSection parent) {
        ConfigurationSection shops = parent.createSection("Shops");
        shops.set("Size", (Object)54);
        shops.set("Enable-Glass-Item-Preview", (Object)true);
        shops.set("Glass-Preview-Y-Offset", (Object)0.8);
        shops.set("Min-Distance-Between-Shops", (Object)2);
        shops.set("Enable-Limit", (Object)true);
        ConfigurationSection taxes = shops.createSection("Taxes");
        taxes.set("Enabled", (Object)true);
        taxes.set("Tax", (Object)35);
    }

    private void addDefaultShopItemConfig(ConfigurationSection parent) {
        ConfigurationSection shopItem = parent.createSection("Shop-Item");
        shopItem.set("Name", (Object)"{#FF58DF>}&lShop Item{#FF58C4<}");
        shopItem.set("Lore", Arrays.asList("", "{#FF58DF}Place &8| &fTo create shop!"));
    }

    private void addDefaultAllowedBlocksConfig(ConfigurationSection parent) {
        parent.set("Allowed-Blocks", Arrays.asList("CHEST", "END_PORTAL", "BARREL", "SHULKER_BOX"));
    }

    private void addDefaultCommandsConfig(ConfigurationSection parent) {
        ConfigurationSection commands = parent.createSection("Commands");
        ConfigurationSection create = commands.createSection("Create");
        create.set("enabled", (Object)true);
        create.set("Price-Per-Success-Command", (Object)100.0);
    }

    private void addDefaultMenuConfig(ConfigurationSection parent) {
        ConfigurationSection menu = parent.createSection("Menu");
        ConfigurationSection shopInventory = menu.createSection("ShopInventory");
        shopInventory.set("Name", (Object)"{#FF58DF>}&lCHEST-SHOP{#FF58C4<} &8| &fInventory");
        ConfigurationSection playerOverview = menu.createSection("PlayerOverview");
        playerOverview.set("Name", (Object)"{#FF58DF>}&lCHEST-SHOP{#FF58C4<} &8| &fShop Owner [PlayerName]");
        playerOverview.set("Size", (Object)54);
        playerOverview.set("Trade-Item-Slot", (Object)22);
        ConfigurationSection decorations = playerOverview.createSection("Decorations");
        ConfigurationSection deco1 = decorations.createSection("1");
        deco1.set("Material", (Object)"BLACK_STAINED_GLASS_PANE");
        deco1.set("Name", (Object)" ");
        deco1.set("Slots", (Object)"1,2,3,4,5,6,7,9,17,18,26,27,35,36,44,46,47,48,49,50,51,52");
        deco1.set("Glowing", (Object)false);
        ConfigurationSection deco2 = decorations.createSection("2");
        deco2.set("Material", (Object)"IRON_BARS");
        deco2.set("Name", (Object)" ");
        deco2.set("Slots", (Object)"0,8,45,53");
        deco2.set("Glowing", (Object)false);
        this.addDefaultPlayerOverviewItems(playerOverview);
        this.addDefaultOwnerShopMenu(menu);
    }

    private void addDefaultPlayerOverviewItems(ConfigurationSection parent) {
        ConfigurationSection item;
        int i;
        ConfigurationSection items = parent.createSection("Items");
        String[] addAmounts = new String[]{"1", "16", "32"};
        String[] removeAmounts = new String[]{"1", "16", "32"};
        int[] addSlots = new int[]{28, 29, 30};
        int[] removeSlots = new int[]{32, 33, 34};
        for (i = 0; i < addAmounts.length; ++i) {
            item = items.createSection(String.valueOf(i + 1));
            item.set("Material", (Object)"LIME_STAINED_GLASS_PANE");
            item.set("Name", (Object)("{#5CFF58}&lAdd " + addAmounts[i] + "x"));
            item.set("Lore", Arrays.asList("{#FF58DF}Left-Click &8| &fAdd quantity " + addAmounts[i]));
            item.set("Action", (Object)"ADD_QUANTITY");
            item.set("Amount", (Object)Integer.parseInt(addAmounts[i]));
            item.set("slot", (Object)addSlots[i]);
        }
        for (i = 0; i < removeAmounts.length; ++i) {
            item = items.createSection(String.valueOf(i + 4));
            item.set("Material", (Object)"RED_STAINED_GLASS_PANE");
            item.set("Name", (Object)("{#FF5858}&lRemove " + removeAmounts[i] + "x"));
            item.set("Lore", Arrays.asList("{#FF58DF}Left-Click &8| &fRemove quantity " + removeAmounts[i]));
            item.set("Action", (Object)"REMOVE_QUANTITY");
            item.set("Amount", (Object)Integer.parseInt(removeAmounts[i]));
            item.set("slot", (Object)removeSlots[i]);
        }
        ConfigurationSection modeToggle = items.createSection("7");
        modeToggle.set("Material", (Object)"SUNFLOWER");
        modeToggle.set("Name", (Object)"{#FF58DF}&lMode: &f[Mode]");
        modeToggle.set("Lore", Arrays.asList("{#FF58DF}Left-Click &8| &fSwitch between &aBuying&f/&cSelling", "{#FF58DF}Current quantity: &f[Quantity]", "{#FF58DF}Price/piece: &f[Price]"));
        modeToggle.set("Action", (Object)"TOGGLE_MODE");
        modeToggle.set("slot", (Object)24);
        ConfigurationSection execute = items.createSection("8");
        execute.set("Material", (Object)"EMERALD");
        execute.set("Name", (Object)"{#5CFF58}&l[Mode] &f[Quantity]x");
        execute.set("Lore", Arrays.asList("{#FF58DF}Left-Click &8| &fExecute [Mode]", "{#FF58DF}Total price: &f[TotalPrice]", "{#FF58DF}Quantity: &f[Quantity]x"));
        execute.set("Action", (Object)"EXECUTE_TRADE");
        execute.set("slot", (Object)40);
    }

    private void addDefaultOwnerShopMenu(ConfigurationSection parent) {
        ConfigurationSection ownerShop = parent.createSection("OwnerShop");
        ownerShop.set("Name", (Object)"{#FF58DF>}&lCHEST-SHOP{#FF58C4<} &8| &fSettings Menu");
        ownerShop.set("Size", (Object)54);
        ConfigurationSection decorations = ownerShop.createSection("Decorations");
        ConfigurationSection deco1 = decorations.createSection("1");
        deco1.set("Material", (Object)"BLACK_STAINED_GLASS_PANE");
        deco1.set("Name", (Object)" ");
        deco1.set("Slots", (Object)"1,2,3,4,5,6,7,9,17,18,26,27,35,36,44,46,47,48,49,50,51,52");
        deco1.set("Glowing", (Object)false);
        ConfigurationSection deco2 = decorations.createSection("2");
        deco2.set("Material", (Object)"IRON_BARS");
        deco2.set("Name", (Object)" ");
        deco2.set("Slots", (Object)"0,8,45,53");
        deco2.set("Glowing", (Object)false);
        ConfigurationSection items = ownerShop.createSection("Items");
        ConfigurationSection setItem = items.createSection("1");
        setItem.set("Material", (Object)"ITEM_FRAME");
        setItem.set("Name", (Object)"{#FF58DF}&lSet item");
        setItem.set("Lore", Arrays.asList("{#FF58DF}Hold item in hand and click."));
        setItem.set("Action", (Object)"SET_ITEM");
        setItem.set("slot", (Object)20);
        ConfigurationSection setBuyPrice = items.createSection("2");
        setBuyPrice.set("Material", (Object)"EMERALD");
        setBuyPrice.set("Name", (Object)"{#5CFF58}&lSet buy price");
        setBuyPrice.set("Lore", Arrays.asList("{#FF58DF}Current: &f[Buy-Price] per piece", "{#FF58DF}Click to enter new price"));
        setBuyPrice.set("Action", (Object)"SET_BUY_PRICE");
        setBuyPrice.set("slot", (Object)22);
        ConfigurationSection setSellPrice = items.createSection("3");
        setSellPrice.set("Material", (Object)"REDSTONE");
        setSellPrice.set("Name", (Object)"{#FF5858}&lSet sell price");
        setSellPrice.set("Lore", Arrays.asList("{#FF58DF}Current: &f[Sell-Price] per piece", "{#FF58DF}Click to enter new price"));
        setSellPrice.set("Action", (Object)"SET_SELL_PRICE");
        setSellPrice.set("slot", (Object)24);
        ConfigurationSection openInventory = items.createSection("4");
        openInventory.set("Material", (Object)"CHEST");
        openInventory.set("Name", (Object)"{#FF58DF}&lOpen shop inventory");
        openInventory.set("Lore", Arrays.asList("{#FF58DF}Click to open inventory"));
        openInventory.set("Action", (Object)"OPEN_SHOP_INVENTORY");
        openInventory.set("slot", (Object)40);
        ConfigurationSection teamManagement = items.createSection("5");
        teamManagement.set("Material", (Object)"PLAYER_HEAD");
        teamManagement.set("Name", (Object)"{#58DFFF}&lTeam Management");
        teamManagement.set("Lore", Arrays.asList("&7Current team members:", "[TeamMembers]", "&7Limit: [TeamCount]/4 shop members", "", "{#FF58DF}Left-Click &8| &fAdd member to THIS shop", "{#FF58DF}Right-Click &8| &fRemove member from THIS shop", "{#FF58DF}SHIFT+Left &8| &fAdd member to ALL shops", "{#FF58DF}SHIFT+Right &8| &fRemove member from ALL shops"));
        teamManagement.set("Action", (Object)"TEAM_MANAGEMENT");
        teamManagement.set("slot", (Object)42);
    }

    public String getPrefix() {
        return this.config.getString("MrUltimateShop.Prefix", "&a[MrUltimateShop]&f ");
    }

    public String getMessage() {
        return this.config.getString("MrUltimateShop.Zprava", "V\u00fdchoz\u00ed zpr\u00e1va");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

