/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI;
import eu.mrneznamy.mrultimateshop.managers.BuySellMenuManager;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MenuManager
implements Listener {
    private final MrUltimateShop plugin;
    private FileConfiguration menuConfig;
    private final Map<String, FileConfiguration> shopConfigs;
    private final Map<String, Inventory> loadedMenus;
    private final Map<String, Integer> playerCurrentPages;
    private final Map<String, Integer> shopTotalPages;
    private final Map<String, String> playerCurrentShop;
    private BuySellMenuManager buySellMenuManager;

    public MenuManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.shopConfigs = new HashMap<String, FileConfiguration>();
        this.loadedMenus = new HashMap<String, Inventory>();
        this.playerCurrentPages = new HashMap<String, Integer>();
        this.shopTotalPages = new HashMap<String, Integer>();
        this.playerCurrentShop = new HashMap<String, String>();
        this.buySellMenuManager = new BuySellMenuManager(plugin);
        this.loadMenus();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void loadMenus() {
        this.loadMainMenu();
        this.loadShops();
    }

    private void loadMainMenu() {
        File menuFile = new File(this.plugin.getDataFolder(), "menu.yml");
        if (!menuFile.exists()) {
            return;
        }
        this.menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
        this.createMainMenuInventory();
    }

    private void loadShops() {
        File shopsFolder = new File(this.plugin.getDataFolder(), "Shops");
        if (!shopsFolder.exists() || !shopsFolder.isDirectory()) {
            return;
        }
        File[] shopFiles = shopsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (shopFiles == null) {
            return;
        }
        for (File shopFile : shopFiles) {
            String shopName = shopFile.getName().replace(".yml", "");
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)shopFile);
                this.shopConfigs.put(shopName, (FileConfiguration)config);
                this.createShopInventory(shopName, (FileConfiguration)config);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createMainMenuInventory() {
        ConfigurationSection itemsSection;
        ConfigurationSection menuSection = this.menuConfig.getConfigurationSection("Menu");
        if (menuSection == null) {
            return;
        }
        String title = ColorSystem.colorize(menuSection.getString("Name", "&6Shop Menu"));
        int size = menuSection.getInt("Size", 54);
        Inventory mainMenu = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("Decorations");
        if (decorationsSection != null) {
            for (String key : decorationsSection.getKeys(false)) {
                String[] slotStrings;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(key);
                if (decorationSection == null) continue;
                Material material = Material.valueOf((String)decorationSection.getString("Material", "GRAY_STAINED_GLASS_PANE"));
                ItemStack decoration = new ItemStack(material);
                ItemMeta decorationMeta = decoration.getItemMeta();
                decorationMeta.setDisplayName(ColorSystem.colorize(decorationSection.getString("Name", " ")));
                decoration.setItemMeta(decorationMeta);
                String slotsString = decorationSection.getString("Slots", "");
                if (slotsString.isEmpty()) continue;
                for (String slotString : slotStrings = slotsString.split(",")) {
                    try {
                        int slot = Integer.parseInt(slotString.trim());
                        if (slot < 0 || slot >= size) continue;
                        mainMenu.setItem(slot, decoration);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((itemsSection = menuSection.getConfigurationSection("Items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                ItemStack item;
                int slot;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                if (itemSection.contains("slot")) {
                    slot = itemSection.getInt("slot");
                } else {
                    try {
                        slot = Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = this.createMenuItem(itemSection)) == null || slot < 0 || slot >= size) continue;
                mainMenu.setItem(slot, item);
            }
        }
        this.loadedMenus.put("main", mainMenu);
    }

    private void createShopInventory(String shopName, FileConfiguration config) {
        ConfigurationSection shopSection = config.getConfigurationSection("Shop");
        if (shopSection == null) {
            return;
        }
        int maxPage = this.calculateMaxPage(shopSection);
        this.shopTotalPages.put(shopName, maxPage);
    }

    private int calculateMaxPage(ConfigurationSection shopSection) {
        int maxPage = 1;
        ConfigurationSection itemsSection = shopSection.getConfigurationSection("Items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                int page;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null || (page = itemSection.getInt("page", 1)) <= maxPage) continue;
                maxPage = page;
            }
        }
        return maxPage;
    }

    private Inventory createShopInventoryForPage(String shopName, FileConfiguration config, int currentPage) {
        ConfigurationSection itemsSection;
        ConfigurationSection shopSection = config.getConfigurationSection("Shop");
        if (shopSection == null) {
            return null;
        }
        String titleTemplate = shopSection.getString("Name", "&6Shop");
        int totalPages = this.shopTotalPages.getOrDefault(shopName, 1);
        String title = ColorSystem.colorize(titleTemplate.replace("[CurrentPage]", String.valueOf(currentPage)).replace("[TotalPages]", String.valueOf(totalPages)));
        int size = shopSection.getInt("Size", 54);
        Inventory shopInventory = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection decorationsSection = shopSection.getConfigurationSection("Decorations");
        if (decorationsSection != null) {
            for (String key : decorationsSection.getKeys(false)) {
                String[] slotStrings;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(key);
                if (decorationSection == null) continue;
                Material material = Material.valueOf((String)decorationSection.getString("Material", "GRAY_STAINED_GLASS_PANE"));
                ItemStack decoration = new ItemStack(material);
                ItemMeta decorationMeta = decoration.getItemMeta();
                decorationMeta.setDisplayName(ColorSystem.colorize(decorationSection.getString("Name", " ")));
                decoration.setItemMeta(decorationMeta);
                String slotsString = decorationSection.getString("Slots", "");
                if (slotsString.isEmpty()) continue;
                for (String slotString : slotStrings = slotsString.split(",")) {
                    try {
                        int slot = Integer.parseInt(slotString.trim());
                        if (slot < 0 || slot >= size) continue;
                        shopInventory.setItem(slot, decoration);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((itemsSection = shopSection.getConfigurationSection("Items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                ItemStack item;
                int slot;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                int itemPage = itemSection.getInt("page", 1);
                String pageValue = itemSection.getString("page", "1");
                String action = itemSection.getString("Action", "");
                boolean shouldDisplay = false;
                if ("all".equals(pageValue)) {
                    shouldDisplay = true;
                } else if (itemPage == currentPage) {
                    shouldDisplay = true;
                } else if ("PREVIOUS_PAGE".equals(action) && currentPage > 1) {
                    shouldDisplay = true;
                } else if ("NEXT_PAGE".equals(action) && currentPage < totalPages) {
                    shouldDisplay = true;
                }
                if (!shouldDisplay) continue;
                if (itemSection.contains("slot")) {
                    slot = itemSection.getInt("slot");
                } else {
                    try {
                        slot = Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = this.createShopItem(itemSection)) == null || slot < 0 || slot >= size) continue;
                shopInventory.setItem(slot, item);
            }
        }
        this.addNavigationButtons(shopInventory, shopName, currentPage, totalPages, size);
        return shopInventory;
    }

    private void addNavigationButtons(Inventory inventory, String shopName, int currentPage, int totalPages, int size) {
        ConfigurationSection itemsSection;
        FileConfiguration shopConfig = this.shopConfigs.get(shopName);
        if (shopConfig != null && (itemsSection = shopConfig.getConfigurationSection("Items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                ItemStack item;
                int slot;
                String action;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null || !(action = itemSection.getString("Action", "")).equals("OPEN_MENU") && !action.equals("CLOSE_MENU")) continue;
                if (itemSection.contains("slot")) {
                    slot = itemSection.getInt("slot");
                } else {
                    try {
                        slot = Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = this.createShopItem(itemSection)) == null || slot < 0 || slot >= size) continue;
                inventory.setItem(slot, item);
            }
        }
    }

    private ItemStack createMenuItem(ConfigurationSection section) {
        Material material;
        String itemName;
        String pluginName;
        Object customItem;
        String[] parts;
        String materialString = section.getString("Material", "STONE");
        if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2 && (customItem = MrUltimateShopAPI.getCustomItem(pluginName = parts[0], itemName = parts[1])) != null) {
            ItemStack clonedItem = customItem.clone();
            boolean enableCustomItemLore = section.getBoolean("EnableCustomItemLore", false);
            ItemMeta meta = clonedItem.getItemMeta();
            if (meta != null) {
                List<String> shopLore;
                if ((!enableCustomItemLore || section.contains("Name")) && section.contains("Name")) {
                    int quantity = section.getInt("quantity", 1);
                    String name = ColorSystem.colorize(section.getString("Name", "&fItem")).replace("[quantity]", String.valueOf(quantity));
                    meta.setDisplayName(name);
                }
                ArrayList<String> finalLore = new ArrayList<String>();
                if (enableCustomItemLore && !section.contains("Lore") && meta.hasLore()) {
                    finalLore.addAll(meta.getLore());
                }
                if (section.contains("Lore")) {
                    for (String line : section.getStringList("Lore")) {
                        finalLore.add(ColorSystem.colorize(line));
                    }
                }
                if ((shopLore = this.generateItemLore(section)) != null && !shopLore.isEmpty()) {
                    finalLore.addAll(shopLore);
                }
                meta.setLore(finalLore);
                clonedItem.setItemMeta(meta);
            }
            return clonedItem;
        }
        try {
            material = Material.valueOf((String)materialString);
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        String name = !materialString.equals(material.name()) ? "\u00a7c[ERROR] Invalid material: " + materialString : ColorSystem.colorize(section.getString("Name", "&fItem"));
        ArrayList<String> lore = new ArrayList<String>();
        if (!materialString.equals(material.name())) {
            lore.add("\u00a7c[ERROR] Invalid material: " + materialString);
            lore.add("\u00a77Using STONE as fallback");
        }
        for (String line : section.getStringList("Lore")) {
            lore.add(ColorSystem.colorize(line));
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createShopItem(ConfigurationSection section) {
        int quantity;
        ItemStack item;
        ItemMeta meta;
        List<String> shopLore;
        String name;
        Material material;
        String itemName;
        String pluginName;
        Object customItem;
        String[] parts;
        String materialString = section.getString("Material", "STONE");
        if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2 && (customItem = MrUltimateShopAPI.getCustomItem(pluginName = parts[0], itemName = parts[1])) != null) {
            ItemStack clonedItem = customItem.clone();
            int quantity2 = section.getInt("quantity", 1);
            clonedItem.setAmount(quantity2);
            boolean enableCustomItemLore = section.getBoolean("EnableCustomItemLore", false);
            ItemMeta meta2 = clonedItem.getItemMeta();
            if (meta2 != null) {
                List<String> shopLore2;
                if ((!enableCustomItemLore || section.contains("Name")) && section.contains("Name")) {
                    String name2 = ColorSystem.colorize(section.getString("Name", "&fItem")).replace("[quantity]", String.valueOf(quantity2));
                    meta2.setDisplayName(name2);
                }
                ArrayList<String> finalLore = new ArrayList<String>();
                if (enableCustomItemLore && !section.contains("Lore") && meta2.hasLore()) {
                    finalLore.addAll(meta2.getLore());
                }
                if (section.contains("Lore")) {
                    for (String line : section.getStringList("Lore")) {
                        finalLore.add(ColorSystem.colorize(line));
                    }
                }
                if ((shopLore2 = this.generateItemLore(section)) != null && !shopLore2.isEmpty()) {
                    finalLore.addAll(shopLore2);
                }
                meta2.setLore(finalLore);
                clonedItem.setItemMeta(meta2);
            }
            return clonedItem;
        }
        try {
            material = Material.valueOf((String)materialString);
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        if (section.contains("Name")) {
            int quantity3 = section.getInt("quantity", 1);
            name = ColorSystem.colorize(section.getString("Name")).replace("[quantity]", String.valueOf(quantity3));
        } else {
            name = !materialString.equals(material.name()) ? "\u00a7c[ERROR] Invalid material: " + materialString : this.formatMaterialName(material.name());
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (section.contains("Lore")) {
            for (String line : section.getStringList("Lore")) {
                lore.add(ColorSystem.colorize(line));
            }
        }
        if ((shopLore = this.generateItemLore(section)) != null && !shopLore.isEmpty()) {
            lore.addAll(shopLore);
        }
        if (!materialString.equals(material.name())) {
            if (lore == null) {
                lore = new ArrayList();
            }
            lore.add(0, "\u00a7c[ERROR] Invalid material: " + materialString);
            lore.add(1, "\u00a77Using STONE as fallback");
        }
        if ((meta = (item = new ItemStack(material, quantity = section.getInt("quantity", 1))).getItemMeta()) != null) {
            if (section.contains("Name") || !materialString.equals(material.name())) {
                meta.setDisplayName(name);
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    private List<String> generateItemLore(ConfigurationSection section) {
        String templateKey;
        ArrayList<String> lore = new ArrayList<String>();
        boolean buyEnabled = section.contains("Buy.Price") && section.getBoolean("Buy.Enable", true);
        boolean sellEnabled = section.contains("Sell.Price") && section.getBoolean("Sell.Enable", true);
        double buyPrice = section.getDouble("Buy.Price", 0.0);
        double sellPrice = section.getDouble("Sell.Price", 0.0);
        String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            return lore;
        }
        YamlConfiguration messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        if (buyEnabled && sellEnabled) {
            templateKey = "Shop-Item-Lore.classic";
        } else if (buyEnabled) {
            templateKey = "Shop-Item-Lore.onlybuy";
        } else if (sellEnabled) {
            templateKey = "Shop-Item-Lore.onlysell";
        } else {
            return lore;
        }
        List template = messagesConfig.getStringList(templateKey);
        for (String line : template) {
            line = line.replace("[BuyPrice]", buyPrice + " " + currencySymbol);
            line = line.replace("[SellPrice]", sellPrice + " " + currencySymbol);
            lore.add(ColorSystem.colorize(line));
        }
        return lore;
    }

    public void openMainMenu(Player player) {
        this.playerCurrentShop.remove(player.getName());
        Inventory mainMenu = this.loadedMenus.get("main");
        if (mainMenu != null) {
            player.openInventory(mainMenu);
        } else {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.main-menu-error", "&cError opening main menu!")));
        }
    }

    public void openShop(Player player, String shopName) {
        this.openShop(player, shopName, 1);
    }

    public void openShop(Player player, String shopName, int page) {
        if (!this.shopExists(shopName)) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.shop-not-found", "&cShop '" + shopName + "' not found!")));
            return;
        }
        FileConfiguration config = this.shopConfigs.get(shopName);
        if (config == null) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.shop-not-loaded", "&cShop '" + shopName + "' is not properly loaded!")));
            return;
        }
        int totalPages = this.shopTotalPages.getOrDefault(shopName, 1);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        this.playerCurrentPages.put(player.getName() + ":" + shopName, page);
        this.playerCurrentShop.put(player.getName(), shopName);
        Inventory shop = this.createShopInventoryForPage(shopName, config, page);
        if (shop != null) {
            player.openInventory(shop);
        } else {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.shop-not-loaded", "&cShop '" + shopName + "' is not properly loaded!")));
        }
    }

    private void handleMainMenuClick(Player player, int slot) {
        if (this.menuConfig == null) {
            return;
        }
        ConfigurationSection itemsSection = this.menuConfig.getConfigurationSection("Menu.Items");
        if (itemsSection == null) {
            return;
        }
        ConfigurationSection itemSection = null;
        for (String key : itemsSection.getKeys(false)) {
            int itemSlot;
            ConfigurationSection section = itemsSection.getConfigurationSection(key);
            if (section == null) continue;
            if (section.contains("slot")) {
                itemSlot = section.getInt("slot");
            } else {
                try {
                    itemSlot = Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (itemSlot != slot) continue;
            itemSection = section;
            break;
        }
        if (itemSection != null) {
            String action = itemSection.getString("Action");
            if ("OPEN_MENU".equals(action)) {
                String shopName = itemSection.getString("Menu");
                if (shopName != null) {
                    this.openShop(player, shopName);
                }
            } else if ("CLOSE_MENU".equals(action)) {
                player.closeInventory();
            }
        }
    }

    private void handleShopClick(Player player, int slot, String title, ClickType clickType) {
        String shopName = this.playerCurrentShop.get(player.getName());
        if (shopName == null || "main".equals(shopName)) {
            return;
        }
        FileConfiguration shopConfig = this.shopConfigs.get(shopName);
        if (shopConfig == null) {
            return;
        }
        ConfigurationSection itemsSection = shopConfig.getConfigurationSection("Shop.Items");
        if (itemsSection == null) {
            return;
        }
        String playerKey = player.getName() + ":" + shopName;
        int currentPage = this.playerCurrentPages.getOrDefault(playerKey, 1);
        for (Object key : itemsSection.getKeys(false)) {
            int itemSlot;
            ConfigurationSection section = itemsSection.getConfigurationSection((String)key);
            if (section == null) continue;
            if (section.contains("slot")) {
                itemSlot = section.getInt("slot");
            } else {
                try {
                    itemSlot = Integer.parseInt((String)key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (itemSlot != slot) continue;
            String action = section.getString("Action");
            if ("PREVIOUS_PAGE".equals(action)) {
                if (currentPage > 1) {
                    this.openShop(player, shopName, currentPage - 1);
                }
                return;
            }
            if (!"NEXT_PAGE".equals(action)) break;
            int totalPages = this.shopTotalPages.getOrDefault(shopName, 1);
            if (currentPage < totalPages) {
                this.openShop(player, shopName, currentPage + 1);
            }
            return;
        }
        ConfigurationSection itemSection = null;
        for (String key : itemsSection.getKeys(false)) {
            int itemSlot;
            ConfigurationSection section = itemsSection.getConfigurationSection(key);
            if (section == null) continue;
            if (section.contains("slot")) {
                itemSlot = section.getInt("slot");
            } else {
                try {
                    itemSlot = Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            int itemPage = section.getInt("page", 1);
            if (itemSlot != slot || itemPage != currentPage) continue;
            itemSection = section;
            break;
        }
        if (itemSection == null) {
            return;
        }
        String action = itemSection.getString("Action");
        if ("OPEN_MENU".equals(action)) {
            String menuName = itemSection.getString("Menu");
            if ("main".equals(menuName)) {
                this.openMainMenu(player);
            } else if (menuName != null) {
                this.openShop(player, menuName);
            }
        } else if ("CLOSE_MENU".equals(action)) {
            player.closeInventory();
        } else if (clickType == ClickType.LEFT) {
            if (itemSection.contains("Buy.Price")) {
                this.buySellMenuManager.openBuySellMenu(player, itemSection, shopName, "Buy");
            } else {
                player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.item-cannot-buy", "&cThis item cannot be purchased!")));
            }
        } else if (clickType == ClickType.RIGHT) {
            if (itemSection.contains("Sell.Price")) {
                this.buySellMenuManager.openBuySellMenu(player, itemSection, shopName, "Sell");
            } else {
                player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.item-cannot-sell", "&cThis item cannot be sold!")));
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String cleanTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        boolean isOurMenu = false;
        boolean isMainMenu = false;
        String detectedShop = null;
        if (this.loadedMenus.containsKey("main") && this.loadedMenus.get("main").equals((Object)event.getInventory())) {
            isOurMenu = true;
            isMainMenu = true;
        } else if (title != null && !title.trim().isEmpty() && (cleanTitle = ChatColor.stripColor((String)title)).trim().length() >= 3) {
            for (String shopName : this.shopConfigs.keySet()) {
                FileConfiguration shopConfig = this.shopConfigs.get(shopName);
                ConfigurationSection shopSection = shopConfig.getConfigurationSection("Shop");
                if (shopSection == null) continue;
                String shopTitleTemplate = shopSection.getString("Name", "&6Shop");
                int totalPages = this.shopTotalPages.getOrDefault(shopName, 1);
                boolean foundMatch = false;
                for (int page = 1; page <= totalPages; ++page) {
                    String titleWithPlaceholders = shopTitleTemplate.replace("[CurrentPage]", String.valueOf(page)).replace("[TotalPages]", String.valueOf(totalPages));
                    String cleanShopTitle = ChatColor.stripColor((String)ColorSystem.colorize(titleWithPlaceholders));
                    if (!cleanTitle.equals(cleanShopTitle)) continue;
                    isOurMenu = true;
                    detectedShop = shopName;
                    this.playerCurrentShop.put(player.getName(), shopName);
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                String cleanShopTitle = ChatColor.stripColor((String)ColorSystem.colorize(shopTitleTemplate));
                if ((cleanShopTitle = cleanShopTitle.replace("[CurrentPage]", "").replace("[TotalPages]", "").trim()).length() < 3 || cleanTitle.length() < 3 || !cleanTitle.contains(cleanShopTitle) && !cleanShopTitle.contains(cleanTitle)) continue;
                isOurMenu = true;
                detectedShop = shopName;
                this.playerCurrentShop.put(player.getName(), shopName);
                break;
            }
        }
        if (!isOurMenu) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (isMainMenu) {
            this.handleMainMenuClick(player, slot);
        } else {
            this.handleShopClick(player, slot, title, event.getClick());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String currentShop = this.playerCurrentShop.get(player.getName());
        if (currentShop != null) {
            this.playerCurrentShop.remove(player.getName());
        }
    }

    public void reloadMenus() {
        this.loadedMenus.clear();
        this.shopConfigs.clear();
        this.loadMenus();
    }

    public BuySellMenuManager getBuySellMenuManager() {
        return this.buySellMenuManager;
    }

    public Set<String> getAvailableShops() {
        return this.shopConfigs.keySet();
    }

    public boolean shopExists(String shopName) {
        return this.shopConfigs.containsKey(shopName);
    }

    public Map<String, FileConfiguration> getShopConfigs() {
        return this.shopConfigs;
    }
}

