/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop;

import eu.mrneznamy.mrlibcore.MrLibRegisterPlugin;
import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.holograms.MrLibHologramManager;
import eu.mrneznamy.mrlibcore.messages.MrLibMessage;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopCommand;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import eu.mrneznamy.mrultimateshop.commands.MusCommand;
import eu.mrneznamy.mrultimateshop.commands.ShopCommand;
import eu.mrneznamy.mrultimateshop.database.ShopDatabaseManager;
import eu.mrneznamy.mrultimateshop.integration.HeadDatabaseIntegration;
import eu.mrneznamy.mrultimateshop.integration.ItemsAdderIntegration;
import eu.mrneznamy.mrultimateshop.integration.OraxenIntegration;
import eu.mrneznamy.mrultimateshop.managers.BuySellMenuManager;
import eu.mrneznamy.mrultimateshop.managers.ConfigManager;
import eu.mrneznamy.mrultimateshop.managers.DemandTrackerManager;
import eu.mrneznamy.mrultimateshop.managers.FeatureManager;
import eu.mrneznamy.mrultimateshop.managers.LogManager;
import eu.mrneznamy.mrultimateshop.managers.MenuManager;
import eu.mrneznamy.mrultimateshop.managers.MessageManager;
import eu.mrneznamy.mrultimateshop.managers.SellGuiManager;
import eu.mrneznamy.mrultimateshop.managers.StatisticsManager;
import eu.mrneznamy.mrultimateshop.managers.WorldManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrUltimateShop
extends JavaPlugin {
    private static MrUltimateShop instance;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private MrLibMessage messageSystem;
    private MenuManager menuManager;
    private SellGuiManager sellGuiManager;
    private StatisticsManager statisticsManager;
    private DemandTrackerManager demandTrackerManager;
    private ShopDatabaseManager databaseManager;
    private LogManager logManager;
    private WorldManager worldManager;
    private FeatureManager featureManager;
    private ChestShopManager chestShopManager;

    public void onEnable() {
        instance = this;
        if (this.getServer().getPluginManager().getPlugin("MrLibCore") == null) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("MrUltimateShop requires MrLibCore to run!");
            this.getLogger().severe("Please download MrLibCore from:");
            this.getLogger().severe("https://modrinth.com/plugin/mrlibcore");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.messageSystem = new MrLibMessage((JavaPlugin)this);
        this.databaseManager = new ShopDatabaseManager(this);
        this.statisticsManager = new StatisticsManager(this);
        this.demandTrackerManager = new DemandTrackerManager(this);
        this.logManager = new LogManager(this);
        this.worldManager = new WorldManager(this);
        this.featureManager = new FeatureManager(this);
        this.loadConfiguration();
        this.chestShopManager = new ChestShopManager(this);
        this.chestShopManager.loadShopsFromDisk();
        this.menuManager = new MenuManager(this);
        this.sellGuiManager = new SellGuiManager(this);
        this.registerCommands();
        if (this.demandTrackerManager != null) {
            this.demandTrackerManager.scheduleAutoSave();
            this.demandTrackerManager.schedulePriceDecay();
        }
        MrUltimateShopAPI.initialize(this);
        this.registerCustomItemIntegrations();
        MrLibRegisterPlugin.register((JavaPlugin)this, (String)"mrultimateshop");
        String hologramProvider = "MrLibCore-TextDisplay";
        MrLibHologramManager hologramManager = MrLibHologramManager.getInstance();
        if (!hologramManager.setProvider(hologramProvider)) {
            MrLibConsoleSayer.MrSay_Warning((String)"Failed to set TextDisplay provider, using default");
        } else {
            MrLibConsoleSayer.MrSay_Success((String)("Hologram Provider: " + hologramProvider));
        }
        this.registerHelpCommands();
        MrLibConsoleSayer.MrSay_Success((String)"MrUltimateShop enabled!");
    }

    private void registerHelpCommands() {
        ArrayList<MrLibHelper.CommandInfo> commands = new ArrayList<MrLibHelper.CommandInfo>();
        commands.add(new MrLibHelper.CommandInfo("/shop", "Open the main shop menu", "/shop"));
        commands.add(new MrLibHelper.CommandInfo("/mus reload", "Reload plugin configuration", "/mus reload"));
        commands.add(new MrLibHelper.CommandInfo("/mus help [plugin] [page]", "Show help for registered plugins", "/mus help MrUltimateShop 1"));
        commands.add(new MrLibHelper.CommandInfo("/cshop create", "Create a new chest shop", "/cshop create"));
        MrLibHelper.registerPluginCommands((JavaPlugin)this, (String)"MrUltimateShop", commands);
        ArrayList<MrLibHelper.CommandInfo> chestShopCommands = new ArrayList<MrLibHelper.CommandInfo>();
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop create", "Create a new chest shop (hold item, look at chest/barrel)", "/cshop create"));
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop give shop [player]", "Give a chest shop item to yourself or another player", "/cshop give shop Player123"));
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop team invite <player> <Editor|Supplementer>", "Invite a player to your shop team (look at your shop first)", "/cshop team invite Player123 Editor"));
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop team remove <player>", "Remove a player from your shop team (look at your shop first)", "/cshop team remove Player123"));
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop team list", "List all team members of a shop (look at the shop first)", "/cshop team list"));
        chestShopCommands.add(new MrLibHelper.CommandInfo("/cshop help [plugin] [page]", "Show help for registered plugins", "/cshop help ChestShop 1"));
        MrLibHelper.registerPluginCommands((JavaPlugin)this, (String)"ChestShop", chestShopCommands);
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String title;
            if (player.getOpenInventory() == null || (title = player.getOpenInventory().getTitle()) == null || !title.contains("MrUltimateShop") && !title.contains("CHEST-SHOP")) continue;
            player.closeInventory();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        if (this.chestShopManager != null) {
            this.chestShopManager.shutdown();
        }
        if (this.statisticsManager != null) {
            this.statisticsManager.saveStatistics();
        }
        if (this.demandTrackerManager != null) {
            this.demandTrackerManager.shutdown();
        }
        MrUltimateShopAPI.clearAllRegistrations();
        MrLibConsoleSayer.MrSay_Info((String)"MrUltimateShop disabled!");
    }

    private void loadConfiguration() {
        this.createDefaultFiles();
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
    }

    private void createDefaultFiles() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.createDefaultShopsIfFirstRun();
    }

    private void createDefaultShopsIfFirstRun() {
        YamlConfiguration dataConfig;
        File dataFile = new File(this.getDataFolder(), "data.yml");
        if (!dataFile.exists()) {
            dataConfig = new YamlConfiguration();
            dataConfig.set("first-run-completed", (Object)false);
            dataConfig.set("default-shops-created", (Object)false);
            try {
                dataConfig.save(dataFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Could not create data.yml: " + e.getMessage());
                return;
            }
        } else {
            dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
        }
        if (!dataConfig.getBoolean("default-shops-created", false)) {
            File shopsFolder = new File(this.getDataFolder(), "Shops");
            if (!shopsFolder.exists()) {
                shopsFolder.mkdirs();
            }
            String[] shopFiles = new String[]{"blocks.yml", "weapons.yml", "food.yml", "redstone.yml", "decorations.yml", "colored_blocks.yml", "tools_weapons.yml", "spawners.yml", "ores.yml", "miscellaneous.yml"};
            dataConfig.set("default-shops-created", (Object)true);
            dataConfig.set("first-run-completed", (Object)true);
            try {
                dataConfig.save(dataFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Could not save data.yml: " + e.getMessage());
            }
        }
    }

    private void registerCommands() {
        MusCommand musCommand = new MusCommand(this);
        ShopCommand shopCommand = new ShopCommand(this);
        this.getCommand("mus").setExecutor((CommandExecutor)musCommand);
        this.getCommand("mus").setTabCompleter((TabCompleter)musCommand);
        this.getCommand("shop").setExecutor((CommandExecutor)shopCommand);
        this.getCommand("shop").setTabCompleter((TabCompleter)shopCommand);
        if (this.chestShopManager != null) {
            ChestShopCommand cshopCommand = new ChestShopCommand(this, this.chestShopManager);
            this.getCommand("cshop").setExecutor((CommandExecutor)cshopCommand);
            this.getCommand("cshop").setTabCompleter((TabCompleter)cshopCommand);
        }
    }

    private void registerCustomItemIntegrations() {
        this.registerItemsAdderIntegration();
        this.registerHeadDatabaseIntegration();
        this.registerOraxenIntegration();
    }

    private void registerItemsAdderIntegration() {
        try {
            if (Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
                ItemsAdderIntegration itemsAdderIntegration = new ItemsAdderIntegration(this);
                boolean registered = MrUltimateShopAPI.registerItemProvider(itemsAdderIntegration);
                if (registered) {
                    MrLibConsoleSayer.MrSay_Success((String)"ItemsAdder integration registered!");
                } else {
                    this.getLogger().warning("Failed to register ItemsAdder integration - provider may already be registered");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error registering ItemsAdder integration: " + e.getMessage());
        }
    }

    private void registerHeadDatabaseIntegration() {
        try {
            if (Bukkit.getPluginManager().getPlugin("HeadDatabase") != null) {
                HeadDatabaseIntegration headDatabaseIntegration = new HeadDatabaseIntegration(this);
                boolean registered = MrUltimateShopAPI.registerItemProvider(headDatabaseIntegration);
                if (registered) {
                    MrLibConsoleSayer.MrSay_Success((String)"HeadDatabase integration registered!");
                } else {
                    this.getLogger().warning("Failed to register HeadDatabase integration - provider may already be registered");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error registering HeadDatabase integration: " + e.getMessage());
        }
    }

    private void registerOraxenIntegration() {
        try {
            if (Bukkit.getPluginManager().getPlugin("Oraxen") != null) {
                OraxenIntegration oraxenIntegration = new OraxenIntegration(this);
                boolean registered = MrUltimateShopAPI.registerItemProvider(oraxenIntegration);
                if (registered) {
                    MrLibConsoleSayer.MrSay_Success((String)"Oraxen integration registered!");
                } else {
                    this.getLogger().warning("Failed to register Oraxen integration - provider may already be registered");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error registering Oraxen integration: " + e.getMessage());
        }
    }

    public void reloadConfiguration() {
        this.configManager.reloadConfig();
        this.messageManager.reloadMessages();
        this.menuManager.reloadMenus();
        this.sellGuiManager.reloadConfiguration();
        this.sellGuiManager.reloadSellAllGui();
        this.getBuySellMenuManager().reloadConfigurations();
        if (this.chestShopManager != null) {
            this.chestShopManager.refreshAllHolograms();
        }
        if (this.demandTrackerManager != null) {
            this.demandTrackerManager.reloadTrackerData();
        }
        this.registerCustomItemIntegrations();
    }

    public static MrUltimateShop getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public MrLibMessage getMessageSystem() {
        return this.messageSystem;
    }

    public void sendMessage(Player player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (message.contains("(!NOPREFIX!)")) {
            message = message.replace("(!NOPREFIX!)", "");
            String prefix = this.getPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                message = message.replace(prefix, "").trim();
            }
        }
        this.messageSystem.send(player, message);
    }

    public String getPrefix() {
        String prefix = this.messageManager.getMessage("MrUltimateShop.Prefix");
        if (prefix != null && !prefix.isEmpty()) {
            return MrLibColors.colorize((String)prefix);
        }
        return MrLibColors.colorize((String)"{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8|");
    }

    public MrLibVaultManager getEconomyManager() {
        return MrLibVaultManager.getInstance();
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public SellGuiManager getSellGuiManager() {
        return this.sellGuiManager;
    }

    public BuySellMenuManager getBuySellMenuManager() {
        return this.menuManager.getBuySellMenuManager();
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public ChestShopManager getChestShopManager() {
        return this.chestShopManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public DemandTrackerManager getDemandTrackerManager() {
        return this.demandTrackerManager;
    }
}

