/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.api;

import eu.mrneznamy.mrultimateshop.api.CustomItemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public class CustomItemRegistry {
    private static final Map<String, CustomItemProvider> providers = new ConcurrentHashMap<String, CustomItemProvider>();
    private static final Map<String, ItemStack> registeredItems = new ConcurrentHashMap<String, ItemStack>();
    private static Logger logger;

    public static void initialize(Logger pluginLogger) {
        logger = pluginLogger;
    }

    public static boolean registerItemProvider(CustomItemProvider provider) {
        if (provider == null) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Attempted to register null provider");
            }
            return false;
        }
        String pluginName = provider.getPluginName();
        if (pluginName == null || pluginName.trim().isEmpty()) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Provider has invalid plugin name: " + pluginName);
            }
            return false;
        }
        if (providers.containsKey(pluginName)) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Plugin '" + pluginName + "' is already registered");
            }
            return false;
        }
        providers.put(pluginName, provider);
        return true;
    }

    public static boolean registerItem(String pluginName, String itemName, ItemStack itemStack) {
        if (pluginName == null || pluginName.trim().isEmpty()) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Invalid plugin name for item registration: " + pluginName);
            }
            return false;
        }
        if (itemName == null || itemName.trim().isEmpty()) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Invalid item name for registration: " + itemName);
            }
            return false;
        }
        if (itemStack == null) {
            if (logger != null) {
                logger.warning("[CustomItemRegistry] Attempted to register null ItemStack for " + pluginName + ":" + itemName);
            }
            return false;
        }
        String fullItemName = pluginName + ":" + itemName;
        registeredItems.put(fullItemName, itemStack.clone());
        if (logger != null) {
            logger.info("[CustomItemRegistry] Successfully registered custom item: " + fullItemName);
        }
        return true;
    }

    @Nullable
    public static ItemStack getCustomItem(String pluginName, String itemName) {
        block6: {
            if (pluginName == null || itemName == null) {
                return null;
            }
            String fullItemName = pluginName + ":" + itemName;
            ItemStack directItem = registeredItems.get(fullItemName);
            if (directItem != null) {
                return directItem.clone();
            }
            CustomItemProvider provider = providers.get(pluginName);
            if (provider != null && provider.isAvailable()) {
                try {
                    ItemStack item = provider.getCustomItem(itemName);
                    if (item != null) {
                        return item.clone();
                    }
                }
                catch (Exception e) {
                    if (logger == null) break block6;
                    logger.warning("[CustomItemRegistry] Error getting item '" + itemName + "' from provider '" + pluginName + "': " + e.getMessage());
                }
            }
        }
        return null;
    }

    public static boolean hasCustomItem(String pluginName, String itemName) {
        block5: {
            if (pluginName == null || itemName == null) {
                return false;
            }
            String fullItemName = pluginName + ":" + itemName;
            if (registeredItems.containsKey(fullItemName)) {
                return true;
            }
            CustomItemProvider provider = providers.get(pluginName);
            if (provider != null && provider.isAvailable()) {
                try {
                    return provider.hasCustomItem(itemName);
                }
                catch (Exception e) {
                    if (logger == null) break block5;
                    logger.warning("[CustomItemRegistry] Error checking item '" + itemName + "' from provider '" + pluginName + "': " + e.getMessage());
                }
            }
        }
        return false;
    }

    public static boolean unregisterItemProvider(String pluginName) {
        if (pluginName == null) {
            return false;
        }
        CustomItemProvider removed = providers.remove(pluginName);
        if (removed != null) {
            if (logger != null) {
                logger.info("[CustomItemRegistry] Unregistered custom item provider: " + pluginName);
            }
            return true;
        }
        return false;
    }

    public static Set<String> getRegisteredPlugins() {
        return providers.keySet();
    }

    public static Set<String> getRegisteredItems() {
        return registeredItems.keySet();
    }

    public static void clearAll() {
        providers.clear();
        registeredItems.clear();
        if (logger != null) {
            logger.info("[CustomItemRegistry] Cleared all custom item registrations");
        }
    }

    public static int getProviderCount() {
        return providers.size();
    }

    public static int getItemCount() {
        return registeredItems.size();
    }
}

