/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChestShopCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateShop plugin;
    private final ChestShopManager manager;

    public ChestShopCommand(MrUltimateShop plugin, ChestShopManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.manager.isEnabled()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-disabled", "{Prefix}&cChest-Shops are disabled."));
            return true;
        }
        if (args.length == 0) {
            MrLibHelper.showPluginHelp((Player)player, (String)"ChestShop", (int)1);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                if (args.length == 1) {
                    MrLibHelper.showRegisteredPlugins((Player)player);
                } else if (args.length == 2) {
                    MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)1);
                } else if (args.length == 3) {
                    try {
                        int page = Integer.parseInt(args[2]);
                        MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)page);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("&cInvalid page number!");
                    }
                }
                return true;
            }
            case "create": {
                return this.handleCreateCommand(player, args);
            }
            case "give": {
                return this.handleGiveCommand(player, args);
            }
            case "team": {
                return this.handleTeamCommand(player, args);
            }
        }
        MrLibHelper.showPluginHelp((Player)player, (String)"ChestShop", (int)1);
        return true;
    }

    private boolean handleCreateCommand(Player player, String[] args) {
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        boolean enabled = cfg.getBoolean("MrUltimateShop.ChestShops.Commands.Create.enabled", true);
        if (!enabled) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-disabled", "{Prefix}&cChest-Shops are disabled."));
            return true;
        }
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand == null || hand.getType() == Material.AIR) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-item-required", "{Prefix}&cHold an item in your main hand!"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.isAllowedBlock(target.getType().name())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-look-at-allowed", "{Prefix}&cLook at an allowed block and try again!"));
            return true;
        }
        if (this.manager.hasShopAt(target.getLocation())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-already-exists", "{Prefix}&cA shop already exists at this block!"));
            return true;
        }
        if (!this.manager.canPlaceShopAt(target.getLocation())) {
            int minDistance = this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Min-Distance-Between-Shops", 2);
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-too-close", "{Prefix}&cShops must be at least " + minDistance + " blocks apart from each other!"));
            return true;
        }
        if (!this.manager.canCreateShop(player)) {
            int limit = this.manager.getShopLimitForPlayer(player);
            int current = this.manager.getPlayerShopCount(player);
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-limit-reached", "{Prefix}&cYou have reached your shop limit! (" + current + "/" + limit + ")"));
            return true;
        }
        double price = cfg.getDouble("MrUltimateShop.ChestShops.Commands.Create.Price-Per-Success-Command", 0.0);
        if (price > 0.0) {
            if (!this.plugin.getEconomyManager().isEnabled()) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-no-economy", "{Prefix}&cEconomy is not enabled!"));
                return true;
            }
            if (!this.plugin.getEconomyManager().hasEnough(player, price)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-not-enough-money", "{Prefix}&cYou don't have enough money!"));
                return true;
            }
            boolean ok = this.plugin.getEconomyManager().withdraw((OfflinePlayer)player, price);
            if (!ok) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-transaction-failed", "{Prefix}&cPayment failed!"));
                return true;
            }
        }
        ChestShop shop = new ChestShop(player.getUniqueId());
        shop.setLocation(target.getLocation());
        shop.setItemForTrade(hand.clone());
        shop.setCreatedWithShopItem(false);
        this.manager.registerShop(shop);
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-create-success", "{Prefix}&aShop created!"));
        return true;
    }

    private boolean handleGiveCommand(Player player, String[] args) {
        if (!player.hasPermission("mrultimateshop.cshop.give")) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("no-permission", "{Prefix}&cYou don't have permission to use this command!"));
            return true;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("shop")) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-give-usage", "{Prefix}&cUsage: /cshop give shop [player]"));
            return true;
        }
        Player target = player;
        if (args.length >= 3 && (target = player.getServer().getPlayerExact(args[2])) == null) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        ItemStack item = this.manager.buildShopItem();
        if (target.getInventory().firstEmpty() == -1) {
            target.getWorld().dropItemNaturally(target.getLocation(), item);
        } else {
            target.getInventory().addItem(new ItemStack[]{item});
        }
        if (target.equals((Object)player)) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-give-success-self", "{Prefix}&aYou received a shop item!"));
        } else {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-give-success-other", "{Prefix}&aGave shop item to [player]!").replace("[player]", target.getName()));
            this.plugin.sendMessage(target, this.plugin.getMessageManager().getMessage("chest-shop-give-received", "{Prefix}&aYou received a shop item from [player]!").replace("[player]", player.getName()));
        }
        return true;
    }

    private boolean handleTeamCommand(Player player, String[] args) {
        String teamSubCommand;
        if (args.length < 2) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-header", "{Prefix}&aTeam Commands:"));
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-invite", "&e/cshop team invite <player> <Editor|Supplementer> &f- Invite team member"));
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-remove", "&e/cshop team remove <player> &f- Remove team member"));
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-list", "&e/cshop team list &f- List team members"));
            return true;
        }
        switch (teamSubCommand = args[1].toLowerCase()) {
            case "invite": {
                return this.handleTeamInvite(player, args);
            }
            case "remove": {
                return this.handleTeamRemove(player, args);
            }
            case "list": {
                return this.handleTeamList(player, args);
            }
        }
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-header", "{Prefix}&aTeam Commands:"));
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-invite", "&e/cshop team invite <player> <Editor|Supplementer> &f- Invite team member"));
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-remove", "&e/cshop team remove <player> &f- Remove team member"));
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-help-list", "&e/cshop team list &f- List team members"));
        return true;
    }

    private boolean handleTeamInvite(Player player, String[] args) {
        ChestShop.TeamRole role;
        if (args.length < 4) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-invite-usage", "{Prefix}&cUsage: /cshop team invite <player> <Editor|Supplementer>"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.isOwner(player.getUniqueId())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-not-owner", "{Prefix}&cYou must be the owner to manage team members!"));
            return true;
        }
        Player invitedPlayer = player.getServer().getPlayerExact(args[2]);
        if (invitedPlayer == null) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        if (invitedPlayer.equals((Object)player)) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-cannot-invite-self", "{Prefix}&cYou cannot invite yourself!"));
            return true;
        }
        String roleString = args[3].toLowerCase();
        if (roleString.equals("editor")) {
            role = ChestShop.TeamRole.EDITOR;
        } else if (roleString.equals("supplementer")) {
            role = ChestShop.TeamRole.SUPPLEMENTER;
        } else {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-invalid-role", "{Prefix}&cInvalid role! Use 'Editor' or 'Supplementer'"));
            return true;
        }
        shop.addTeamMember(invitedPlayer.getUniqueId(), role);
        this.manager.saveShops();
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-invite-success", "{Prefix}&aAdded [player] as [role] to your shop!").replace("[player]", invitedPlayer.getName()).replace("[role]", role.name()));
        this.plugin.sendMessage(invitedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-invited", "{Prefix}&aYou have been added to [owner]'s shop as [role]!").replace("[owner]", player.getName()).replace("[role]", role.name()));
        return true;
    }

    private boolean handleTeamRemove(Player player, String[] args) {
        if (args.length < 3) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-remove-usage", "{Prefix}&cUsage: /cshop team remove <player>"));
            return true;
        }
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.isOwner(player.getUniqueId())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-not-owner", "{Prefix}&cYou must be the owner to manage team members!"));
            return true;
        }
        Player removedPlayer = player.getServer().getPlayerExact(args[2]);
        if (removedPlayer == null) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        if (!shop.isTeamMember(removedPlayer.getUniqueId())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-not-member", "{Prefix}&c[player] is not a team member!").replace("[player]", removedPlayer.getName()));
            return true;
        }
        shop.removeShopSpecificMember(removedPlayer.getUniqueId());
        this.manager.saveShops();
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-remove-success", "{Prefix}&aRemoved [player] from your shop!").replace("[player]", removedPlayer.getName()));
        this.plugin.sendMessage(removedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-removed", "{Prefix}&cYou have been removed from [owner]'s shop!").replace("[owner]", player.getName()));
        return true;
    }

    private boolean handleGlobalTeamRemove(Player player, String[] args) {
        if (args.length < 3) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-global-remove-usage", "{Prefix}&cUsage: /cshop team remove <player>"));
            return true;
        }
        Player removedPlayer = player.getServer().getPlayerExact(args[2]);
        if (removedPlayer == null) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
            return true;
        }
        this.manager.removePlayerFromAllShops(removedPlayer.getUniqueId());
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-global-remove-success", "{Prefix}&aRemoved [player] from ALL your shops!").replace("[player]", removedPlayer.getName()));
        this.plugin.sendMessage(removedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-global-removed", "{Prefix}&cYou have been removed from [owner]'s ALL shops!").replace("[owner]", player.getName()));
        return true;
    }

    private boolean handleTeamList(Player player, String[] args) {
        Block target = player.getTargetBlockExact(6);
        if (target == null || !this.manager.hasShopAt(target.getLocation())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-look-at-shop", "{Prefix}&cLook at your chest shop!"));
            return true;
        }
        ChestShop shop = this.manager.getShopAt(target.getLocation());
        if (!shop.hasAccess(player.getUniqueId())) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-no-access", "{Prefix}&cYou don't have access to this shop!"));
            return true;
        }
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-list-header", "{Prefix}&aShop Team Members:"));
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)shop.getOwnerUuid());
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-list-owner", "&e[player] &7(Owner)").replace("[player]", owner.getName() != null ? owner.getName() : "Unknown"));
        for (Map.Entry<UUID, ChestShop.TeamRole> entry : shop.getTeamMembers().entrySet()) {
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            String roleName = entry.getValue().name().toLowerCase();
            roleName = roleName.substring(0, 1).toUpperCase() + roleName.substring(1);
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-list-member", "&a[player] &7([role])").replace("[player]", member.getName() != null ? member.getName() : "Unknown").replace("[role]", roleName));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("mrultimateshop.cshop.create")) {
                result.add("create");
            }
            if (sender.hasPermission("mrultimateshop.cshop.give")) {
                result.add("give");
            }
            if (sender.hasPermission("mrultimateshop.cshop.team")) {
                result.add("team");
            }
            return result.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("give") && sender.hasPermission("mrultimateshop.cshop.give")) {
                result.add("shop");
            } else if (args[0].equalsIgnoreCase("team") && sender.hasPermission("mrultimateshop.cshop.team")) {
                result.add("invite");
                result.add("remove");
                result.add("list");
            }
            return result.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give") && args[1].equalsIgnoreCase("shop") && sender.hasPermission("mrultimateshop.cshop.give")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    result.add(player.getName());
                }
            } else if (args[0].equalsIgnoreCase("team") && (args[1].equalsIgnoreCase("invite") || args[1].equalsIgnoreCase("remove")) && sender.hasPermission("mrultimateshop.cshop.team")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.equals((Object)sender) || !player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    result.add(player.getName());
                }
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("team") && args[1].equalsIgnoreCase("invite") && sender.hasPermission("mrultimateshop.cshop.team")) {
            if ("editor".startsWith(args[3].toLowerCase())) {
                result.add("Editor");
            }
            if ("supplementer".startsWith(args[3].toLowerCase())) {
                result.add("Supplementer");
            }
        }
        return result;
    }
}

