/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChestShopListener
implements Listener {
    private final ChestShopManager manager;
    private final MrUltimateShop plugin;

    public ChestShopListener(ChestShopManager manager) {
        this.manager = manager;
        this.plugin = MrUltimateShop.getInstance();
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        if (!this.manager.isEnabled()) {
            return;
        }
        ChestShop shop = this.manager.getShopAt(e.getBlock().getLocation());
        if (shop == null) {
            return;
        }
        Player p = e.getPlayer();
        if (!shop.isOwner(p.getUniqueId())) {
            e.setCancelled(true);
            p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-break-not-owner", "{Prefix}&cOnly the owner can break this shop!"));
            return;
        }
        if (shop.getStorageInventory() != null) {
            for (ItemStack is : shop.getStorageInventory().getContents()) {
                if (is == null) continue;
                e.setCancelled(true);
                return;
            }
        }
        this.manager.deleteShopAt(e.getBlock().getLocation());
        this.manager.getLogManager().logShopDestroyed(p, e.getBlock().getLocation());
        if (shop.isCreatedWithShopItem()) {
            ItemStack shopItem = this.manager.buildShopItem();
            if (p.getInventory().firstEmpty() == -1) {
                e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), shopItem);
                p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-break-shop-item-returned", "{Prefix}&aShop destroyed! Shop item returned to your inventory."));
            } else {
                p.getInventory().addItem(new ItemStack[]{shopItem});
                p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-break-shop-item-returned", "{Prefix}&aShop destroyed! Shop item returned to your inventory."));
            }
        } else if (shop.getItemForTrade() != null) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), shop.getItemForTrade().clone());
            p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-break-trade-item-dropped", "{Prefix}&aShop destroyed! Trade item dropped."));
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (!this.manager.isEnabled()) {
            return;
        }
        UUID id = e.getPlayer().getUniqueId();
        ChestShopManager.PendingPrice pending = this.manager.getPendingPrice(id);
        if (pending != null) {
            double val;
            e.setCancelled(true);
            String msg = e.getMessage();
            try {
                val = Double.parseDouble(msg.replace(",", "."));
            }
            catch (Exception ex) {
                e.getPlayer().sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-invalid-price", "{Prefix}&cInvalid price!"));
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)MrUltimateShop.getInstance(), () -> {
                if (pending.type == ChestShopManager.PriceType.BUY) {
                    pending.shop.setBuyPricePerItem(val);
                } else {
                    pending.shop.setSellPricePerItem(val);
                }
                this.manager.saveShops();
                this.manager.refreshHologram(pending.shop);
                e.getPlayer().sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-price-updated", "{Prefix}&aPrice updated."));
                this.manager.clearPendingPrice(id);
            });
            return;
        }
        ChestShopManager.PendingTeamInput teamInput = this.manager.getPendingTeamInput(id);
        if (teamInput != null) {
            e.setCancelled(true);
            String msg = e.getMessage().trim();
            Bukkit.getScheduler().runTask((Plugin)MrUltimateShop.getInstance(), () -> this.handleTeamChatInput(e.getPlayer(), teamInput, msg));
        }
    }

    private void handleTeamChatInput(Player player, ChestShopManager.PendingTeamInput teamInput, String message) {
        switch (teamInput.type) {
            case TEAM_ADD_NAME: {
                Player target = Bukkit.getPlayerExact((String)message);
                if (target == null) {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                if (target.equals((Object)player)) {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-team-cannot-invite-self", "{Prefix}&cYou cannot invite yourself!"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                teamInput.playerName = target.getName();
                this.manager.requestTeamInput(player.getUniqueId(), teamInput.shop, ChestShopManager.ChatInputType.TEAM_ADD_ROLE, teamInput.isGlobalInvite);
                this.manager.getPendingTeamInput((UUID)player.getUniqueId()).playerName = target.getName();
                player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-team-enter-role", "{Prefix}&fEnter role (Editor/Supplementer):"));
                break;
            }
            case TEAM_ADD_ROLE: {
                ChestShop.TeamRole role;
                String roleString = message.toLowerCase();
                if (roleString.equals("editor")) {
                    role = ChestShop.TeamRole.EDITOR;
                } else if (roleString.equals("supplementer")) {
                    role = ChestShop.TeamRole.SUPPLEMENTER;
                } else {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-team-invalid-role", "{Prefix}&cInvalid role! Use 'Editor' or 'Supplementer'"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                Player invitedPlayer = Bukkit.getPlayerExact((String)teamInput.playerName);
                if (invitedPlayer == null) {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                if (!teamInput.isGlobalInvite && !teamInput.shop.canAddMoreTeamMembers()) {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-team-limit-reached", "{Prefix}&cThis shop already has the maximum number of team members (4)!"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                if (teamInput.isGlobalInvite) {
                    this.manager.addPlayerToAllShops(player.getUniqueId(), invitedPlayer.getUniqueId(), role);
                    this.manager.getLogManager().logTeamAction(player, teamInput.shop.getLocation(), "ADD", invitedPlayer.getName(), role.name(), true);
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-global-invite-success", "{Prefix}&aAdded [player] as [role] to ALL your shops!").replace("[player]", invitedPlayer.getName()).replace("[role]", role.name()));
                    this.plugin.sendMessage(invitedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-global-invited", "{Prefix}&aYou have been added to [owner]'s ALL shops as [role]!").replace("[owner]", player.getName()).replace("[role]", role.name()));
                } else {
                    teamInput.shop.addShopSpecificMember(invitedPlayer.getUniqueId(), role);
                    this.manager.getLogManager().logTeamAction(player, teamInput.shop.getLocation(), "ADD", invitedPlayer.getName(), role.name(), false);
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-shop-invite-success", "{Prefix}&aAdded [player] as [role] to THIS shop!").replace("[player]", invitedPlayer.getName()).replace("[role]", role.name()));
                    this.plugin.sendMessage(invitedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-shop-invited", "{Prefix}&aYou have been added to [owner]'s shop as [role]!").replace("[owner]", player.getName()).replace("[role]", role.name()));
                }
                this.manager.saveShops();
                this.manager.clearPendingTeamInput(player.getUniqueId());
                this.manager.openOwnerMenu(player, teamInput.shop);
                break;
            }
            case TEAM_REMOVE_NAME: {
                Player removedPlayer = Bukkit.getPlayerExact((String)message);
                if (removedPlayer == null) {
                    player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("player-not-found", "{Prefix}&cPlayer not found!"));
                    this.manager.clearPendingTeamInput(player.getUniqueId());
                    this.manager.openOwnerMenu(player, teamInput.shop);
                    return;
                }
                if (teamInput.isGlobalInvite) {
                    this.manager.removePlayerFromAllShops(removedPlayer.getUniqueId());
                    this.manager.getLogManager().logTeamAction(player, teamInput.shop.getLocation(), "REMOVE", removedPlayer.getName(), "ALL_ROLES", true);
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-global-remove-success", "{Prefix}&aRemoved [player] from ALL your shops!").replace("[player]", removedPlayer.getName()));
                    this.plugin.sendMessage(removedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-global-removed", "{Prefix}&cYou have been removed from [owner]'s ALL shops!").replace("[owner]", player.getName()));
                } else if (!teamInput.shop.isTeamMember(removedPlayer.getUniqueId())) {
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-not-member", "{Prefix}&c[player] is not a team member!").replace("[player]", removedPlayer.getName()));
                } else {
                    ChestShop.TeamRole removedRole = teamInput.shop.getTeamRole(removedPlayer.getUniqueId());
                    String roleName = removedRole != null ? removedRole.name() : "UNKNOWN";
                    teamInput.shop.removeShopSpecificMember(removedPlayer.getUniqueId());
                    teamInput.shop.removeTeamMember(removedPlayer.getUniqueId());
                    this.manager.getLogManager().logTeamAction(player, teamInput.shop.getLocation(), "REMOVE", removedPlayer.getName(), roleName, false);
                    this.manager.saveShops();
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-team-shop-remove-success", "{Prefix}&aRemoved [player] from THIS shop!").replace("[player]", removedPlayer.getName()));
                    this.plugin.sendMessage(removedPlayer, this.plugin.getMessageManager().getMessage("chest-shop-team-shop-removed", "{Prefix}&cYou have been removed from [owner]'s shop!").replace("[owner]", player.getName()));
                }
                this.manager.clearPendingTeamInput(player.getUniqueId());
                this.manager.openOwnerMenu(player, teamInput.shop);
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!this.manager.isEnabled()) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block b = event.getClickedBlock();
            if (b == null) {
                return;
            }
            ChestShop shop = this.manager.getShopAt(b.getLocation());
            if (shop != null) {
                event.setCancelled(true);
                Player p = event.getPlayer();
                if (!shop.hasAccess(p.getUniqueId())) {
                    this.manager.openPlayerOverview(p, shop);
                    return;
                }
                ChestShop.TeamRole role = shop.getTeamRole(p.getUniqueId());
                if (role == ChestShop.TeamRole.SUPPLEMENTER) {
                    if (p.isSneaking()) {
                        if (shop.getStorageInventory() != null) {
                            p.openInventory(shop.getStorageInventory());
                            this.manager.getLogManager().logInventoryAccess(p, shop.getLocation(), "opened");
                        }
                    } else {
                        this.manager.openPlayerOverview(p, shop);
                    }
                    return;
                }
                if (role == ChestShop.TeamRole.EDITOR) {
                    if (p.isSneaking()) {
                        this.manager.openOwnerMenu(p, shop);
                        this.manager.getLogManager().logEditorAction(p, shop.getLocation(), "opened_settings", "accessed owner menu");
                    } else {
                        this.manager.openPlayerOverview(p, shop);
                    }
                    return;
                }
                if (shop.isOwner(p.getUniqueId())) {
                    this.manager.openOwnerMenu(p, shop);
                } else {
                    this.manager.openPlayerOverview(p, shop);
                }
                return;
            }
            Player p = event.getPlayer();
            ItemStack hand = p.getInventory().getItemInMainHand();
            if (this.manager.isShopItem(hand) && this.manager.isAllowedBlock(b.getType().name()) && !this.manager.hasShopAt(b.getLocation())) {
                if (!this.manager.canCreateShop(p)) {
                    int limit = this.manager.getShopLimitForPlayer(p);
                    int current = this.manager.getPlayerShopCount(p);
                    p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-limit-reached", "{Prefix}&cYou have reached your shop limit! (" + current + "/" + limit + ")"));
                    return;
                }
                if (!this.manager.canPlaceShopAt(b.getLocation())) {
                    int minDistance = MrUltimateShop.getInstance().getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Min-Distance-Between-Shops", 2);
                    p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-create-too-close", "{Prefix}&cShops must be at least " + minDistance + " blocks apart from each other!"));
                    return;
                }
                ChestShop newShop = new ChestShop(p.getUniqueId());
                newShop.setLocation(b.getLocation());
                newShop.setCreatedWithShopItem(true);
                this.manager.registerShop(newShop);
                this.manager.getLogManager().logShopCreated(p, b.getLocation());
                if (hand.getAmount() > 1) {
                    hand.setAmount(hand.getAmount() - 1);
                } else {
                    p.getInventory().setItemInMainHand(null);
                }
                p.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-create-success", "{Prefix}&aShop created!"));
            }
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (!this.manager.isEnabled()) {
            return;
        }
        Block placed = event.getBlockPlaced();
        if (placed == null) {
            return;
        }
        if (this.manager.hasShopAt(placed.getLocation())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack hand = event.getItemInHand();
        if (!this.manager.isAllowedBlock(placed.getType().name())) {
            return;
        }
        Material configuredShopMaterial = Material.matchMaterial((String)MrUltimateShop.getInstance().getConfigManager().getConfig().getString("MrUltimateShop.ChestShops.Shop-Item.Material", "END_PORTAL"));
        boolean isConfiguredShopBlock = configuredShopMaterial != null && placed.getType() == configuredShopMaterial;
        boolean holdingShopItem = this.manager.isShopItem(hand);
        if (holdingShopItem || isConfiguredShopBlock) {
            if (!this.manager.canCreateShop(player)) {
                int limit = this.manager.getShopLimitForPlayer(player);
                int current = this.manager.getPlayerShopCount(player);
                player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-limit-reached", "{Prefix}&cYou have reached your shop limit! (" + current + "/" + limit + ")"));
                event.setCancelled(true);
                return;
            }
            if (!this.manager.canPlaceShopAt(placed.getLocation())) {
                int minDistance = MrUltimateShop.getInstance().getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Min-Distance-Between-Shops", 2);
                player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-create-too-close", "{Prefix}&cShops must be at least " + minDistance + " blocks apart from each other!"));
                event.setCancelled(true);
                return;
            }
            ChestShop shop = new ChestShop(player.getUniqueId());
            shop.setLocation(placed.getLocation());
            shop.setCreatedWithShopItem(true);
            this.manager.registerShop(shop);
            this.manager.getLogManager().logShopCreated(player, placed.getLocation());
            player.sendMessage(MrUltimateShop.getInstance().getMessageManager().getMessage("chest-shop-create-success", "{Prefix}&aShop created!"));
        }
    }

    @EventHandler
    public void onHopperMove(InventoryMoveItemEvent event) {
        if (!this.manager.isEnabled()) {
            return;
        }
        Inventory source = event.getSource();
        Inventory destination = event.getDestination();
        ChestShop sourceShop = this.getShopFromHopperLocation(source);
        ChestShop destShop = this.getShopFromHopperLocation(destination);
        if (destShop != null && source.getHolder() instanceof Hopper) {
            if (destShop.getStorageInventory() != null && event.getItem() != null && (destShop.getStorageInventory().firstEmpty() != -1 || this.canStackInInventory(destShop.getStorageInventory(), event.getItem()))) {
                destShop.getStorageInventory().addItem(new ItemStack[]{event.getItem().clone()});
                source.removeItem(new ItemStack[]{event.getItem()});
                this.manager.saveShops();
            }
            event.setCancelled(true);
            return;
        }
        if (sourceShop != null && destination.getHolder() instanceof Hopper) {
            if (sourceShop.getStorageInventory() != null && event.getItem() != null && (destination.firstEmpty() != -1 || this.canStackInInventory(destination, event.getItem()))) {
                destination.addItem(new ItemStack[]{event.getItem().clone()});
                sourceShop.getStorageInventory().removeItem(new ItemStack[]{event.getItem()});
                this.manager.saveShops();
            }
            event.setCancelled(true);
            return;
        }
    }

    private ChestShop getShopFromHopperLocation(Inventory inventory) {
        if (!(inventory.getHolder() instanceof Hopper)) {
            return null;
        }
        Hopper hopper = (Hopper)inventory.getHolder();
        Location hopperLoc = hopper.getLocation();
        Location above = hopperLoc.clone().add(0.0, 1.0, 0.0);
        ChestShop shopAbove = this.manager.getShopAt(above);
        if (shopAbove != null) {
            return shopAbove;
        }
        Location below = hopperLoc.clone().add(0.0, -1.0, 0.0);
        ChestShop shopBelow = this.manager.getShopAt(below);
        if (shopBelow != null) {
            return shopBelow;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Location adjacent;
                ChestShop shopAdjacent;
                if (dx == 0 && dz == 0 || (shopAdjacent = this.manager.getShopAt(adjacent = hopperLoc.clone().add((double)dx, 0.0, (double)dz))) == null) continue;
                return shopAdjacent;
            }
        }
        return null;
    }

    private boolean canStackInInventory(Inventory inventory, ItemStack item) {
        for (ItemStack existing : inventory.getContents()) {
            if (existing == null || !existing.isSimilar(item)) continue;
            int maxStack = existing.getMaxStackSize();
            if (existing.getAmount() >= maxStack) continue;
            return true;
        }
        return false;
    }
}

