/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopListener;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopLogManager;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopSession;
import eu.mrneznamy.mrultimateshop.chestshop.gui.OwnerShopMenu;
import eu.mrneznamy.mrultimateshop.chestshop.gui.PlayerOverviewMenu;
import eu.mrneznamy.mrultimateshop.chestshop.hologram.HologramManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ChestShopManager
implements Listener {
    private final MrUltimateShop plugin;
    private boolean enabled;
    private String hologramProviderName;
    private int hologramUpdateIntervalTicks;
    private boolean viewOnlyWhenLooking;
    private Set<String> allowedBlocks;
    private final Map<UUID, ChestShopSession> sessions;
    private final Map<String, ChestShop> shopsByBlockKey;
    private OwnerShopMenu ownerShopMenu;
    private PlayerOverviewMenu playerOverviewMenu;
    private HologramManager hologramManager;
    private ChestShopLogManager logManager;
    private final Map<String, Long> lastLookTimestamps;
    private int hologramTaskId = -1;
    private final Map<UUID, PendingPrice> pendingPriceInputs;
    private final Map<UUID, PendingTeamInput> pendingTeamInputs;
    private boolean shopsLoaded = false;
    private final Map<String, LocationData> pendingLocationData = new HashMap<String, LocationData>();

    public ChestShopManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.allowedBlocks = new HashSet<String>();
        this.sessions = new HashMap<UUID, ChestShopSession>();
        this.shopsByBlockKey = new HashMap<String, ChestShop>();
        this.loadConfiguration();
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)plugin);
        pm.registerEvents((Listener)new ChestShopListener(this), (Plugin)plugin);
        this.ownerShopMenu = new OwnerShopMenu(plugin);
        this.playerOverviewMenu = new PlayerOverviewMenu(plugin);
        this.hologramManager = new HologramManager(plugin);
        this.logManager = new ChestShopLogManager(plugin);
        this.lastLookTimestamps = new HashMap<String, Long>();
        this.pendingPriceInputs = new HashMap<UUID, PendingPrice>();
        this.pendingTeamInputs = new HashMap<UUID, PendingTeamInput>();
        this.startHologramTicker();
    }

    public void loadConfiguration() {
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        ConfigurationSection section = cfg.getConfigurationSection("MrUltimateShop.ChestShops");
        if (section == null) {
            section = cfg.getConfigurationSection("ChestShops");
        }
        if (section == null) {
            this.enabled = false;
            return;
        }
        this.enabled = section.getBoolean("Enabled", false);
        ConfigurationSection holograms = section.getConfigurationSection("Holograms");
        if (holograms != null) {
            this.hologramProviderName = holograms.getString("Hologram-Provider", "MrLibCore");
            this.hologramUpdateIntervalTicks = holograms.getInt("Hologram-Update-Interval", 20);
            this.viewOnlyWhenLooking = holograms.getBoolean("Enable-View-Hologram-Only-When-Looking", true);
            if (this.hologramProviderName.startsWith("MrLibCore")) {
                this.viewOnlyWhenLooking = false;
            }
        } else {
            this.hologramProviderName = "CMIHolograms";
            this.hologramUpdateIntervalTicks = 20;
            this.viewOnlyWhenLooking = true;
            if (this.hologramProviderName.startsWith("MrLibCore")) {
                this.viewOnlyWhenLooking = false;
            }
        }
        this.allowedBlocks.clear();
        for (String m : section.getStringList("Allowed-Blocks")) {
            this.allowedBlocks.add(m.toUpperCase());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHologramProviderName() {
        return this.hologramProviderName;
    }

    public int getHologramUpdateIntervalTicks() {
        return this.hologramUpdateIntervalTicks;
    }

    public boolean isViewOnlyWhenLooking() {
        return this.viewOnlyWhenLooking;
    }

    private boolean isHologramProviderAvailable() {
        if (this.hologramProviderName == null || this.hologramProviderName.isEmpty()) {
            return false;
        }
        if (this.hologramProviderName.equals("MrLibCore")) {
            return true;
        }
        if (this.hologramProviderName.equals("DecentHolograms")) {
            Plugin decentHolo = Bukkit.getPluginManager().getPlugin("DecentHolograms");
            return decentHolo != null && decentHolo.isEnabled();
        }
        if (this.hologramProviderName.equals("CMIHolograms") || this.hologramProviderName.equals("CMI")) {
            Plugin cmi = Bukkit.getPluginManager().getPlugin("CMI");
            return cmi != null && cmi.isEnabled();
        }
        return false;
    }

    public boolean isAllowedBlock(String materialName) {
        return this.allowedBlocks.contains(materialName.toUpperCase());
    }

    public ChestShopSession getOrCreateSession(UUID playerId, ChestShop shop) {
        ChestShopSession session = this.sessions.get(playerId);
        if (session == null) {
            session = new ChestShopSession(shop);
            this.sessions.put(playerId, session);
        } else {
            session.setShop(shop);
        }
        return session;
    }

    public ChestShopSession getSession(UUID playerId) {
        return this.sessions.get(playerId);
    }

    public void openOwnerMenu(Player player, ChestShop shop) {
        ChestShopSession session = this.getOrCreateSession(player.getUniqueId(), shop);
        this.ownerShopMenu.open(player, shop);
    }

    public void openPlayerOverview(Player player, ChestShop shop) {
        ChestShopSession session = this.getOrCreateSession(player.getUniqueId(), shop);
        this.playerOverviewMenu.open(player, shop, session);
    }

    public boolean hasShopAt(Location loc) {
        if (!this.shopsLoaded || !this.pendingLocationData.isEmpty()) {
            return false;
        }
        return this.shopsByBlockKey.containsKey(this.blockKey(loc));
    }

    public ChestShop getShopAt(Location loc) {
        if (!this.shopsLoaded || !this.pendingLocationData.isEmpty()) {
            return null;
        }
        return this.shopsByBlockKey.get(this.blockKey(loc));
    }

    public boolean hasNearbyShops(Location location, int minDistance) {
        if (location == null || location.getWorld() == null) {
            return false;
        }
        for (ChestShop existingShop : this.shopsByBlockKey.values()) {
            double distance;
            if (existingShop.getLocation() == null || !existingShop.getLocation().getWorld().equals((Object)location.getWorld()) || !((distance = existingShop.getLocation().distance(location)) < (double)minDistance)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceShopAt(Location location) {
        if (!this.shopsLoaded || !this.pendingLocationData.isEmpty()) {
            return true;
        }
        int minDistance = this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Min-Distance-Between-Shops", 2);
        return !this.hasNearbyShops(location, minDistance);
    }

    public void registerShop(ChestShop shop) {
        if (shop.getLocation() == null) {
            return;
        }
        this.shopsByBlockKey.put(this.blockKey(shop.getLocation()), shop);
        if (shop.getStorageInventory() == null) {
            Player owner = Bukkit.getPlayer((UUID)shop.getOwnerUuid());
            int size = owner != null ? this.getMaxSizeForPlayer(owner) : this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Size", 54);
            String inventoryName = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.ChestShops.Menu.ShopInventory.Name", "Chest Shop Storage");
            Inventory inv = Bukkit.createInventory(null, (int)size, (String)MrLibColors.colorize((String)inventoryName));
            shop.setStorageInventory(inv);
        }
        this.saveShops();
        this.applyGlobalTeamMembersToNewShop(shop);
        this.spawnGlassPreviewOnly(shop);
    }

    private void applyGlobalTeamMembersToNewShop(ChestShop newShop) {
        HashMap<UUID, ChestShop.TeamRole> globalMembers = new HashMap<UUID, ChestShop.TeamRole>();
        for (ChestShop chestShop : this.shopsByBlockKey.values()) {
            if (!chestShop.isOwner(newShop.getOwnerUuid()) || chestShop.equals(newShop)) continue;
            for (Map.Entry<UUID, ChestShop.TeamRole> entry : chestShop.getTeamMembers().entrySet()) {
                globalMembers.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : globalMembers.entrySet()) {
            newShop.addTeamMember((UUID)entry.getKey(), (ChestShop.TeamRole)((Object)entry.getValue()));
        }
    }

    private String blockKey(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public void loadShopsFromDisk() {
        FileConfiguration data = this.getDataFile();
        if (data == null) {
            return;
        }
        this.shopsByBlockKey.clear();
        this.pendingLocationData.clear();
        if (!data.isConfigurationSection("chestshops")) {
            return;
        }
        ConfigurationSection cs = data.getConfigurationSection("chestshops");
        for (String key : cs.getKeys(false)) {
            ChestShop.TeamRole role;
            String roleString;
            UUID uuid2;
            ConfigurationSection s = cs.getConfigurationSection(key);
            String world = s.getString("world");
            int x = s.getInt("x");
            int y = s.getInt("y");
            int z = s.getInt("z");
            UUID owner = UUID.fromString(s.getString("owner"));
            ChestShop shop = new ChestShop(owner);
            this.pendingLocationData.put(key, new LocationData(world, x, y, z));
            shop.setBuyPricePerItem(s.isSet("buy") ? Double.valueOf(s.getDouble("buy")) : null);
            shop.setSellPricePerItem(s.isSet("sell") ? Double.valueOf(s.getDouble("sell")) : null);
            if (s.isSet("item")) {
                Object raw = s.get("item");
                if (raw instanceof ItemStack) {
                    shop.setItemForTrade((ItemStack)raw);
                } else if (raw instanceof Map) {
                    try {
                        ItemStack itm = ItemStack.deserialize((Map)((Map)raw));
                        shop.setItemForTrade(itm);
                    }
                    catch (Exception itm) {
                        // empty catch block
                    }
                }
            }
            this.shopsByBlockKey.put(key, shop);
            if (shop.getStorageInventory() == null) {
                String inventoryName = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.ChestShops.Menu.ShopInventory.Name", "Chest Shop Storage");
                Inventory inv = Bukkit.createInventory(null, (int)this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Size", 54), (String)MrLibColors.colorize((String)inventoryName));
                shop.setStorageInventory(inv);
            }
            if (s.isList("storage")) {
                List list = s.getList("storage");
                ItemStack[] contents = new ItemStack[shop.getStorageInventory().getSize()];
                for (int i = 0; i < Math.min(list.size(), contents.length); ++i) {
                    Object o = list.get(i);
                    if (o instanceof ItemStack) {
                        contents[i] = (ItemStack)o;
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    try {
                        contents[i] = ItemStack.deserialize((Map)((Map)o));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                shop.getStorageInventory().setContents(contents);
            }
            shop.setCreatedWithShopItem(s.getBoolean("shopItem", false));
            if (s.isConfigurationSection("team")) {
                ConfigurationSection team = s.getConfigurationSection("team");
                for (String memberUuid : team.getKeys(false)) {
                    try {
                        uuid2 = UUID.fromString(memberUuid);
                        roleString = team.getString(memberUuid);
                        role = ChestShop.TeamRole.valueOf(roleString.toUpperCase());
                        shop.addTeamMember(uuid2, role);
                    }
                    catch (Exception uuid2) {}
                }
            }
            if (!s.isConfigurationSection("shopTeam")) continue;
            ConfigurationSection shopTeam = s.getConfigurationSection("shopTeam");
            for (String memberUuid : shopTeam.getKeys(false)) {
                try {
                    uuid2 = UUID.fromString(memberUuid);
                    roleString = shopTeam.getString(memberUuid);
                    role = ChestShop.TeamRole.valueOf(roleString.toUpperCase());
                    shop.addShopSpecificMember(uuid2, role);
                }
                catch (Exception exception) {}
            }
        }
        this.shopsLoaded = true;
        this.createGlassPreviewsForAllShops();
    }

    private void createGlassPreviewsForAllShops() {
        for (Map.Entry<String, LocationData> entry : this.pendingLocationData.entrySet()) {
            World world;
            String key = entry.getKey();
            LocationData locData = entry.getValue();
            ChestShop shop = this.shopsByBlockKey.get(key);
            if (shop == null || (world = Bukkit.getWorld((String)locData.worldName)) == null) continue;
            Location loc = new Location(world, (double)locData.x, (double)locData.y, (double)locData.z);
            shop.setLocation(loc);
            this.spawnGlassPreviewOnly(shop);
        }
    }

    private void initializeShopLocations() {
        if (!this.shopsLoaded) {
            return;
        }
        for (Map.Entry<String, LocationData> entry : this.pendingLocationData.entrySet()) {
            String key = entry.getKey();
            LocationData locData = entry.getValue();
            ChestShop shop = this.shopsByBlockKey.get(key);
            if (shop == null) continue;
            World world = Bukkit.getWorld((String)locData.worldName);
            if (world != null) {
                Location loc = new Location(world, (double)locData.x, (double)locData.y, (double)locData.z);
                shop.setLocation(loc);
                this.spawnGlassPreviewOnly(shop);
                continue;
            }
            this.plugin.getLogger().warning("Could not find world '" + locData.worldName + "' for chest shop at " + locData.x + "," + locData.y + "," + locData.z);
        }
        this.pendingLocationData.clear();
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::initializeShopLocations);
    }

    public void saveShops() {
        FileConfiguration data = this.getDataFile();
        if (data == null) {
            return;
        }
        data.set("chestshops", null);
        for (Map.Entry<String, ChestShop> e : this.shopsByBlockKey.entrySet()) {
            String base = "chestshops." + e.getKey();
            ChestShop s = e.getValue();
            Location l = s.getLocation();
            if (l == null) continue;
            data.set(base + ".world", (Object)l.getWorld().getName());
            data.set(base + ".x", (Object)l.getBlockX());
            data.set(base + ".y", (Object)l.getBlockY());
            data.set(base + ".z", (Object)l.getBlockZ());
            data.set(base + ".owner", (Object)s.getOwnerUuid().toString());
            if (s.getBuyPricePerItem() == null) {
                data.set(base + ".buy", null);
            } else {
                data.set(base + ".buy", (Object)s.getBuyPricePerItem());
            }
            if (s.getSellPricePerItem() == null) {
                data.set(base + ".sell", null);
            } else {
                data.set(base + ".sell", (Object)s.getSellPricePerItem());
            }
            if (s.getItemForTrade() != null) {
                data.set(base + ".item", (Object)s.getItemForTrade());
            } else {
                data.set(base + ".item", null);
            }
            if (s.getStorageInventory() != null) {
                data.set(base + ".storage", Arrays.asList(s.getStorageInventory().getContents()));
            }
            data.set(base + ".shopItem", (Object)s.isCreatedWithShopItem());
            if (!s.getTeamMembers().isEmpty()) {
                for (Map.Entry<UUID, ChestShop.TeamRole> entry : s.getTeamMembers().entrySet()) {
                    data.set(base + ".team." + entry.getKey().toString(), (Object)entry.getValue().name());
                }
            }
            if (s.getShopSpecificMembers().isEmpty()) continue;
            for (Map.Entry<UUID, ChestShop.TeamRole> entry : s.getShopSpecificMembers().entrySet()) {
                data.set(base + ".shopTeam." + entry.getKey().toString(), (Object)entry.getValue().name());
            }
        }
        try {
            ((YamlConfiguration)data).save(new File(this.plugin.getDataFolder(), "chestshops.yml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FileConfiguration getDataFile() {
        File f = new File(this.plugin.getDataFolder(), "chestshops.yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                return null;
            }
        }
        return YamlConfiguration.loadConfiguration((File)f);
    }

    private void spawnGlassPreviewOnly(ChestShop shop) {
        if (!this.enabled) {
            return;
        }
        if (shop.getLocation() == null) {
            return;
        }
        String key = "preview_" + shop.getOwnerUuid().toString() + "_" + shop.getLocation().getBlockX() + "_" + shop.getLocation().getBlockY() + "_" + shop.getLocation().getBlockZ();
        double yOffset = this.plugin.getConfigManager().getConfig().getDouble("MrUltimateShop.ChestShops.Shops.Glass-Preview-Y-Offset", 0.8);
        this.hologramManager.showItemPreview(key, shop.getLocation(), shop.getItemForTrade(), yOffset -= 1.25);
    }

    private void spawnHologramLinesOnly(ChestShop shop) {
        if (!this.enabled) {
            return;
        }
        if (shop.getLocation() == null) {
            return;
        }
        if (!this.isHologramProviderAvailable()) {
            return;
        }
        ConfigurationSection holograms = this.plugin.getConfigManager().getConfig().getConfigurationSection("MrUltimateShop.ChestShops.Holograms");
        if (holograms == null) {
            return;
        }
        List lore = holograms.getStringList("Hologram-Lore");
        if (lore == null || lore.isEmpty()) {
            return;
        }
        String key = this.blockKey(shop.getLocation());
        HashMap<String, String> ph = new HashMap<String, String>();
        String ownerName = Bukkit.getOfflinePlayer((UUID)shop.getOwnerUuid()).getName();
        ph.put("[PlayerName]", ownerName == null ? this.plugin.getMessageManager().getMessage("chest-shop-unknown-player", "Unknown") : ownerName);
        String itemName = this.plugin.getMessageManager().getMessage("chest-shop-no-item", "None");
        if (shop.getItemForTrade() != null) {
            ItemMeta im = shop.getItemForTrade().getItemMeta();
            itemName = im != null && im.hasDisplayName() ? im.getDisplayName() : shop.getItemForTrade().getType().name();
        }
        ph.put("[Items]", itemName);
        int availableBuy = shop.getBuyPricePerItem() == null || shop.getItemForTrade() == null ? 0 : this.getAvailableBuyCount(shop);
        int availableSell = shop.getSellPricePerItem() == null || shop.getItemForTrade() == null ? 0 : this.getAvailableSellCapacity(shop);
        ph.put("[AvaibleBuy]", String.valueOf(availableBuy));
        ph.put("[AvaibleSell]", String.valueOf(availableSell));
        ph.put("[Price]", shop.getBuyPricePerItem() == null ? "-" : this.plugin.getEconomyManager().format(shop.getBuyPricePerItem().doubleValue()));
        ph.put("[Sell-Price]", shop.getSellPricePerItem() == null ? "-" : this.plugin.getEconomyManager().format(shop.getSellPricePerItem().doubleValue()));
        List<String> applied = HologramManager.applyPlaceholders(lore, ph);
        this.hologramManager.showLines(key, shop.getLocation(), applied);
    }

    private void spawnOrUpdateHologram(ChestShop shop) {
        if (!this.enabled) {
            return;
        }
        if (shop.getLocation() == null) {
            return;
        }
        this.spawnHologramLinesOnly(shop);
    }

    private int getAvailableBuyCount(ChestShop shop) {
        if (shop.getStorageInventory() == null || shop.getItemForTrade() == null) {
            return 0;
        }
        int sum = 0;
        for (ItemStack is : shop.getStorageInventory().getContents()) {
            if (is == null || !is.isSimilar(shop.getItemForTrade())) continue;
            sum += is.getAmount();
        }
        return sum;
    }

    private int getAvailableSellCapacity(ChestShop shop) {
        if (shop.getStorageInventory() == null || shop.getItemForTrade() == null) {
            return 0;
        }
        int capacity = 0;
        int max = shop.getItemForTrade().getMaxStackSize();
        for (ItemStack is : shop.getStorageInventory().getContents()) {
            if (is == null) {
                capacity += max;
                continue;
            }
            if (!is.isSimilar(shop.getItemForTrade())) continue;
            capacity += Math.max(0, max - is.getAmount());
        }
        return capacity;
    }

    public void refreshHologram(ChestShop shop) {
        if (shop == null || shop.getLocation() == null) {
            return;
        }
        this.hologramManager.removeLines(this.blockKey(shop.getLocation()));
        this.spawnHologramLinesOnly(shop);
        this.spawnGlassPreviewOnly(shop);
    }

    public void refreshAllHolograms() {
        int count = 0;
        for (ChestShop shop : this.shopsByBlockKey.values()) {
            if (shop == null || shop.getLocation() == null) continue;
            this.refreshHologram(shop);
            ++count;
        }
    }

    public void requestPriceInput(UUID playerId, ChestShop shop, PriceType type) {
        this.pendingPriceInputs.put(playerId, new PendingPrice(shop, type));
    }

    public PendingPrice getPendingPrice(UUID playerId) {
        return this.pendingPriceInputs.get(playerId);
    }

    public void clearPendingPrice(UUID playerId) {
        this.pendingPriceInputs.remove(playerId);
    }

    public void requestTeamInput(UUID playerId, ChestShop shop, ChatInputType type, boolean isGlobalInvite) {
        this.pendingTeamInputs.put(playerId, new PendingTeamInput(shop, type, isGlobalInvite));
    }

    public PendingTeamInput getPendingTeamInput(UUID playerId) {
        return this.pendingTeamInputs.get(playerId);
    }

    public void clearPendingTeamInput(UUID playerId) {
        this.pendingTeamInputs.remove(playerId);
    }

    private void startHologramTicker() {
        boolean onlyWhenLook = this.plugin.getConfigManager().getConfig().getBoolean("MrUltimateShop.ChestShops.Holograms.Enable-View-Hologram-Only-When-Looking", true);
        int interval = this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Holograms.Hologram-Update-Interval", 20);
        if (!onlyWhenLook) {
            return;
        }
        if (!this.isHologramProviderAvailable()) {
            this.plugin.getLogger().warning("Hologram provider '" + this.hologramProviderName + "' is not available. Hologram ticker will not be started.");
            return;
        }
        if (this.hologramTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.hologramTaskId);
        }
        this.hologramTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            for (ChestShop shop : this.shopsByBlockKey.values()) {
                if (shop.getLocation() == null) continue;
                String key = this.blockKey(shop.getLocation());
                boolean looking = false;
                Location focus = shop.getLocation().clone().add(0.5, 1.0, 0.5);
                if (focus.getWorld() == null) continue;
                for (Player p : focus.getWorld().getPlayers()) {
                    Block target;
                    if (p.getLocation().distanceSquared(focus) > 25.0 || (target = p.getTargetBlockExact(6)) == null || !target.getLocation().equals((Object)shop.getLocation())) continue;
                    looking = true;
                    break;
                }
                if (looking) {
                    this.lastLookTimestamps.put(key, now);
                    if (!this.hologramManager.has(key)) {
                        this.spawnHologramLinesOnly(shop);
                        continue;
                    }
                    this.spawnHologramLinesOnly(shop);
                    continue;
                }
                Long last = this.lastLookTimestamps.get(key);
                if (last == null || now - last <= 1500L) continue;
                this.hologramManager.removeLines(key);
            }
        }, (long)interval, (long)interval);
    }

    public void shutdown() {
        if (this.hologramTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.hologramTaskId);
            this.hologramTaskId = -1;
        }
        if (this.hologramManager != null) {
            this.hologramManager.cleanupAllDroppedItems();
            this.hologramManager.removeAll();
        }
        this.shopsByBlockKey.clear();
        this.sessions.clear();
    }

    public void deleteShopAt(Location location) {
        String key = this.blockKey(location);
        ChestShop shop = this.shopsByBlockKey.remove(key);
        if (shop == null) {
            return;
        }
        this.hologramManager.removeAllForShop(key);
        this.sessions.entrySet().removeIf(entry -> {
            ChestShop sessionShop = ((ChestShopSession)entry.getValue()).getShop();
            if (sessionShop.getLocation() == null) {
                return false;
            }
            return sessionShop.getLocation().equals((Object)location);
        });
        this.saveShops();
    }

    public ItemStack buildShopItem() {
        String cfgMat = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.ChestShops.Shop-Item.Material", "CHEST");
        Material mat = Material.matchMaterial((String)cfgMat);
        if (mat == null || !mat.isItem()) {
            mat = Material.CHEST;
        }
        ItemStack item = new ItemStack(mat, 1);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfigManager().getConfig().getString("MrUltimateShop.ChestShops.Shop-Item.Name", "Shop Item");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("MrUltimateShop.ChestShops.Shop-Item.Lore");
        meta.setDisplayName(MrLibColors.colorize((String)name));
        ArrayList<String> colored = new ArrayList<String>();
        for (String l : lore) {
            colored.add(MrLibColors.colorize((String)l));
        }
        meta.setLore(colored);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "cshop_item");
        meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
        return item;
    }

    public boolean isShopItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "cshop_item");
        Byte val = (Byte)meta.getPersistentDataContainer().get(key, PersistentDataType.BYTE);
        return val != null && val == 1;
    }

    public int getMaxPagesForPlayer(Player player) {
        return 1;
    }

    public int getMaxSizeForPlayer(Player player) {
        return this.plugin.getConfigManager().getConfig().getInt("MrUltimateShop.ChestShops.Shops.Size", 54);
    }

    public int getShopLimitForPlayer(Player player) {
        int highestLimit = 0;
        for (int i = 1; i <= 100; ++i) {
            if (!player.hasPermission("mrultimateshop.limit." + i)) continue;
            highestLimit = i;
        }
        return highestLimit;
    }

    public int getPlayerShopCount(Player player) {
        int count = 0;
        for (ChestShop shop : this.shopsByBlockKey.values()) {
            if (!shop.getOwnerUuid().equals(player.getUniqueId())) continue;
            ++count;
        }
        return count;
    }

    public boolean canCreateShop(Player player) {
        int limit = this.getShopLimitForPlayer(player);
        if (limit == 0) {
            return true;
        }
        int currentShops = this.getPlayerShopCount(player);
        return currentShops < limit;
    }

    public void removePlayerFromAllShops(UUID playerUuid) {
        boolean changed = false;
        for (ChestShop shop : this.shopsByBlockKey.values()) {
            if (shop.isGlobalTeamMember(playerUuid)) {
                shop.removeTeamMember(playerUuid);
                changed = true;
            }
            if (!shop.isShopSpecificMember(playerUuid)) continue;
            shop.removeShopSpecificMember(playerUuid);
            changed = true;
        }
        if (changed) {
            this.saveShops();
        }
    }

    public void addPlayerToAllShops(UUID ownerUuid, UUID playerUuid, ChestShop.TeamRole role) {
        boolean changed = false;
        for (ChestShop shop : this.shopsByBlockKey.values()) {
            if (!shop.isOwner(ownerUuid)) continue;
            shop.addTeamMember(playerUuid, role);
            changed = true;
        }
        if (changed) {
            this.saveShops();
        }
    }

    public ChestShopLogManager getLogManager() {
        return this.logManager;
    }

    public double calculateTax(Player player, double originalPrice) {
        double defaultTaxRate;
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        boolean taxEnabled = cfg.getBoolean("MrUltimateShop.ChestShops.Shops.Taxes.Enabled", false);
        if (!taxEnabled) {
            return 0.0;
        }
        double taxRate = defaultTaxRate = cfg.getDouble("MrUltimateShop.ChestShops.Shops.Taxes.Tax", 0.0);
        for (int i = 0; i <= 100; ++i) {
            if (!player.hasPermission("mrultimateshop.tax." + i)) continue;
            taxRate = i;
            break;
        }
        return originalPrice * taxRate / 100.0;
    }

    public double applyTax(Player player, double originalPrice) {
        double taxAmount = this.calculateTax(player, originalPrice);
        return originalPrice - taxAmount;
    }

    private static class LocationData {
        final String worldName;
        final int x;
        final int y;
        final int z;

        LocationData(String worldName, int x, int y, int z) {
            this.worldName = worldName;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class PendingPrice {
        public final ChestShop shop;
        public final PriceType type;

        public PendingPrice(ChestShop shop, PriceType type) {
            this.shop = shop;
            this.type = type;
        }
    }

    public static enum PriceType {
        BUY,
        SELL;

    }

    public static class PendingTeamInput {
        public final ChestShop shop;
        public final ChatInputType type;
        public final boolean isGlobalInvite;
        public String playerName;

        public PendingTeamInput(ChestShop shop, ChatInputType type, boolean isGlobalInvite) {
            this.shop = shop;
            this.type = type;
            this.isGlobalInvite = isGlobalInvite;
        }
    }

    public static enum ChatInputType {
        PRICE,
        TEAM_ADD_NAME,
        TEAM_ADD_ROLE,
        TEAM_REMOVE_NAME;

    }
}

