/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop.gui;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopSession;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerOverviewMenu
implements Listener {
    private final MrUltimateShop plugin;

    public PlayerOverviewMenu(MrUltimateShop plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player, ChestShop shop, ChestShopSession session) {
        ConfigurationSection items;
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        ConfigurationSection section = cfg.getConfigurationSection("MrUltimateShop.ChestShops.Menu.PlayerOverview");
        String nameTemplate = section.getString("Name", "Chest Shop");
        String ownerName = Bukkit.getOfflinePlayer((UUID)shop.getOwnerUuid()).getName();
        if (ownerName == null) {
            ownerName = this.plugin.getMessageManager().getMessage("chest-shop-unknown-player", "Unknown");
        }
        String name = MrLibColors.colorize((String)nameTemplate.replace("[PlayerName]", ownerName));
        int size = section.getInt("Size", 54);
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)name);
        ConfigurationSection deco = section.getConfigurationSection("Decorations");
        if (deco != null) {
            for (String k : deco.getKeys(false)) {
                String[] slots;
                ConfigurationSection d = deco.getConfigurationSection(k);
                Material mat = Material.matchMaterial((String)d.getString("Material", "BLACK_STAINED_GLASS_PANE"));
                ItemStack glass = new ItemStack(mat == null ? Material.BLACK_STAINED_GLASS_PANE : mat);
                ItemMeta im = glass.getItemMeta();
                im.setDisplayName(MrLibColors.colorize((String)d.getString("Name", " ")));
                glass.setItemMeta(im);
                for (String s : slots = d.getString("Slots", "").split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    try {
                        inv.setItem(Integer.parseInt(s), glass);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        int tradeSlot = section.getInt("Trade-Item-Slot", 22);
        if (shop.getItemForTrade() != null) {
            ItemStack center = shop.getItemForTrade().clone();
            inv.setItem(tradeSlot, center);
        }
        if ((items = section.getConfigurationSection("Items")) != null) {
            for (String k : items.getKeys(false)) {
                ConfigurationSection it = items.getConfigurationSection(k);
                Material mat = Material.matchMaterial((String)it.getString("Material", "STONE"));
                ItemStack is = new ItemStack(mat == null ? Material.STONE : mat);
                ItemMeta im = is.getItemMeta();
                String mode = session.getMode() == ChestShopSession.Mode.BUY ? this.plugin.getMessageManager().getMessage("chest-shop-mode-buy", "&aN\u00e1kup") : this.plugin.getMessageManager().getMessage("chest-shop-mode-sell", "&cProdej");
                Double price = session.getMode() == ChestShopSession.Mode.BUY ? shop.getBuyPricePerItem() : shop.getSellPricePerItem();
                String priceStr = price != null ? this.plugin.getEconomyManager().format(price.doubleValue()) : "-";
                String totalPriceStr = price != null ? this.plugin.getEconomyManager().format(price * (double)session.getQuantity()) : "-";
                String nameT = it.getString("Name", "Item").replace("[Mode]", mode).replace("[Quantity]", String.valueOf(session.getQuantity())).replace("[Price]", priceStr).replace("[TotalPrice]", totalPriceStr);
                im.setDisplayName(MrLibColors.colorize((String)nameT));
                List lore = it.getStringList("Lore");
                ArrayList<String> colored = new ArrayList<String>();
                for (String l : lore) {
                    String processedLore = l.replace("[Mode]", mode).replace("[Quantity]", String.valueOf(session.getQuantity())).replace("[Price]", priceStr).replace("[TotalPrice]", totalPriceStr);
                    colored.add(MrLibColors.colorize((String)processedLore));
                }
                im.setLore(colored);
                is.setItemMeta(im);
                int slot = it.getInt("slot", -1);
                if (slot < 0 || slot >= size) continue;
                inv.setItem(slot, is);
            }
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        FileConfiguration cfg;
        String menuTitleTemplate;
        String menuTitle;
        if (e.getView().getTitle() == null) {
            return;
        }
        String title = e.getView().getTitle();
        if (!this.isPlayerOverviewMenu(title, menuTitle = MrLibColors.colorize((String)(menuTitleTemplate = (cfg = this.plugin.getConfigManager().getConfig()).getConfigurationSection("MrUltimateShop.ChestShops.Menu.PlayerOverview").getString("Name", ""))))) {
            return;
        }
        int topSize = e.getView().getTopInventory().getSize();
        if (e.getRawSlot() >= topSize) {
            e.setCancelled(false);
            return;
        }
        e.setCancelled(true);
        Player player = (Player)e.getWhoClicked();
        ChestShopManager csm = this.plugin.getChestShopManager();
        ChestShopSession session = csm.getSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        ChestShop shop = session.getShop();
        ConfigurationSection items = cfg.getConfigurationSection("MrUltimateShop.ChestShops.Menu.PlayerOverview.Items");
        if (items == null) {
            return;
        }
        int clicked = e.getRawSlot();
        for (String k : items.getKeys(false)) {
            ConfigurationSection it = items.getConfigurationSection(k);
            int slot = it.getInt("slot", -1);
            if (slot != clicked) continue;
            String action = it.getString("Action", "").toUpperCase();
            int amount = it.getInt("Amount", 1);
            switch (action) {
                case "ADD_QUANTITY": {
                    session.setQuantity(session.getQuantity() + amount);
                    this.open(player, shop, session);
                    return;
                }
                case "REMOVE_QUANTITY": {
                    session.setQuantity(Math.max(1, session.getQuantity() - amount));
                    this.open(player, shop, session);
                    return;
                }
                case "TOGGLE_MODE": {
                    session.toggleMode();
                    this.open(player, shop, session);
                    return;
                }
                case "EXECUTE_TRADE": {
                    this.executeTrade(player, shop, session);
                    return;
                }
            }
            return;
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        FileConfiguration cfg;
        String menuTitleTemplate;
        String menuTitle;
        if (e.getView().getTitle() == null) {
            return;
        }
        String title = e.getView().getTitle();
        if (!this.isPlayerOverviewMenu(title, menuTitle = MrLibColors.colorize((String)(menuTitleTemplate = (cfg = this.plugin.getConfigManager().getConfig()).getConfigurationSection("MrUltimateShop.ChestShops.Menu.PlayerOverview").getString("Name", ""))))) {
            return;
        }
        e.setCancelled(true);
    }

    private boolean isPlayerOverviewMenu(String title, String menuTitle) {
        if (title.equals(menuTitle)) {
            return true;
        }
        if (menuTitle.contains("[PlayerName]")) {
            String beforePlayerName = menuTitle.substring(0, menuTitle.indexOf("[PlayerName]"));
            String afterPlayerName = menuTitle.substring(menuTitle.indexOf("[PlayerName]") + "[PlayerName]".length());
            return title.startsWith(beforePlayerName) && title.endsWith(afterPlayerName) && title.length() > beforePlayerName.length() + afterPlayerName.length();
        }
        return false;
    }

    private void executeTrade(Player player, ChestShop shop, ChestShopSession session) {
        if (shop.getItemForTrade() == null) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-no-item-set", "{Prefix}&cNo item set for trade!"));
            return;
        }
        if (session.getMode() == ChestShopSession.Mode.BUY) {
            Double buyPrice = shop.getBuyPricePerItem();
            if (buyPrice == null) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-no-buy-price", "{Prefix}&cBuy price not set!"));
                return;
            }
            double totalCost = buyPrice * (double)session.getQuantity();
            if (!this.plugin.getEconomyManager().hasEnough(player, totalCost)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-not-enough-money", "{Prefix}&cYou don't have enough money!"));
                return;
            }
            int availableItems = this.getAvailableBuyCount(shop);
            if (availableItems < session.getQuantity()) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-not-enough-items", "{Prefix}&cShop doesn't have enough items!"));
                return;
            }
            if (this.plugin.getEconomyManager().withdraw((OfflinePlayer)player, totalCost)) {
                this.removeItemsFromShop(shop, session.getQuantity());
                ItemStack toGive = shop.getItemForTrade().clone();
                toGive.setAmount(session.getQuantity());
                player.getInventory().addItem(new ItemStack[]{toGive});
                Player shopOwner = Bukkit.getPlayer((UUID)shop.getOwnerUuid());
                if (shopOwner != null) {
                    this.plugin.getEconomyManager().deposit((OfflinePlayer)shopOwner, totalCost);
                }
                this.plugin.getChestShopManager().getLogManager().logShopBuy(player, shop.getLocation(), toGive, session.getQuantity(), totalCost, 0.0);
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-buy-success", "{Prefix}&aSuccessfully bought " + session.getQuantity() + "x " + shop.getItemForTrade().getType().name() + " for " + this.plugin.getEconomyManager().format(totalCost) + "!"));
                this.plugin.getChestShopManager().refreshHologram(shop);
                this.plugin.getChestShopManager().saveShops();
            }
        } else {
            Double sellPrice = shop.getSellPricePerItem();
            if (sellPrice == null) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-no-sell-price", "{Prefix}&cSell price not set!"));
                return;
            }
            int playerItems = this.countPlayerItems(player, shop.getItemForTrade());
            if (playerItems < session.getQuantity()) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-not-enough-items-player", "{Prefix}&cYou don't have enough items!"));
                return;
            }
            int availableSpace = this.getAvailableSellCapacity(shop);
            if (availableSpace < session.getQuantity()) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-shop-full", "{Prefix}&cShop storage is full!"));
                return;
            }
            double totalCost = sellPrice * (double)session.getQuantity();
            Player shopOwner = Bukkit.getPlayer((UUID)shop.getOwnerUuid());
            if (shopOwner != null && !this.plugin.getEconomyManager().hasEnough(shopOwner, totalCost)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-owner-not-enough-money", "{Prefix}&cShop owner doesn't have enough money!"));
                return;
            }
            if (shopOwner != null && this.plugin.getEconomyManager().withdraw((OfflinePlayer)shopOwner, totalCost)) {
                double taxAmount = this.plugin.getChestShopManager().calculateTax(player, totalCost);
                double playerReceives = totalCost - taxAmount;
                this.plugin.getEconomyManager().deposit((OfflinePlayer)player, playerReceives);
                this.removeItemsFromPlayer(player, shop.getItemForTrade(), session.getQuantity());
                this.addItemsToShop(shop, session.getQuantity());
                this.plugin.getChestShopManager().getLogManager().logShopSell(player, shop.getLocation(), shop.getItemForTrade(), session.getQuantity(), totalCost, taxAmount);
                String taxMessage = "";
                if (taxAmount > 0.0) {
                    taxMessage = " (Tax: " + this.plugin.getEconomyManager().format(taxAmount) + ")";
                }
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("chest-shop-sell-success", "{Prefix}&aSuccessfully sold " + session.getQuantity() + "x " + shop.getItemForTrade().getType().name() + " for " + this.plugin.getEconomyManager().format(playerReceives) + taxMessage + "!"));
                this.plugin.getChestShopManager().refreshHologram(shop);
                this.plugin.getChestShopManager().saveShops();
            }
        }
    }

    private int getAvailableBuyCount(ChestShop shop) {
        if (shop.getStorageInventory() == null || shop.getItemForTrade() == null) {
            return 0;
        }
        int sum = 0;
        for (ItemStack is : shop.getStorageInventory().getContents()) {
            if (is == null || !is.isSimilar(shop.getItemForTrade())) continue;
            sum += is.getAmount();
        }
        return sum;
    }

    private int getAvailableSellCapacity(ChestShop shop) {
        if (shop.getStorageInventory() == null || shop.getItemForTrade() == null) {
            return 0;
        }
        int capacity = 0;
        int max = shop.getItemForTrade().getMaxStackSize();
        for (ItemStack is : shop.getStorageInventory().getContents()) {
            if (is == null) {
                capacity += max;
                continue;
            }
            if (!is.isSimilar(shop.getItemForTrade())) continue;
            capacity += Math.max(0, max - is.getAmount());
        }
        return capacity;
    }

    private int countPlayerItems(Player player, ItemStack target) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !item.isSimilar(target)) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void removeItemsFromShop(ChestShop shop, int amount) {
        int remaining = amount;
        for (ItemStack item : shop.getStorageInventory().getContents()) {
            if (item == null || !item.isSimilar(shop.getItemForTrade())) continue;
            int toRemove = Math.min(remaining, item.getAmount());
            item.setAmount(item.getAmount() - toRemove);
            if (item.getAmount() <= 0) {
                shop.getStorageInventory().remove(item);
            }
            if ((remaining -= toRemove) <= 0) break;
        }
    }

    private void removeItemsFromPlayer(Player player, ItemStack target, int amount) {
        int remaining = amount;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !item.isSimilar(target)) continue;
            int toRemove = Math.min(remaining, item.getAmount());
            item.setAmount(item.getAmount() - toRemove);
            if (item.getAmount() <= 0) {
                player.getInventory().remove(item);
            }
            if ((remaining -= toRemove) <= 0) break;
        }
    }

    private void addItemsToShop(ChestShop shop, int amount) {
        ItemStack toAdd = shop.getItemForTrade().clone();
        toAdd.setAmount(amount);
        shop.getStorageInventory().addItem(new ItemStack[]{toAdd});
    }
}

