/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop.hologram;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramManager;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class HologramManager {
    private final MrUltimateShop plugin;
    private final MrLibHologramManager hologramManager;
    private final Map<String, List<ArmorStand>> previewByKey;
    private final Set<String> activeHolograms;
    private int rotateTaskId = -1;

    public HologramManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.hologramManager = MrLibHologramManager.getInstance();
        this.previewByKey = new HashMap<String, List<ArmorStand>>();
        this.activeHolograms = new HashSet<String>();
        this.rotateTaskId = -1;
    }

    public void showLines(String key, Location base, List<String> lines) {
        if (base == null || base.getWorld() == null) {
            return;
        }
        if (this.hologramManager.isEnabled()) {
            ArrayList<String> colorizedLines = new ArrayList<String>();
            for (String line : lines) {
                if (line == null || line.trim().isEmpty()) continue;
                colorizedLines.add(MrLibColors.colorize((String)line));
            }
            if (this.hologramManager.has(key)) {
                this.hologramManager.updateHologram(key, colorizedLines);
            } else {
                Location hologramLocation = this.hologramManager.getActiveProviderName().equals("MrLibCore-TextDisplay") ? base.clone().add(0.5, 3.0, 0.5) : base.clone().add(0.5, 4.0, 0.5);
                this.hologramManager.createHologram(key, hologramLocation, colorizedLines);
                this.activeHolograms.add(key);
            }
        }
    }

    public static List<String> applyPlaceholders(List<String> lines, Map<String, String> placeholders) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String l;
            String t = l = iterator.next();
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                t = t.replace(e.getKey(), e.getValue());
            }
            result.add(t);
        }
        return result;
    }

    public void remove(String key) {
        if (this.hologramManager.isEnabled() && this.activeHolograms.contains(key)) {
            this.hologramManager.deleteHologram(key);
            this.activeHolograms.remove(key);
        }
    }

    public void removeAll() {
        for (String string : new ArrayList<String>(this.activeHolograms)) {
            this.remove(string);
        }
        for (List list : this.previewByKey.values()) {
            if (list == null) continue;
            for (ArmorStand as : list) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrus_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                as.remove();
            }
        }
        this.previewByKey.clear();
        if (this.rotateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.rotateTaskId);
            this.rotateTaskId = -1;
        }
    }

    public boolean has(String key) {
        return this.activeHolograms.contains(key) && this.hologramManager.hologramExists(key);
    }

    public void removeLines(String key) {
        this.remove(key);
    }

    public void removeAllForShop(String key) {
        this.removeLines(key);
        List<ArmorStand> previewList = this.previewByKey.remove(key);
        if (previewList != null) {
            for (ArmorStand as : previewList) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrus_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                as.remove();
            }
        }
    }

    public void showItemPreview(String key, Location base, ItemStack item, double yOffset) {
        if (base == null || base.getWorld() == null || item == null) {
            return;
        }
        List<ArmorStand> existingPreview = this.previewByKey.get(key);
        boolean needsUpdate = false;
        if (existingPreview != null && !existingPreview.isEmpty()) {
            Item droppedItem;
            for (ArmorStand as : existingPreview) {
                if (as == null || as.isDead() || !as.hasMetadata("mrus_dropped_item")) continue;
                try {
                    droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                    if (droppedItem == null || droppedItem.isDead() || droppedItem.getItemStack().isSimilar(item)) continue;
                    needsUpdate = true;
                }
                catch (Exception e) {
                    needsUpdate = true;
                }
                break;
            }
            if (!needsUpdate) {
                return;
            }
            for (ArmorStand as : existingPreview) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrus_dropped_item")) {
                    try {
                        droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception droppedItem2) {
                        // empty catch block
                    }
                }
                as.remove();
            }
            this.previewByKey.remove(key);
        }
        World world = base.getWorld();
        ArrayList<ArmorStand> previewList = new ArrayList<ArmorStand>();
        boolean enableGlassPreview = this.plugin.getConfigManager().getConfig().getBoolean("MrUltimateShop.ChestShops.Shops.Enable-Glass-Item-Preview", true);
        if (enableGlassPreview) {
            Location glassLoc = new Location(world, (double)base.getBlockX() + 0.5, (double)base.getBlockY() + yOffset, (double)base.getBlockZ() + 0.5);
            ArmorStand glassAs = (ArmorStand)world.spawnEntity(glassLoc, EntityType.ARMOR_STAND);
            glassAs.setMarker(true);
            glassAs.setInvisible(true);
            glassAs.setSmall(false);
            glassAs.setGravity(false);
            glassAs.setCustomNameVisible(false);
            glassAs.setArms(false);
            if (glassAs.getEquipment() != null) {
                glassAs.getEquipment().setItemInMainHand(null);
                glassAs.getEquipment().setItemInOffHand(null);
                ItemStack glassBlock = new ItemStack(Material.GLASS);
                glassAs.getEquipment().setHelmet(glassBlock);
            }
            glassAs.setMetadata("mrus_glass", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            previewList.add(glassAs);
        }
        double itemYOffset = yOffset;
        itemYOffset = enableGlassPreview ? (itemYOffset += 1.4) : (itemYOffset += 1.5);
        Location itemLoc = new Location(world, (double)base.getBlockX() + 0.5, (double)base.getBlockY() + itemYOffset, (double)base.getBlockZ() + 0.5);
        ArmorStand holderAs = (ArmorStand)world.spawnEntity(itemLoc, EntityType.ARMOR_STAND);
        holderAs.setMarker(true);
        holderAs.setInvisible(true);
        holderAs.setSmall(true);
        holderAs.setGravity(false);
        holderAs.setCustomNameVisible(false);
        holderAs.setArms(false);
        holderAs.setMetadata("mrus_item_holder", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        holderAs.setMetadata("mrus_base_location", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)base));
        ItemStack previewItem = item.clone();
        previewItem.setAmount(1);
        ItemMeta meta = previewItem.getItemMeta();
        if (meta != null) {
            NamespacedKey previewKey = new NamespacedKey((Plugin)this.plugin, "preview_item");
            meta.getPersistentDataContainer().set(previewKey, PersistentDataType.BYTE, (Object)1);
            previewItem.setItemMeta(meta);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (holderAs != null && !holderAs.isDead()) {
                Item droppedItem = world.dropItem(itemLoc, previewItem);
                droppedItem.setPickupDelay(Integer.MAX_VALUE);
                droppedItem.setVelocity(new Vector(0, 0, 0));
                droppedItem.setGravity(false);
                droppedItem.setInvulnerable(true);
                droppedItem.setMetadata("mrus_preview_item", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                holderAs.setMetadata("mrus_dropped_item", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)droppedItem));
            }
        });
        previewList.add(holderAs);
        this.previewByKey.put(key, previewList);
        if (this.rotateTaskId == -1) {
            this.rotateTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                for (List<ArmorStand> list : this.previewByKey.values()) {
                    if (list == null || list.isEmpty()) continue;
                    for (ArmorStand as : list) {
                        if (as == null || as.isDead() || !as.hasMetadata("mrus_item_holder") || !as.hasMetadata("mrus_dropped_item") || !as.hasMetadata("mrus_base_location")) continue;
                        try {
                            Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                            Location baseLocation = (Location)((MetadataValue)as.getMetadata("mrus_base_location").get(0)).value();
                            if (droppedItem == null || droppedItem.isDead() || baseLocation == null) continue;
                            Location currentLoc = droppedItem.getLocation();
                            double floatOffset = Math.sin((double)System.currentTimeMillis() * 0.002) * 0.03;
                            Location newLoc = new Location(currentLoc.getWorld(), (double)baseLocation.getBlockX() + 0.5, as.getLocation().getY() + floatOffset, (double)baseLocation.getBlockZ() + 0.5, currentLoc.getYaw() + 3.0f, currentLoc.getPitch());
                            droppedItem.teleport(newLoc);
                        }
                        catch (Exception exception) {}
                    }
                }
            }, 1L, 1L);
        }
    }

    public void cleanupAllDroppedItems() {
        for (List<ArmorStand> previewList : this.previewByKey.values()) {
            if (previewList == null) continue;
            for (ArmorStand as : previewList) {
                if (as == null || as.isDead() || !as.hasMetadata("mrus_dropped_item")) continue;
                try {
                    Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrus_dropped_item").get(0)).value();
                    if (droppedItem == null || droppedItem.isDead()) continue;
                    droppedItem.remove();
                }
                catch (Exception exception) {}
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Item item : world.getEntitiesByClass(Item.class)) {
                if (!item.hasMetadata("mrus_preview_item")) continue;
                item.remove();
            }
        }
    }
}

