/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.commands;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MusCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateShop plugin;

    public MusCommand(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                MrLibHelper.showPluginHelp((Player)((Player)sender), (String)"MrUltimateShop", (int)1);
            } else {
                sender.sendMessage("Use /mus help in-game to see available commands");
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("mrultimateshop.reload")) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
                    return true;
                }
                this.plugin.reloadConfiguration();
                this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("commands.config-reloaded", "&aConfiguration has been successfully loaded!"));
                return true;
            }
            case "shop": {
                if (!(sender instanceof Player)) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("errors.player-only", "&cThis command can only be used by a player!"));
                    return true;
                }
                Player shopPlayer = (Player)sender;
                if (!shopPlayer.hasPermission("mrultimateshop.shop")) {
                    shopPlayer.sendMessage(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
                    return true;
                }
                this.plugin.getMenuManager().openMainMenu(shopPlayer);
                return true;
            }
            case "help": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length == 1) {
                        MrLibHelper.showRegisteredPlugins((Player)player);
                    } else if (args.length == 2) {
                        MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)1);
                    } else if (args.length == 3) {
                        try {
                            int page = Integer.parseInt(args[2]);
                            MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)page);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(MrLibColors.colorize((String)"&cInvalid page number!"));
                        }
                    }
                } else {
                    sender.sendMessage("Use /mus help in-game to see available commands");
                }
                return true;
            }
            case "list": {
                if (!sender.hasPermission("mrultimateshop.list")) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
                    return true;
                }
                this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("commands.available-shops", "&a&l[MrUltimateShop] &fAvailable shops:"));
                Set<String> shops = this.plugin.getMenuManager().getAvailableShops();
                if (shops.isEmpty()) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("commands.no-shops-found", "&cNo shops found!"));
                } else {
                    for (String shopName : shops) {
                        this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("commands.shop-list-item", "&e- {shop}").replace("{shop}", shopName));
                    }
                }
                return true;
            }
        }
        if (sender instanceof Player) {
            MrLibHelper.showPluginHelp((Player)((Player)sender), (String)"MrUltimateShop", (int)1);
        } else {
            sender.sendMessage("Use /mus help in-game to see available commands");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("reload", "shop", "list", "help");
            return subcommands.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).filter(s -> this.hasPermissionForSubcommand(sender, (String)s)).collect(Collectors.toList());
        }
        return completions;
    }

    private boolean hasPermissionForSubcommand(CommandSender sender, String subcommand) {
        switch (subcommand) {
            case "reload": {
                return sender.hasPermission("mrultimateshop.reload");
            }
            case "shop": {
                return sender.hasPermission("mrultimateshop.shop");
            }
            case "list": {
                return sender.hasPermission("mrultimateshop.list");
            }
        }
        return true;
    }
}

