/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.commands;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ShopCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateShop plugin;

    public ShopCommand(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-only", "&cThis command can only be used by a player!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("mrultimateshop.shop")) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
                return true;
            }
            this.plugin.getMenuManager().openMainMenu(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "sell": {
                return this.handleSellCommand(sender, args);
            }
        }
        if (args.length == 1) {
            return this.handleShopOrPlayerCommand(sender, args[0]);
        }
        if (args.length == 2) {
            return this.handlePlayerShopCommand(sender, args[0], args[1]);
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private boolean handleSellCommand(CommandSender sender, String[] args) {
        String sellSubCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-only", "&cThis command can only be used by a player!"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.sendSellHelpMessage(sender);
            return true;
        }
        switch (sellSubCommand = args[1].toLowerCase()) {
            case "gui": {
                this.plugin.getSellGuiManager().openSellGui(player);
                return true;
            }
            case "hand": {
                this.plugin.getSellGuiManager().sellHandItem(player);
                return true;
            }
            case "all": {
                this.plugin.getSellGuiManager().sellAllItems(player);
                return true;
            }
        }
        this.sendSellHelpMessage(sender);
        return true;
    }

    private boolean handleShopOrPlayerCommand(CommandSender sender, String arg) {
        if (this.plugin.getMenuManager().shopExists(arg)) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-only", "&cThis command can only be used by a player!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("mrultimateshop.shop." + arg)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to access this shop!"));
                return true;
            }
            this.plugin.getMenuManager().openShop(player, arg);
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)arg);
        if (targetPlayer != null) {
            if (!sender.hasPermission("mrultimateshop.command.shop.others")) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to open shop for other players!"));
                return true;
            }
            this.plugin.getMenuManager().openMainMenu(targetPlayer);
            this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("shop.opened-for-player", "{Prefix}&aOpened main shop menu for [player]").replace("[player]", targetPlayer.getName()));
            return true;
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.shop-or-player-not-found", "{Prefix}&cShop or player '[name]' not found!").replace("[name]", arg));
        return true;
    }

    private boolean handlePlayerShopCommand(CommandSender sender, String playerName, String shopName) {
        if (!sender.hasPermission("mrultimateshop.command.shop.others")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to open shop for other players!"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.player-not-found", "&cPlayer '" + playerName + "' not found!"));
            return true;
        }
        if (!this.plugin.getMenuManager().shopExists(shopName)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("errors.shop-not-found", "&cShop '" + shopName + "' not found!"));
            return true;
        }
        this.plugin.getMenuManager().openShop(targetPlayer, shopName);
        this.plugin.sendMessage((Player)sender, this.plugin.getMessageManager().getMessage("shop.opened-shop-for-player", "{Prefix}&aOpened shop '[shop]' for [player]").replace("[shop]", shopName).replace("[player]", targetPlayer.getName()));
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-header", "&a&l[MrUltimateShop] &fShop Commands:"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-main", "&e/shop &f- Opens main shop menu"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-specific", "&e/shop <shop_name> &f- Opens specific shop"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-player", "&e/shop <player> &f- Opens main menu for player"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-player-shop", "&e/shop <player> <shop_name> &f- Opens shop for player"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-gui", "&e/shop sell gui &f- Opens sell GUI"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-hand", "&e/shop sell hand &f- Sells item in hand"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-all", "&e/shop sell all &f- Sells all items in inventory"));
    }

    private void sendSellHelpMessage(CommandSender sender) {
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.sell-help-header", "&a&l[MrUltimateShop] &fSell Commands:"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-gui", "&e/shop sell gui &f- Opens sell GUI"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-hand", "&e/shop sell hand &f- Sells item in hand"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.shop-help-sell-all", "&e/shop sell all &f- Sells all items in inventory"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("mrultimateshop.command.shop.sell")) {
                completions.add("sell");
            }
            if (sender.hasPermission("mrultimateshop.shop")) {
                completions.addAll(this.plugin.getMenuManager().getAvailableShops());
            }
            if (sender.hasPermission("mrultimateshop.command.shop.others")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    completions.add(player.getName());
                }
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("sell")) {
                List<String> sellCommands = Arrays.asList("gui", "hand", "all");
                return sellCommands.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).filter(s -> this.hasPermissionForSellCommand(sender, (String)s)).collect(Collectors.toList());
            }
            if (sender.hasPermission("mrultimateshop.command.shop.others")) {
                return this.plugin.getMenuManager().getAvailableShops().stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return completions;
    }

    private boolean hasPermissionForSellCommand(CommandSender sender, String sellCommand) {
        switch (sellCommand) {
            case "gui": {
                return sender.hasPermission("mrultimateshop.command.shop.sell.gui");
            }
            case "hand": {
                return sender.hasPermission("mrultimateshop.command.shop.sell.hand");
            }
            case "all": {
                return sender.hasPermission("mrultimateshop.command.shop.sell.all");
            }
        }
        return false;
    }
}

