/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.database;

import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibDatabaseManager;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopDatabaseManager {
    private final MrUltimateShop plugin;
    private final String storageType;
    private final MrLibDatabase database;

    public ShopDatabaseManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.storageType = plugin.getConfig().getString("MrUltimateShop.Database.Type", "yml").toLowerCase();
        if ("mysql".equals(this.storageType) || "sqlite".equals(this.storageType)) {
            this.database = this.initializeDatabase();
            if (this.database != null) {
                this.createTables();
            }
        } else {
            this.database = null;
        }
    }

    private MrLibDatabase initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        if ("mysql".equals(this.storageType)) {
            String host = config.getString("MrUltimateShop.Database.MySQL.Host", "localhost");
            int port = config.getInt("MrUltimateShop.Database.MySQL.Port", 3306);
            String dbName = config.getString("MrUltimateShop.Database.MySQL.Database", "ultimateshop");
            String username = config.getString("MrUltimateShop.Database.MySQL.Username", "root");
            String password = config.getString("MrUltimateShop.Database.MySQL.Password", "");
            MrLibDatabase db = MrLibDatabaseManager.registerMySQL((String)this.plugin.getName(), (String)host, (int)port, (String)dbName, (String)username, (String)password);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateShop connected to MySQL database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to MySQL! Using YAML instead.");
            return null;
        }
        if ("sqlite".equals(this.storageType)) {
            String fileName = config.getString("MrUltimateShop.Database.SQLite.FileName", "ultimateshop.db");
            MrLibDatabase db = MrLibDatabaseManager.registerSQLite((JavaPlugin)this.plugin, (String)fileName);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateShop connected to SQLite database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to SQLite! Using YAML instead.");
            return null;
        }
        return null;
    }

    private void createTables() {
        if (this.database == null) {
            return;
        }
        this.database.createTable("player_statistics", "uuid VARCHAR(36) PRIMARY KEY, items_bought INTEGER DEFAULT 0, items_sold INTEGER DEFAULT 0, money_spent DOUBLE DEFAULT 0.0, money_earned DOUBLE DEFAULT 0.0");
        this.database.createTable("demand_tracking", "item_key VARCHAR(255) PRIMARY KEY, demand_level DOUBLE DEFAULT 1.0, last_update BIGINT NOT NULL");
        this.database.createTable("chest_shops", "shop_key VARCHAR(255) PRIMARY KEY, owner_uuid VARCHAR(36) NOT NULL, world VARCHAR(100) NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, item_data TEXT, buy_price DOUBLE, sell_price DOUBLE, stock INTEGER DEFAULT 0");
        MrLibConsoleSayer.MrSay_Success((String)"MrUltimateShop database tables created/verified!");
    }

    public boolean isUsingDatabase() {
        return this.database != null && this.database.isConnected();
    }

    public void close() {
        if (this.database != null) {
            MrLibDatabaseManager.unregister((String)this.plugin.getName());
        }
    }
}

