/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.economy;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.economy.EconomyProvider;
import eu.mrneznamy.mrultimateshop.economy.MrVoteTrainEconomyProvider;
import eu.mrneznamy.mrultimateshop.economy.VaultEconomyProvider;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class EconomyManager {
    private final MrUltimateShop plugin;
    private final Map<String, EconomyProvider> providers;
    private final VaultEconomyProvider vaultProvider;
    private final MrVoteTrainEconomyProvider voteTrainProvider;

    public EconomyManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.providers = new HashMap<String, EconomyProvider>();
        this.vaultProvider = new VaultEconomyProvider();
        this.voteTrainProvider = new MrVoteTrainEconomyProvider((Plugin)plugin);
        this.providers.put("VAULT", this.vaultProvider);
        this.providers.put("MRVOTETRAIN", this.voteTrainProvider);
        this.setupProviders();
    }

    private void setupProviders() {
        boolean voteTrainEnabled;
        boolean vaultEnabled = this.plugin.getConfig().getBoolean("MrUltimateShop.Economy.Vault.Enabled", true);
        if (vaultEnabled) {
            if (this.vaultProvider.isEnabled()) {
                String symbol = this.plugin.getConfig().getString("MrUltimateShop.Economy.Vault.Symbol", "$");
                MrLibConsoleSayer.MrSay_Success((String)("[MrUltimateShop] Vault economy enabled (Symbol: " + symbol + ")"));
            } else {
                MrLibConsoleSayer.MrSay_Warning((String)"[MrUltimateShop] Vault enabled in config but not available");
            }
        }
        if (voteTrainEnabled = this.plugin.getConfig().getBoolean("MrUltimateShop.Economy.MrVoteTrain.Enabled", false)) {
            if (this.voteTrainProvider.isEnabled()) {
                String symbol = this.plugin.getConfig().getString("MrUltimateShop.Economy.MrVoteTrain.Symbol", " VB");
                MrLibConsoleSayer.MrSay_Success((String)("[MrUltimateShop] MrVoteTrain economy enabled (Symbol: " + symbol + ")"));
            } else {
                MrLibConsoleSayer.MrSay_Warning((String)"[MrUltimateShop] MrVoteTrain enabled in config but MrVoteTrain plugin not found");
            }
        }
    }

    public EconomyProvider getProvider(String providerName) {
        if (providerName == null) {
            return this.vaultProvider;
        }
        EconomyProvider provider = this.providers.get(providerName.toUpperCase());
        if (provider != null && provider.isEnabled()) {
            return provider;
        }
        return this.vaultProvider;
    }

    public boolean isProviderEnabled(String providerName) {
        if (providerName == null) {
            return false;
        }
        EconomyProvider provider = this.providers.get(providerName.toUpperCase());
        return provider != null && provider.isEnabled();
    }

    public double getBalance(OfflinePlayer player, String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount, String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.has(player, amount);
    }

    public boolean withdraw(OfflinePlayer player, double amount, String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.withdraw(player, amount);
    }

    public boolean deposit(OfflinePlayer player, double amount, String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.deposit(player, amount);
    }

    public String format(double amount, String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.format(amount);
    }

    public String getCurrencySymbol(String providerName) {
        EconomyProvider provider = this.getProvider(providerName);
        return provider.getCurrencySymbol();
    }

    public VaultEconomyProvider getVaultProvider() {
        return this.vaultProvider;
    }

    public MrVoteTrainEconomyProvider getVoteTrainProvider() {
        return this.voteTrainProvider;
    }
}

